/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGmoney
extends PGobject
implements Serializable,
Cloneable {
    private static final String MONNEY = "money";
    public double value;

    public PGmoney(double _value) {
        this();
        this.value = _value;
    }

    public PGmoney(String _value) throws SQLException {
        this();
        this.setValue(_value);
    }

    public PGmoney() {
        this.setType(MONNEY);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int _result = super.hashCode();
        long temp = Double.doubleToLongBits(this.value);
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        return _result;
    }

    @Override
    public boolean equals(Object objt) {
        if (objt instanceof PGmoney) {
            PGmoney p = (PGmoney)objt;
            return this.value == p.value;
        }
        return false;
    }

    @Override
    public String getValue() {
        if (this.value < 0.0) {
            return "-$" + -this.value;
        }
        return "$" + this.value;
    }

    @Override
    public void setValue(String value) throws SQLException {
        try {
            boolean negativeT = value.charAt(0) == '(';
            String str1 = PGtokenizer.removePara(value).substring(1);
            int position = str1.indexOf(44);
            while (position != -1) {
                str1 = str1.substring(0, position) + str1.substring(position + 1);
                position = str1.indexOf(44);
            }
            this.value = Double.parseDouble(str1);
            this.value = negativeT ? -this.value : this.value;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Con_version of money failed.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)numberFormatException);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

