/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.AbstractBlobClob;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.util.TraceLogger;

public class PgBlob
extends AbstractBlobClob
implements Blob {
    public PgBlob(BaseConnection _conn, long oid) throws SQLException {
        super(_conn, oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public synchronized InputStream getBinaryStream(long position, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        LargeObject subLO = this.getLo(false).copy();
        this.addSubLO(subLO);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (position > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            subLO.seek64(position - 1L, 0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            subLO.seek((int)position - 1, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return subLO.getInputStream(length);
    }

    @Override
    public synchronized int setBytes(long position, byte[] _bytes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.setBytes(position, _bytes, 0, _bytes.length);
    }

    @Override
    public synchronized int setBytes(long position, byte[] _bytes, int _offset, int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.assertPosition(position);
        this.getLo(true).seek((int)(position - 1L));
        this.getLo(true).write(_bytes, _offset, leng);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return leng;
    }
}

