/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

@Deprecated
public class EscapedFunctions {
    public static final int INT0 = 0;
    public static final String POWER_FUNC = "power";
    public static final String ACOS_FUNC = "acos";
    public static final String PI_FUNC = "pi";
    public static final int INT1 = 1;
    public static final String EXP_FUNC = "exp";
    public static final String DEGREES_FUNC = "degrees";
    public static final String CEILING_FUNC = "ceiling";
    public static final String SQRT_FUNC = "sqrt";
    public static final String TAN_FUNC = "tan";
    public static final String COT_FUNC = "cot";
    public static final String COS_FUNC = "cos";
    public static final String MOD_FUNC = "mod";
    public static final String ATAN2_FUNC = "atan2";
    public static final int INT4 = 4;
    public static final String ROUND_FUNC = "round";
    public static final String RADIANS_FUNC = "radians";
    public static final String ABS_FUNC = "abs";
    public static final int INT3 = 3;
    public static final String SIN_FUNC = "sin";
    public static final String ASIN_FUNC = "asin";
    public static final String SIGN_FUNC = "sign";
    public static final String ATAN_FUNC = "atan";
    public static final String CHAR_FUNC = "char";
    public static final int INT6 = 6;
    public static final String ASCII_FUNC = "ascii";
    public static final String UCASE_FUNC = "ucase";
    public static final String SUBSTRING_FUNC = "substring";
    public static final String RIGHT_FUNC = "right";
    public static final String LOG_FUNC = "log";
    public static final String FLOOR_FUNC = "floor";
    public static final int INT5 = 5;
    public static final String TRUNCATE_FUNC = "truncate";
    public static final String LOG10_FUNC = "log10";
    public static final String LTRIM_FUNC = "ltrim";
    public static final int INT8 = 8;
    public static final String LOCATE_FUNC = "locate";
    public static final String LENGTH_FUNC = "length";
    public static final String SPACE_FUNC = "space";
    public static final String RTRIM_FUNC = "rtrim";
    public static final String REPLACE_FUNC = "replace";
    public static final int INT7 = 7;
    public static final String LEFT_FUNC = "left";
    public static final String LCASE_FUNC = "lcase";
    public static final String REPEAT_FUNC = "repeat";
    public static final String INSERT_FUNC = "insert";
    public static final String CONCAT_FUNC = "concat";
    public static final int INT9 = 9;
    public static final String YEAR_FUNC = "year";
    public static final int INT10 = 10;
    public static final String MONTH_FUNC = "month";
    public static final String QUARTER_FUNC = "quarter";
    public static final String DAYOFYEAR_FUNC = "dayofyear";
    public static final String HOUR_FUNC = "hour";
    public static final String CURDATE_FUNC = "curdate";
    public static final String DAYOFMONTH_FUNC = "dayofmonth";
    public static final String WEEK_FUNC = "week";
    public static final String SECOND_FUNC = "second";
    public static final String CURTIME_FUNC = "curtime";
    public static final String DAYNAME_FUNC = "dayname";
    public static final int INT12 = 12;
    public static final String TIMESTAMPDIFF_FUNC = "timestampdiff";
    public static final String SQL_TSI_YEAR_FUNC = "YEAR";
    public static final String MONTHNAME_FUNC = "monthname";
    public static final String NOW_FUNC = "now";
    public static final int INT11 = 11;
    public static final String DAYOFWEEK_FUNC = "dayofweek";
    public static final String MINUTE_FUNC = "minute";
    public static final String SQL_TSI_WEEK_FUNC = "WEEK";
    public static final String SQL_TSI_MONTH_FUNC = "MONTH";
    public static final String SQL_TSI_SECOND_FUNC = "SECOND";
    public static final String TIMESTAMPADD_FUNC = "timestampadd";
    public static final String SQL_TSI_HOUR_FUNC = "HOUR";
    public static final String SQL_TSI_QUARTER_FUNC = "QUARTER";
    public static final String SQL_TSI_DAY_FUNC = "DAY";
    public static final String SQL_TSI_ROOT_FUNC = "SQL_TSI_";
    public static final int INT13 = 13;
    public static final String SQL_TSI_FRAC_SECOND_FUNC = "FRAC_SECOND";
    public static final String SQL_TSI_MINUTE_FUNC = "MINUTE";
    public static final String USER_FUNC = "user";
    public static final int INT14 = 14;
    private static Map<String, Method> funcMapT = EscapedFunctions.createFunctionMap_();
    public static final String DATABASE_FUNC = "database";
    public static final String IFNULL_FUNC = "ifnull";

    private static String constantToInterval(String type, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!type.startsWith(SQL_TSI_ROOT_FUNC)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", type), PSQLState.SYNTAX_ERROR);
        }
        String _shortType = type.substring(SQL_TSI_ROOT_FUNC.length());
        if (SQL_TSI_DAY_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' day' as interval)";
        }
        if (SQL_TSI_SECOND_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' second' as interval)";
        }
        if (SQL_TSI_HOUR_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' hour' as interval)";
        }
        if (SQL_TSI_MINUTE_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' minute' as interval)";
        }
        if (SQL_TSI_MONTH_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' month' as interval)";
        }
        if (SQL_TSI_QUARTER_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST((" + _value + "::int * 3) || ' month' as interval)";
        }
        if (SQL_TSI_WEEK_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' week' as interval)";
        }
        if (SQL_TSI_YEAR_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "CAST(" + _value + " || ' year' as interval)";
        }
        if (SQL_TSI_FRAC_SECOND_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Interval {0} not yet implemented", type), PSQLState.SYNTAX_ERROR);
    }

    public static String _sqltimestampadd(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes three and only three arguments.", TIMESTAMPADD_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String interval = EscapedFunctions.constantToInterval(parsedArgs.get(0).toString(), parsedArgs.get(1).toString());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        _buf.append("(").append(interval).append("+");
        _buf.append(parsedArgs.get(2)).append(")");
        return _buf.toString();
    }

    public static String _sqltimestampdiff(List<?> parsedArgsList) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgsList.size() != 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes three and only three arguments.", TIMESTAMPDIFF_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String datePartT = EscapedFunctions.constantToDatePart(parsedArgsList.get(0).toString());
        StringBuilder stringBuilder = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append("extract( ").append(datePartT).append(" from (").append(parsedArgsList.get(2)).append("-").append(parsedArgsList.get(1)).append("))");
        return stringBuilder.toString();
    }

    public static String _sqlceiling(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("ceil(", CEILING_FUNC, parsedArgs);
    }

    private static Map<String, Method> createFunctionMap_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Method[] arrayMethsT = EscapedFunctions.class.getDeclaredMethods();
        HashMap<String, Method> funcMapT = new HashMap<String, Method>(arrayMethsT.length * 2);
        for (Method methT : arrayMethsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!methT.getName().startsWith("_sql")) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            funcMapT.put(methT.getName().toLowerCase(Locale.US), methT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return funcMapT;
    }

    public static Method getFunction(String funcName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return funcMapT.get("_sql" + funcName.toLowerCase(Locale.US));
    }

    public static String _sqllog10(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("log(", LOG10_FUNC, parsedArgs);
    }

    public static String _sqllog(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("ln(", LOG_FUNC, parsedArgs);
    }

    public static String _sqltruncate(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.twoArgumentsFunctionCall("trunc(", TRUNCATE_FUNC, parsedArgs);
    }

    public static String _sqlpower(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.twoArgumentsFunctionCall("pow(", POWER_FUNC, parsedArgs);
    }

    public static String _sqlchar(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("chr(", CHAR_FUNC, parsedArgs);
    }

    private static String constantToDatePart(String typeT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!typeT.startsWith(SQL_TSI_ROOT_FUNC)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", typeT), PSQLState.SYNTAX_ERROR);
        }
        String _shortType = typeT.substring(SQL_TSI_ROOT_FUNC.length());
        if (SQL_TSI_DAY_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "day";
        }
        if (SQL_TSI_SECOND_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return SECOND_FUNC;
        }
        if (SQL_TSI_HOUR_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return HOUR_FUNC;
        }
        if (SQL_TSI_MINUTE_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return MINUTE_FUNC;
        }
        if (SQL_TSI_FRAC_SECOND_FUNC.equalsIgnoreCase(_shortType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", "SQL_TSI_FRAC_SECOND"), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("Interval {0} not yet implemented", typeT), PSQLState.SYNTAX_ERROR);
    }

    public static String _sqldatabase(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!parsedArgs.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", DATABASE_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "current_database()";
    }

    public static String _sqlinsert(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes four and only four argument.", INSERT_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        _buf.append("overlay(");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(parsedArgs.get(0)).append(" placing ").append(parsedArgs.get(3));
        _buf.append(" from ").append(parsedArgs.get(1)).append(" for ").append(parsedArgs.get(2));
        return _buf.append(')').toString();
    }

    public static String _sqlconcat(List<?> parsedArgs) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        _buf.append('(');
        for (int iArg = 0; iArg < parsedArgs.size(); ++iArg) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buf.append(parsedArgs.get(iArg));
            if (iArg == parsedArgs.size() - 1) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buf.append(" || ");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _buf.append(')').toString();
    }

    public static String _sqllcase(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("lower(", LCASE_FUNC, parsedArgs);
    }

    public static String _sqlleft(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", LEFT_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        _buf.append("substring(");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(parsedArgs.get(0)).append(" for ").append(parsedArgs.get(1));
        return _buf.append(')').toString();
    }

    public static String _sqllength(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", LENGTH_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        _buf.append("length(trim(trailing from ");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(parsedArgs.get(0));
        return _buf.append("))").toString();
    }

    public static String _sqllocate(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "position(" + parsedArgs.get(0) + " in " + parsedArgs.get(1) + ")";
        }
        if (parsedArgs.size() == 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String tmp = "position(" + parsedArgs.get(0) + " in substring(" + parsedArgs.get(1) + " from " + parsedArgs.get(2) + "))";
            return "(" + parsedArgs.get(2) + "*sign(" + tmp + ")+" + tmp + ")";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("{0} function takes two or three arguments.", LOCATE_FUNC), PSQLState.SYNTAX_ERROR);
    }

    public static String _sqlltrim(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("trim(leading from ", LTRIM_FUNC, parsedArgs);
    }

    public static String _sqlrtrim(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("trim(trailing from ", RTRIM_FUNC, parsedArgs);
    }

    public static String _sqlright(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", RIGHT_FUNC), PSQLState.SYNTAX_ERROR);
        }
        StringBuilder _buf = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append("substring(");
        _buf.append(parsedArgs.get(0)).append(" from (length(").append(parsedArgs.get(0)).append(")+1-").append(parsedArgs.get(1));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _buf.append("))").toString();
    }

    public static String _sqlspace(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("repeat(' ',", SPACE_FUNC, parsedArgs);
    }

    public static String _sqlsubstring(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "substr(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + ")";
        }
        if (parsedArgs.size() == 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "substr(" + parsedArgs.get(0) + "," + parsedArgs.get(1) + "," + parsedArgs.get(2) + ")";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("{0} function takes two or three arguments.", SUBSTRING_FUNC), PSQLState.SYNTAX_ERROR);
    }

    public static String _sqlifnull(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.twoArgumentsFunctionCall("coalesce(", IFNULL_FUNC, parsedArgs);
    }

    public static String _sqluser(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!parsedArgs.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", USER_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return USER_FUNC;
    }

    public static String _sqlucase(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("upper(", UCASE_FUNC, parsedArgs);
    }

    public static String _sqlcurdate(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!parsedArgs.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", CURDATE_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "current_date";
    }

    public static String _sqlcurtime(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!parsedArgs.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", CURTIME_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "current_time";
    }

    public static String _sqldayname(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYNAME_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "to_char(" + parsedArgs.get(0) + ",'Day')";
    }

    public static String _sqldayofweek(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", DAYOFWEEK_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "extract(dow from " + parsedArgs.get(0) + ")+1";
    }

    public static String _sqldayofmonth(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(day from ", DAYOFMONTH_FUNC, parsedArgs);
    }

    public static String _sqlhour(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(hour from ", HOUR_FUNC, parsedArgs);
    }

    public static String _sqldayofyear(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(doy from ", DAYOFYEAR_FUNC, parsedArgs);
    }

    public static String _sqlminute(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(minute from ", MINUTE_FUNC, parsedArgs);
    }

    private static String twoArgumentsFunctionCall(String call, String funcName, List<?> parsedArgs) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", funcName), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(call);
        _buf.append(parsedArgs.get(0)).append(',').append(parsedArgs.get(1));
        return _buf.append(')').toString();
    }

    private static String singleArgumentFunctionCall(String call, String funcName, List<?> parsedArgs) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", funcName), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _buf = new StringBuilder();
        _buf.append(call);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(parsedArgs.get(0));
        return _buf.append(')').toString();
    }

    public static String _sqlmonthname(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", MONTHNAME_FUNC), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "to_char(" + parsedArgs.get(0) + ",'Month')";
    }

    public static String _sqlmonth(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(month from ", MONTH_FUNC, parsedArgs);
    }

    public static String _sqlquarter(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(quarter from ", QUARTER_FUNC, parsedArgs);
    }

    public static String _sqlweek(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(week from ", WEEK_FUNC, parsedArgs);
    }

    public static String _sqlsecond(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(second from ", SECOND_FUNC, parsedArgs);
    }

    public static String _sqlyear(List<?> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return EscapedFunctions.singleArgumentFunctionCall("extract(year from ", YEAR_FUNC, parsedArgs);
    }
}

