/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.copy.CopyOperation;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public abstract class CopyOperationImpl
implements CopyOperation {
    QueryExecutorImpl queryExecutorImpl;
    int rowFormat;
    int[] _fieldFormats;
    long handledRowCount = -1L;
    long skippedErrorRowCount = -1L;

    void init(QueryExecutorImpl q, int fmt, int[] fmts) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorImpl = q;
        this.rowFormat = fmt;
        this._fieldFormats = fmts;
    }

    @Override
    public void cancelCopy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorImpl.cancelCopy(this);
    }

    @Override
    public int getFieldCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._fieldFormats.length;
    }

    @Override
    public int getFieldFormat(int _field) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._fieldFormats[_field];
    }

    @Override
    public int getFormat() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rowFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        QueryExecutorImpl queryExecutorImpl = this.queryExecutorImpl;
        synchronized (queryExecutorImpl) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.queryExecutorImpl.hasLock(this);
        }
    }

    public void handleCommandStatus(String status) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (status.startsWith("COPY")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int i = status.lastIndexOf(32);
            this.handledRowCount = i > 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
        } else if (status.startsWith("SKIPPED")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int i = status.indexOf(32);
            int i2 = status.indexOf(32, i + 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.skippedErrorRowCount = i > 3 ? Long.parseLong(status.substring(i + 1, i2)) : -1L;
            i = status.lastIndexOf(32);
            this.handledRowCount = i > status.indexOf("COPY") + 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("CommandComplete expected COPY but got: " + status, new Object[0]), PSQLState.COMMUNICATION_ERROR);
        }
    }

    protected abstract void handleCopydata(byte[] var1) throws PSQLException;

    @Override
    public long getHandledRowCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.handledRowCount;
    }

    @Override
    public long getSkippedErrorRowCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.skippedErrorRowCount;
    }
}

