/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.largeobject.BlobNewOutputStream;
import org.postgresql.util.LOGGER;

public class EsBlob
implements Blob {
    private byte[] buf;
    private Blob blob;
    private long len;
    private PgResultSet rs;
    private int columnIndex;

    public EsBlob(byte[] b) throws SQLException {
        this.len = b.length;
        this.buf = new byte[(int)this.len];
        System.arraycopy(b, 0, this.buf, 0, b.length);
    }

    public EsBlob(byte[] b, PgResultSet rs, int columnIndex) throws SQLException {
        if (b != null) {
            this.len = b.length;
            this.buf = new byte[(int)this.len];
            System.arraycopy(b, 0, this.buf, 0, b.length);
        } else {
            this.len = 0L;
            this.buf = new byte[(int)this.len];
        }
        this.rs = rs;
        this.columnIndex = columnIndex;
    }

    public EsBlob(Blob blob) throws SQLException {
        if (blob == null) {
            throw new SQLException("Cannot instantiate a EsBlob object with a null Blob object");
        }
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
        this.blob = blob;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.isValid();
        if ((long)length > this.len) {
            length = (int)this.len;
        }
        if (pos < 1L || pos > this.len && this.len > 0L || pos > 1L && this.len == 0L) {
            throw new SQLException("Invalid arguments: position cannot be less than 1 or greater than the length of the EsBlob");
        }
        byte[] b = new byte[length];
        System.arraycopy(this.buf, (int)(--pos), b, 0, length);
        return b;
    }

    @Override
    public long length() throws SQLException {
        this.isValid();
        return this.len;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.isValid();
        ByteArrayInputStream stream = new ByteArrayInputStream(this.buf);
        return stream;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.isValid();
        if (start < 1L || start > this.len) {
            return -1L;
        }
        int pos = (int)start - 1;
        int i = 0;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[i] == this.buf[pos]) {
                if ((long)(i + 1) == patlen) {
                    return (long)(pos + 1) - (patlen - 1L);
                }
                ++i;
                ++pos;
                continue;
            }
            if (pattern[i] == this.buf[pos]) continue;
            ++pos;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException, SQLException {
        this.isValid();
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException, SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "pos:{0}, bytes:{1}", pos, bytes);
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int length) throws SQLException, SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "pos:{0} bytes:{1} offset:{2} length:{3}", pos, bytes, offset, length);
        }
        this.isValid();
        if (offset < 0 || offset > bytes.length) {
            throw new SQLException("Invalid offset in byte array set");
        }
        if (length < 0 || length > Integer.MAX_VALUE) {
            throw new SQLException("Invalid length in byte array set");
        }
        if (length == 0) {
            return 0;
        }
        if (pos < 1L || pos + (long)length - 1L > Integer.MAX_VALUE) {
            throw new SQLException("Invalid position in BLOB object set");
        }
        int newlen = 0;
        if (pos <= this.len) {
            long remainlen = this.len - pos + 1L;
            if (remainlen < (long)length) {
                newlen = (int)(this.len + (long)length - remainlen);
            }
        } else {
            newlen = (int)(pos + (long)length - 1L);
        }
        if ((long)newlen > this.len) {
            this.len = newlen;
            byte[] btemp = new byte[(int)this.len];
            btemp = Arrays.copyOf(this.buf, (int)this.len);
            this.buf = btemp;
        }
        int cplen = 0;
        cplen = offset + length > bytes.length ? bytes.length - (int)pos : length;
        System.arraycopy(bytes, offset, this.buf, (int)(--pos), cplen);
        if (this.rs != null) {
            this.rs.insertLob(this);
        }
        return length;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException, SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "pos: {0}", pos);
        }
        this.isValid();
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Invalid position in BLOB object set");
        }
        return new BlobNewOutputStream(this, (int)pos);
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.isValid();
        if (length > this.len) {
            this.len = length;
            byte[] btemp = new byte[(int)this.len];
            btemp = Arrays.copyOf(this.buf, (int)this.len);
            this.buf = btemp;
        } else if ((int)length == 0) {
            this.buf = new byte[0];
            this.len = length;
        } else {
            if (length == this.len) {
                return;
            }
            this.len = length;
            this.buf = this.getBytes(1L, (int)this.len);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.isValid();
        if (pos < 1L || pos > this.len && this.len > 0L || pos > 1L && this.len == 0L) {
            throw new SQLException("Invalid position in BLOB object set");
        }
        if (length < 0L || length > this.len - pos + 1L) {
            throw new SQLException("length is < 0 or pos + length > total number of bytes");
        }
        return new ByteArrayInputStream(this.buf, (int)pos - 1, (int)length);
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
            if (this.blob != null) {
                this.blob.free();
            }
            this.blob = null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EsBlob) {
            EsBlob sb = (EsBlob)obj;
            if (this.len == sb.len) {
                return Arrays.equals(this.buf, sb.buf);
            }
        }
        return false;
    }

    private void isValid() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("Error: You cannot call a method on a PgClob instance once free() has been called.");
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }
}

