/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.executor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.dispatcher.entity.DispatchConnection;
import org.postgresql.dispatcher.executor.AbstractExecuteCommand;
import org.postgresql.dispatcher.executor.DispatchAbstractStatement;
import org.postgresql.dispatcher.executor.command.StatmentCommand;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class DispatchStatementV2
extends DispatchAbstractStatement
implements Statement {
    protected boolean isClosed = false;

    public DispatchStatementV2(DispatchConnection con) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand();
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency) {
        this.dispatchConnection = con;
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency);
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeQuery(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                PgResultSet brs;
                BaseConnection conn = (BaseConnection)t.getConnection();
                ResultSet rs = t.executeQuery(sql);
                if (conn.isSlave() && conn.isZeroResend() && (brs = (PgResultSet)rs).getTupleCount() == 0) {
                    rs.close();
                    throw new PSQLException("resultSet size is 0 ,try to switch to main", PSQLState.NO_DATA);
                }
                return rs;
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public void close() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.close()";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.close();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.cancel();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        AbstractExecuteCommand<SQLWarning> ec = new AbstractExecuteCommand<SQLWarning>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getWarnings";
            }

            @Override
            public SQLWarning execute(Statement t) throws SQLException {
                return t.getWarnings();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void clearWarnings() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.clearWarnings";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearWarnings();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getResultSet()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getResultSet();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getUpdateCount()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSizeModify = true;
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.fetchSizeModify) {
            return this.fetchSize;
        }
        return this.dispatchConnection.getDefaultFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetConcurrency();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int getResultSetType() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetType();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void addBatch(final String sql) throws SQLException {
        if (this.sqlType.equals("NULL") || !this.sqlType.equalsIgnoreCase("insert or delete or update") && !this.sqlType.equalsIgnoreCase("in transaction")) {
            this.getExecuteType(sql);
        }
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.addBatch(" + sql + ")";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.addBatch(sql);
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public void clearBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearBatch();
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeBatch()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public int[] execute(Statement t) throws SQLException {
                return t.executeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dispatchConnection;
    }

    @Override
    public boolean getMoreResults(final int current) throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults(current);
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getGeneratedKeys()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getGeneratedKeys();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetHoldability();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    protected boolean expectionHandler(SQLException e, Statement slave, Statement master) throws SQLException {
        boolean changeSuccess = false;
        if (this.getErrorCode(e)) {
            changeSuccess = true;
        }
        return changeSuccess;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        if (this.mainStatement != null && this.mainStatement.isClosed()) {
            this.isClosed = true;
            if (this.slaveStatement != null && !this.slaveStatement.isClosed()) {
                try {
                    this.slaveStatement.close();
                }
                catch (Exception exception) {}
            }
        } else if (this.slaveStatement != null && this.slaveStatement.isClosed()) {
            this.isClosed = true;
            if (this.mainStatement != null && !this.mainStatement.isClosed()) {
                try {
                    this.mainStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.getLargeUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLargeMaxRows");
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        AbstractExecuteCommand<long[]> ec = new AbstractExecuteCommand<long[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public long[] execute(Statement t) throws SQLException {
                return t.executeLargeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public long executeLargeUpdate(final String sql) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public long executeLargeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public long executeLargeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + "," + columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public long executeLargeUpdate(final String sql, final String[] columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(sql);
        AbstractExecuteCommand<Long> ec = new AbstractExecuteCommand<Long>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeLargeUpdate(" + sql + "," + columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Long execute(Statement t) throws SQLException {
                return t.executeLargeUpdate(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }
}

