/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.core.EncodingPredictor;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ServerErrorMessage
implements Serializable {
    private final Map<Character, String> msgParts = new HashMap<Character, String>();
    private final String _sql;
    private static final Character FILE_CHAR = Character.valueOf('F');
    private static final Character MESSAGE_CHAR = Character.valueOf('M');
    private static final Character POSITION_CAHR = Character.valueOf('P');
    private static final Character WHERE_CHAR = Character.valueOf('W');
    private static final Character ROUTINE_CHAR = Character.valueOf('R');
    private static final Character SCHEMA_CHAR = Character.valueOf('s');
    private static final Character DATATYPE_CHAR = Character.valueOf('d');
    private static final Character SQLSTATE_CHAR = Character.valueOf('C');
    private static final Character INTERNAL_QUERY_CHAR = Character.valueOf('q');
    private static final Character TABLE_CHAR = Character.valueOf('t');
    private static final Character LINE_CHAR = Character.valueOf('L');
    private static final Character HINT_CHAR = Character.valueOf('H');
    private static final Character DETAIL_CAHR = Character.valueOf('D');
    private static final Character SEVERITY_CHAR = Character.valueOf('S');
    private static final Character CONSTRAINT_CHAR = Character.valueOf('n');
    private static final Character INTERNAL_POSITION_CHAR = Character.valueOf('p');
    private static final Character COLUMN_CHAR = Character.valueOf('c');

    public ServerErrorMessage(EncodingPredictor.DecodeResult serverError, String _sql) {
        this(serverError._result, _sql);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (serverError._encoding != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.msgParts.put(MESSAGE_CHAR, this.msgParts.get(MESSAGE_CHAR) + GT.tr(" (kbjdbc: autodetected server-_encoding to be {0}, if the msg is not readable, please check database logs and/or _host, port, dbname, user, password, pg_hba.conf)", serverError._encoding));
        }
    }

    public ServerErrorMessage(String serverError, String _sql) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char[] characters = serverError.toCharArray();
        int length = characters.length;
        for (int position = 0; position < length; ++position) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char msgType = characters[position];
            if (msgType == '\u0000') continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int startString = ++position;
            while (position < length && characters[position] != '\u0000') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++position;
            }
            String msgPart = new String(characters, startString, position - startString);
            this.msgParts.put(Character.valueOf(msgType), msgPart);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        this._sql = _sql;
    }

    public String getSQLState() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(SQLSTATE_CHAR);
    }

    public String getMessage() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(MESSAGE_CHAR);
    }

    public String getSeverity() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(SEVERITY_CHAR);
    }

    public String getDetail() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(DETAIL_CAHR);
    }

    public String getHint() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(HINT_CHAR);
    }

    public int getPosition() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getIntegerPart(POSITION_CAHR);
    }

    public String getWhere() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(WHERE_CHAR);
    }

    public String getSchema() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(SCHEMA_CHAR);
    }

    public String getTable() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(TABLE_CHAR);
    }

    public String getColumn() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(COLUMN_CHAR);
    }

    public String getDatatype() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(DATATYPE_CHAR);
    }

    public String getConstraint() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(CONSTRAINT_CHAR);
    }

    public String getFile() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(FILE_CHAR);
    }

    public int getLine() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getIntegerPart(LINE_CHAR);
    }

    public String getRoutine() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(ROUTINE_CHAR);
    }

    public String getInternalQuery() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.msgParts.get(INTERNAL_QUERY_CHAR);
    }

    public int getInternalPosition() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getIntegerPart(INTERNAL_POSITION_CHAR);
    }

    private int getIntegerPart(Character c) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String str = this.msgParts.get(c);
        if (str == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        return Integer.parseInt(str);
    }

    String getNonSensitiveErrorMessage() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder totalMessageSB = new StringBuilder();
        String msg = this.msgParts.get(SEVERITY_CHAR);
        if (msg != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append(msg).append(": ");
        }
        if ((msg = this.msgParts.get(MESSAGE_CHAR)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append(msg);
        }
        return totalMessageSB.toString();
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder totalMessageSB = new StringBuilder();
        String msg = this.msgParts.get(SEVERITY_CHAR);
        if (msg != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append(msg).append(": ");
        }
        if ((msg = this.msgParts.get(MESSAGE_CHAR)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append(msg);
        }
        if ((msg = this.msgParts.get(DETAIL_CAHR)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append("\n  ").append(GT.tr("Detail: {0}", msg));
        }
        if ((msg = this.msgParts.get(HINT_CHAR)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append("\n  ").append(GT.tr("Hint: {0}", msg));
        }
        if ((msg = this.msgParts.get(POSITION_CAHR)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this._sql != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _sql2 = this.getPosition() > this._sql.length() ? this._sql : this._sql.substring(0, this.getPosition());
                int line = _sql2.split("\n").length;
                String position = line > 1 ? String.valueOf(_sql2.length() - _sql2.lastIndexOf("\n") - 1) : msg;
                totalMessageSB.append("\n  ").append(GT.tr("Position: {0} At Line: {1}, Line Position: {2}", msg, line, position));
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                totalMessageSB.append("\n  ").append(GT.tr("Position: {0}", msg));
            }
        }
        if ((msg = this.msgParts.get(WHERE_CHAR)) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            totalMessageSB.append("\n  ").append(GT.tr("Where: {0}", msg));
        }
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            String internalPosition;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String internalQuery = this.msgParts.get(INTERNAL_QUERY_CHAR);
            if (internalQuery != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                totalMessageSB.append("\n  ").append(GT.tr("Internal Query: {0}", internalQuery));
            }
            if ((internalPosition = this.msgParts.get(INTERNAL_POSITION_CHAR)) != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                totalMessageSB.append("\n  ").append(GT.tr("Internal Position: {0}", internalPosition));
            }
            String file = this.msgParts.get(FILE_CHAR);
            String line = this.msgParts.get(LINE_CHAR);
            String routine = this.msgParts.get(ROUTINE_CHAR);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (file != null || line != null || routine != null) {
                totalMessageSB.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", file, routine, line));
            }
            if ((msg = this.msgParts.get(SQLSTATE_CHAR)) != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                totalMessageSB.append("\n  ").append(GT.tr("Server SQLState: {0}", msg));
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return totalMessageSB.toString();
    }
}

