/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.core.BaseQueryKey;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.CallableQueryKey;
import org.postgresql.core.JdbcCallParseInfo;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.QueryWithReturningColumnsKey;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.util.LruCache;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean outParmBeforeFunc;
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + String.valueOf(key);
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || queryKey.escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        String schemaName = null;
        String funName = null;
        JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), this.queryExecutor.getEscapeSyntaxCallMode(), this.queryExecutor.getStoreCase());
        if (key instanceof CallableQueryKey) {
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
            schemaName = callInfo.getSchemaName();
            funName = callInfo.getFunName();
        } else {
            parsedSql = callInfo.getSql();
            isFunction = false;
            outParmBeforeFunc = false;
        }
        boolean isParameterized = key instanceof String || queryKey.isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), this.queryExecutor.getCompatibleLevel(), returningColumns);
        this.addPrimaryKeys(queries);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction, outParmBeforeFunc, schemaName, funName);
    }

    void addPrimaryKeys(List<NativeQuery> queries) throws SQLException {
        for (int i = 0; i < queries.size(); ++i) {
            NativeQuery nativeQuery = queries.get(i);
            String todo = nativeQuery.nativeSql;
            if (this.isPlsql(todo) || !this.hasForUpdate(todo)) continue;
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(todo, ";");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (this.isAdd(str)) {
                    nativeQuery.forupdate = true;
                    StringBuffer sbf = new StringBuffer();
                    Pattern flag2 = Pattern.compile("\\sfrom\\s", 2);
                    Matcher matcher2 = flag2.matcher(str);
                    if (matcher2.find()) {
                        matcher2.appendReplacement(sbf, ",ctid,xmin from ");
                    }
                    matcher2.appendTail(sbf);
                    sb.append(sbf.toString() + ";");
                    if (nativeQuery.bindPositions == null || nativeQuery.bindPositions.length == 0) continue;
                    int j = 0;
                    while (j < nativeQuery.bindPositions.length) {
                        int n = j++;
                        nativeQuery.bindPositions[n] = nativeQuery.bindPositions[n] + 10;
                    }
                    continue;
                }
                sb.append(str + ";");
            }
            nativeQuery.nativeSql = sb.toString();
        }
    }

    boolean isAdd(String sql) {
        Pattern INTO_REGEX = Pattern.compile("\\sINTO\\s", 2);
        Pattern CREATE_REGEX = Pattern.compile("[\\s]*CREATE\\s", 2);
        return !INTO_REGEX.matcher(sql).find() && !CREATE_REGEX.matcher(sql).find() && this.hasForUpdate(sql);
    }

    boolean hasForUpdate(String sql) {
        Pattern SELECT_REGEX = Pattern.compile("[\\s]*SELECT\\s", 2);
        Pattern FOR_UPDATE_REGEX = Pattern.compile("\\sFOR[\\s]+UPDATE[\\s]*", 2);
        return SELECT_REGEX.matcher(sql).find() && FOR_UPDATE_REGEX.matcher(sql).find();
    }

    boolean isPlsql(String sql) {
        Pattern BEGIN_REGEX = Pattern.compile("[\\s]*BEGIN\\s", 2);
        Pattern PLSQL_TYPE_BODY_REGEX = Pattern.compile("[\\s]*CREATE([\\s]+OR[\\s]+REPLACE)?([\\s]+(NON)?EDITIONABLE)?[\\s]+TYPE[\\s]+BODY[\\s]+([^\\s]*[\\s]+)?(IS|AS)\\s", 2);
        Pattern PLSQL_PACKAGE_BODY_REGEX = Pattern.compile("[\\s]*CREATE([\\s]+OR[\\s]+REPLACE)?([\\s]+(NON)?EDITIONABLE)?[\\s]+PACKAGE[\\s]+BODY[\\s]+([^\\s]*[\\s]+)?(IS|AS)\\s", 2);
        Pattern PLSQL_PACKAGE_DEFINITION_REGEX = Pattern.compile("[\\s]*CREATE([\\s]+OR[\\s]+REPLACE)?([\\s]+(NON)?EDITIONABLE)?[\\s]+PACKAGE[\\s]+([^\\s]*[\\s]+)?(IS|AS)\\s", 2);
        return BEGIN_REGEX.matcher(sql).find() || PLSQL_TYPE_BODY_REGEX.matcher(sql).find() || PLSQL_PACKAGE_BODY_REGEX.matcher(sql).find() || PLSQL_PACKAGE_DEFINITION_REGEX.matcher(sql).find();
    }
}

