/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.postgresql.PGProperty;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.v3.ConnectionFactoryImpl;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public abstract class ConnectionFactory {
    public static QueryExecutor openConnection(HostSpec[] _hostSpecs, String user, String database, Properties info, int _version, Object cCMV2) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        if (protoName == null || protoName.isEmpty() || "3".equals(protoName)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ConnectionFactoryImpl _connectionFactory = new ConnectionFactoryImpl();
            QueryExecutor queryExecutorImpl = ((ConnectionFactory)_connectionFactory).openConnectionImpl(_hostSpecs, user, database, info, _version, cCMV2);
            if (queryExecutorImpl != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return queryExecutorImpl;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new PSQLException(GT.tr("A _connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, int var5, Object var6) throws SQLException;

    protected void closeStream(PGStream newStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

