/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.logging.Level;
import org.postgresql.core.Utils;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PSQLSavepoint
implements Savepoint,
Cloneable {
    private boolean _isValid;
    private final boolean isNamed;
    private int id;
    private String name;

    public PSQLSavepoint(int id) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._isValid = true;
        this.isNamed = false;
        this.id = id;
    }

    public PSQLSavepoint(String name) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._isValid = true;
        this.isNamed = true;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._isValid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._isValid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this.isNamed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.name;
    }

    public void invalidate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._isValid = false;
    }

    public String getPGName() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this._isValid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Utils.escapeIdentifier(null, this.name).toString();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "JDBC_SAVEPOINT_" + this.id;
    }

    public PSQLSavepoint clone() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PSQLSavepoint savepoint = null;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            savepoint = (PSQLSavepoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            e.printStackTrace();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return savepoint;
    }
}

