/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.util.Properties;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.ssl.LibKCIFactory;
import org.postgresql.util.GT;
import org.postgresql.util.ObjectFactory;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return SocketFactory.getDefault();
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ObjectFactory.instantiate(SocketFactory.class, socketFactoryClassName, info, true, PGProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String classname = PGProperty.SSL_FACTORY.get(info);
        if (classname == null || "org.postgresql.ssl.jdbc4.LibPQFactory".equals(classname) || "org.postgresql.ssl.LibPQFactory".equals(classname)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new LibKCIFactory(info);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ObjectFactory.instantiate(SSLSocketFactory.class, classname, info, true, PGProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

