/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.replication.fluent.logical;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.core.BaseConnection;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.ReplicationSlotInfo;
import org.postgresql.replication.ReplicationType;
import org.postgresql.replication.fluent.AbstractCreateSlotBuilder;
import org.postgresql.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;

public class LogicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedLogicalCreateSlotBuilder>
implements ChainedLogicalCreateSlotBuilder {
    private String outputPlugin;
    private String startLsn;

    public LogicalCreateSlotBuilder(BaseConnection connection) {
        super(connection);
    }

    @Override
    protected ChainedLogicalCreateSlotBuilder self() {
        return this;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withOutputPlugin(String outputPlugin) {
        this.outputPlugin = outputPlugin;
        return this.self();
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withStartLsn(String startLsn) {
        this.startLsn = startLsn;
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() throws SQLException {
        if (this.outputPlugin == null || this.outputPlugin.isEmpty()) {
            throw new IllegalArgumentException("OutputPlugin required parameter for logical replication slot");
        }
        if (this.slotName == null || this.slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slotName can't be null");
        }
        Statement statement = this.connection.createStatement();
        ResultSet result = null;
        ReplicationSlotInfo slotInfo = null;
        try {
            statement.execute(String.format("CREATE_REPLICATION_SLOT %s %s LOGICAL %s %s", this.slotName, this.temporaryOption ? "TEMPORARY" : "", this.outputPlugin, this.startLsn == null || this.startLsn.isEmpty() ? "" : this.startLsn));
            result = statement.getResultSet();
            if (result != null && result.next()) {
                slotInfo = new ReplicationSlotInfo(result.getString("slot_name"), ReplicationType.LOGICAL, LogSequenceNumber.valueOf(result.getString("consistent_point")), result.getString("snapshot_name"), result.getString("output_plugin"));
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            statement.close();
        }
        return slotInfo;
    }
}

