/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.sqlParser.sql;

import java.sql.SQLException;
import org.postgresql.PGProperty;
import org.postgresql.dispatcher.entity.DispatchConnection;
import org.postgresql.dispatcher.parser.ParseException;
import org.postgresql.dispatcher.parser.statement.AbstractStatement;
import org.postgresql.dispatcher.parser.statement.BeginStatement;
import org.postgresql.dispatcher.parser.statement.EndStatement;
import org.postgresql.dispatcher.parser.statement.MasterStatement;
import org.postgresql.dispatcher.parser.statement.OtherStatement;
import org.postgresql.dispatcher.parser.statement.SelectStatement;
import org.postgresql.dispatcher.parser.statement.SetStatement;
import org.postgresql.dispatcher.parser.statement.Statement;
import org.postgresql.dispatcher.parser.statement.TransactionStatement;
import org.postgresql.util.Word;

public class SqlParser {
    private Statement stmt;
    private String commandText = "";
    private String strategyValue;

    public String getStrategyValue() {
        return this.strategyValue;
    }

    public SqlParser(String _sql, String strategyValue) {
        this.commandText = _sql.trim().endsWith(";") ? _sql.trim().substring(0, _sql.trim().length() - 1) : _sql.trim();
        this.strategyValue = strategyValue;
    }

    public Statement doParse(DispatchConnection dispatchConnection) throws ParseException {
        try {
            this.stmt = this.parse(dispatchConnection);
            this.stmt.setCommandText(this.commandText);
            return this.stmt;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public Statement getParsedStatement() {
        return this.stmt;
    }

    public final Statement parse(DispatchConnection dispatchConnection) throws SQLException {
        int _result;
        AbstractStatement stmt = null;
        String blackSqlList = PGProperty.BLACKSQLLIST.get(dispatchConnection.m_pros);
        if (blackSqlList != null) {
            String[] _sqls;
            for (String _sql : _sqls = blackSqlList.split(";")) {
                if (!_sql.equalsIgnoreCase(this.commandText)) continue;
                return new MasterStatement();
            }
        }
        if (this.commandText.toLowerCase().startsWith("begin")) {
            return new BeginStatement();
        }
        if (this.commandText.toLowerCase().startsWith("commit") || this.commandText.toLowerCase().startsWith("rollback") || this.commandText.toLowerCase().startsWith("end")) {
            return new EndStatement();
        }
        if (this.commandText.toLowerCase().startsWith("set") || this.commandText.toLowerCase().startsWith("reset")) {
            return new SetStatement();
        }
        if (this.commandText.toLowerCase().contains("nextval") || this.commandText.toLowerCase().contains("currvalue") || this.commandText.toLowerCase().contains("setvalue") || this.commandText.toLowerCase().contains("lastvalue")) {
            return new OtherStatement();
        }
        stmt = !dispatchConnection.getAutoCommit() ? (dispatchConnection.isHasUpdate() ? new TransactionStatement() : ("2".equals(this.strategyValue) ? ((_result = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.allSendFunctionList, dispatchConnection.tempTables, dispatchConnection.masterKeyword)) == 1 ? new SelectStatement() : (_result == 2 ? new MasterStatement() : (_result == 3 ? new SetStatement() : new OtherStatement()))) : new TransactionStatement())) : ((_result = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.allSendFunctionList, dispatchConnection.tempTables, dispatchConnection.masterKeyword)) == 1 ? new SelectStatement() : (_result == 3 ? new SetStatement() : new OtherStatement()));
        return stmt;
    }
}

