/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.util.logging.Level;
import org.postgresql.util.TraceLogger;

public enum JavaVersion {
    version_1_6,
    version_1_7,
    version_1_8,
    version_other;

    private static final JavaVersion RUNTIME_VERSION;

    public static JavaVersion getRuntimeVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return RUNTIME_VERSION;
    }

    public static JavaVersion from(String _version) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_version.startsWith("1.6")) {
            return version_1_6;
        }
        if (_version.startsWith("1.7")) {
            return version_1_7;
        }
        if (_version.startsWith("1.8")) {
            return version_1_8;
        }
        return version_other;
    }

    static {
        RUNTIME_VERSION = JavaVersion.from(System.getProperty("java.version"));
    }
}

