/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.AbstractTypeInfoCache;
import org.postgresql.jdbc.MysqlTypeInfoCache;
import org.postgresql.jdbc.PgTypeInfoCache;
import org.postgresql.jdbc.TypeInfoCache;

public class TypeInfoCacheFactory {
    private volatile AbstractTypeInfoCache typeInfoCache;

    public TypeInfoCacheFactory(BaseConnection connection, TypeInfoCache typeInfoCache) {
        this.updateCompatibleLevel(connection, typeInfoCache);
    }

    public void updateCompatibleLevel(BaseConnection connection, TypeInfoCache typeinfo) {
        this.typeInfoCache = "mysql".equalsIgnoreCase(connection.getCompatibleLevel()) ? new MysqlTypeInfoCache(typeinfo) : new PgTypeInfoCache(typeinfo);
    }

    public AbstractTypeInfoCache getTypeInfoCache() {
        return this.typeInfoCache;
    }
}

