/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.postgresql.core.ParameterList;
import org.postgresql.core.SqlCommand;
import org.postgresql.util.TraceLogger;

public class NativeQuery {
    private static final String[] BIND_NAMES_ARRAY = new String[1280];
    private static final int[] NO_BINDS = new int[0];
    public String nativeSql;
    public final int[] _bindPositions;
    public final List<String> _bindParamNames = new ArrayList<String>();
    public final SqlCommand sqlCommand;
    public final boolean isMultiStat;
    public boolean forupdate;

    public NativeQuery(String nativeSql, SqlCommand sqlCommand) {
        this(nativeSql, NO_BINDS, null, true, sqlCommand);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public NativeQuery(String nativeSql, int[] _bindPositions, List<String> _bindParamNames, boolean multiStatement, SqlCommand sqlCommand) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.nativeSql = nativeSql;
        this._bindPositions = _bindPositions == null || _bindPositions.length == 0 ? NO_BINDS : _bindPositions;
        this._bindParamNames.addAll(_bindParamNames == null ? new ArrayList() : _bindParamNames);
        this.isMultiStat = multiStatement;
        this.sqlCommand = sqlCommand;
    }

    public String toString(ParameterList _parameters) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._bindPositions.length == 0) {
            return this.nativeSql;
        }
        int queryLength = this.nativeSql.length();
        String[] _params = new String[this._bindPositions.length];
        for (int i = 1; i <= this._bindPositions.length; ++i) {
            String _param;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _params[i - 1] = _param = _parameters == null ? "?" : _parameters.toString(i, true);
            queryLength += _param.length() - NativeQuery._bindName(i).length();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder s_buf = new StringBuilder(queryLength);
        s_buf.append(this.nativeSql, 0, this._bindPositions[0]);
        for (int i = 1; i <= this._bindPositions.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            s_buf.append(_params[i - 1]);
            int nextBind = i < this._bindPositions.length ? this._bindPositions[i] : this.nativeSql.length();
            s_buf.append(this.nativeSql, this._bindPositions[i - 1] + NativeQuery._bindName(i).length(), nextBind);
        }
        return s_buf.toString();
    }

    public static String _bindName(int _index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _index < BIND_NAMES_ARRAY.length ? BIND_NAMES_ARRAY[_index] : "$" + _index;
    }

    public static StringBuilder appendBindName(StringBuilder sbu, int _index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_index < BIND_NAMES_ARRAY.length) {
            return sbu.append(NativeQuery._bindName(_index));
        }
        sbu.append('$');
        sbu.append(_index);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return sbu;
    }

    public static int calculateBindLength(int _bindCount) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int res = 0;
        int _bindLen = 2;
        int maxBindsOfLen = 9;
        while (_bindCount > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int numBinds = Math.min(maxBindsOfLen, _bindCount);
            _bindCount -= numBinds;
            res += _bindLen * numBinds;
            ++_bindLen;
            maxBindsOfLen *= 10;
        }
        return res;
    }

    public SqlCommand getCommand() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.sqlCommand;
    }

    static {
        for (int k = 1; k < BIND_NAMES_ARRAY.length; ++k) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            NativeQuery.BIND_NAMES_ARRAY[k] = "$" + k;
        }
    }
}

