/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.replication.fluent;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.fluent.ChainedCommonStreamBuilder;
import org.postgresql.util.TraceLogger;

public abstract class AbstractStreamBuilder<T extends ChainedCommonStreamBuilder<T>>
implements ChainedCommonStreamBuilder<T> {
    private static final long DURATION_VAL = 10L;
    private static final int DFT_STAT_INTVL_T = (int)TimeUnit.SECONDS.toMillis(10L);
    protected int statIntvlMsT = DFT_STAT_INTVL_T;
    protected String slotNameT;
    protected LogSequenceNumber startPosT = LogSequenceNumber.INVALID_LSN;

    private long getDurationVal() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 10L;
    }

    @Override
    public T withStatusInterval(int timeT, TimeUnit formatT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.statIntvlMsT = (int)TimeUnit.MILLISECONDS.convert(timeT, formatT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        T mySelf = this.getSelf();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return mySelf;
    }

    protected abstract T getSelf();

    @Override
    public T withStartPosition(LogSequenceNumber outterLogSeqNumber) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.startPosT = outterLogSeqNumber;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        T mySelf = this.getSelf();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return mySelf;
    }

    @Override
    public T withSlotName(String outterSlotName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.slotNameT = outterSlotName;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        T self = this.getSelf();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return self;
    }
}

