/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.postgresql.Driver;
import org.postgresql.osgi.PGDataSourceFactory;
import org.postgresql.util.TraceLogger;

public class PGBundleActivator
implements BundleActivator {
    private ServiceRegistration<?> registrationT;

    public void start(BundleContext _context) throws Exception {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Hashtable<String, String> propesT = new Hashtable<String, String>();
        ((Dictionary)propesT).put("osgi.jdbc.driver.class", Driver.class.getName());
        ((Dictionary)propesT).put("osgi.jdbc.driver.name", "PostgreSQL JDBC Driver");
        ((Dictionary)propesT).put("osgi.jdbc.driver.version", "42.2.9");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.registrationT = _context.registerService(DataSourceFactory.class.getName(), (Object)new PGDataSourceFactory(), propesT);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String msg = noClassDefFoundError.getMessage();
            if (msg != null && msg.contains("org/osgi/service/jdbc/DataSourceFactory")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!Boolean.getBoolean("pgjdbc.osgi.debug")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                new IllegalArgumentException("Unable to load DataSourceFactory. Will ignore DataSourceFactory registration. If you need one, ensure org.osgi.enterprise is on the classpath", noClassDefFoundError).printStackTrace();
                return;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw noClassDefFoundError;
        }
    }

    public void stop(BundleContext _context) throws Exception {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.registrationT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.registrationT.unregister();
            this.registrationT = null;
        }
        if (Driver.isRegistered()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Driver.deregister();
        }
    }
}

