/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.replication.fluent;

import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.ReplicationProtocol;
import org.postgresql.replication.PGReplicationStream;
import org.postgresql.replication.fluent.ChainedStreamBuilder;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import org.postgresql.replication.fluent.logical.LogicalStreamBuilder;
import org.postgresql.replication.fluent.logical.StartLogicalReplicationCallback;
import org.postgresql.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import org.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import org.postgresql.replication.fluent.physical.PhysicalStreamBuilder;
import org.postgresql.replication.fluent.physical.StartPhysicalReplicationCallback;
import org.postgresql.util.TraceLogger;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConn;

    public ReplicationStreamBuilder(BaseConnection _connection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConn = _connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConn.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConn.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

