/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.TypeInfoCacheFactory;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> pgNameToSQLType;
    private Map<String, String> pgNameToJavaClass;
    private Map<Integer, String> oidToPgName;
    private Map<String, Integer> pgNameToOid;
    private Map<String, Class<? extends PGobject>> pgNameToKbObject;
    private Map<Integer, Integer> pgArrayToKbType;
    private Map<Integer, Character> arrayOidToDelimiter;
    private BaseConnection baseConnection;
    protected final int unknownLength;
    private PreparedStatement getTypeWithModStatementPst;
    private PreparedStatement getTypeInfoStatement2Pst;
    private TypeInfoCacheFactory typeInfoCacheFactory;
    private PreparedStatement getTypeInfoStatementPst;
    private PreparedStatement getOidStatementSimplePst;
    private PreparedStatement getNameStatementPst;
    private PreparedStatement getArrayElementOidStatementPst;
    private PreparedStatement getArrayDelimiterStatementPst;
    private PreparedStatement getOidStatementComplexNonArrayPst;
    private PreparedStatement getOidStatementComplexArrayPst;
    private static Set<Integer> caseSensitiveSet = new HashSet<Integer>();
    private static Set<Integer> signedSet;
    private static Set<Integer> requiresQuotingSqlTypeSet;

    public Object[][] getTypes() {
        return this.typeInfoCacheFactory.getTypeInfoCache().getTypes();
    }

    public HashMap<String, String> getTypeAliases() {
        return this.typeInfoCacheFactory.getTypeInfoCache().getTypeAliases();
    }

    public TypeInfoCache(BaseConnection _conn, int unknownLength) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection = _conn;
        this.typeInfoCacheFactory = new TypeInfoCacheFactory(_conn, this);
        this.unknownLength = unknownLength;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.oidToPgName = new HashMap<Integer, String>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgNameToOid = new HashMap<String, Integer>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgNameToJavaClass = new HashMap<String, String>((int)Math.round((double)this.getTypes().length * 1.5));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgNameToKbObject = new HashMap<String, Class<? extends PGobject>>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgArrayToKbType = new HashMap<Integer, Integer>((int)Math.round((double)this.getTypes().length * 1.5));
        this.arrayOidToDelimiter = new HashMap<Integer, Character>((int)Math.round((double)this.getTypes().length * 2.5));
        this.pgNameToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)this.getTypes().length * 1.5)));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Object[] type : this.getTypes()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer _sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, _sqlType, javaClass, arrayOid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgNameToJavaClass.put("hstore", Map.class.getName());
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer _sqlType, String javaClass, Integer arrayOid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgNameToJavaClass.put(pgTypeName, javaClass);
        this.pgNameToOid.put(pgTypeName, oid);
        this.oidToPgName.put(oid, pgTypeName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgArrayToKbType.put(arrayOid, oid);
        this.pgNameToSQLType.put(pgTypeName, _sqlType);
        Character delimiter = Character.valueOf(',');
        this.arrayOidToDelimiter.put(oid, delimiter);
        this.arrayOidToDelimiter.put(arrayOid, delimiter);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String pgArrayTypeName = pgTypeName + "[]";
        this.pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this.pgNameToSQLType.put(pgArrayTypeName, 2003);
        this.pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this.pgNameToSQLType.put(pgArrayTypeName, 2003);
            this.pgNameToOid.put(pgArrayTypeName, arrayOid);
            this.oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgNameToKbObject.put(type, klass);
        this.pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.pgNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(Object _param) throws SQLException {
        ResultSet resultSet;
        String pgTypeName;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oid = 0;
        if (_param instanceof Integer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oid = (Integer)_param;
            pgTypeName = this.getPGType(oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            pgTypeName = (String)_param;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (pgTypeName.endsWith("[]")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 2003;
        }
        Integer i = this.pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return i;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = "SELECT typinput='array_in'::regproc, typtype   FROM PG_CATALOG.PG_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname       from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_param instanceof Integer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getTypeInfoStatement2Pst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + " WHERE pg_type.oid = ? " + " ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getTypeInfoStatement2Pst = this.baseConnection.prepareStatement(_sql);
            }
            this.getTypeInfoStatement2Pst.setInt(1, oid);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!((BaseStatement)((Object)this.getTypeInfoStatement2Pst)).executeWithFlags(16)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = this.getTypeInfoStatement2Pst.getResultSet();
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getTypeInfoStatementPst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = _sql + " WHERE typname = ? " + " ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getTypeInfoStatementPst = this.baseConnection.prepareStatement(_sql);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.getTypeInfoStatementPst.setString(1, pgTypeName);
            if (!((BaseStatement)((Object)this.getTypeInfoStatementPst)).executeWithFlags(16)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = this.getTypeInfoStatementPst.getResultSet();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer typeT = null;
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean isArrayT = resultSet.getBoolean(1);
            String typtype = resultSet.getString(2);
            if (isArrayT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 2003;
            } else if ("c".equals(typtype)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 2002;
            } else if ("d".equals(typtype)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 2001;
            } else if ("e".equals(typtype)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                typeT = 12;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (typeT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            typeT = 1111;
        }
        resultSet.close();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgNameToSQLType.put(pgTypeName, typeT);
        return typeT;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        String nameT;
        String schemaNameT;
        String fullNameT;
        PreparedStatement oidStatementComplexPst;
        String _sql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndexT = pgTypeName.indexOf(46);
        if (dotIndexT == -1 && !hasQuote && !isArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getOidStatementSimplePst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _sql2 = "SELECT pg_type.oid, typname   FROM PG_CATALOG.PG_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname               from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getOidStatementSimplePst = this.baseConnection.prepareStatement(_sql2);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String lcName = pgTypeName.toLowerCase();
            this.getOidStatementSimplePst.setString(1, lcName);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.getOidStatementSimplePst;
        }
        if (isArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.getOidStatementComplexArrayPst == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.baseConnection.haveMinimumServerVersion(ServerVersion.v8_3)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sql = "SELECT t.typarray, arra.typname   FROM PG_CATALOG.PG_type t  JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid  JOIN PG_CATALOG.PG_type arra ON arra.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _sql = "SELECT t.oid, t.typname   FROM PG_CATALOG.PG_type t  JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM PG_CATALOG.PG_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.getOidStatementComplexArrayPst = this.baseConnection.prepareStatement(_sql);
            }
            oidStatementComplexPst = this.getOidStatementComplexArrayPst;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (null == this.getOidStatementComplexNonArrayPst) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql = "SELECT t.oid, t.typname   FROM PG_CATALOG.PG_type t  JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArrayPst = this.baseConnection.prepareStatement(_sql);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oidStatementComplexPst = this.getOidStatementComplexNonArrayPst;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String string = fullNameT = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndexT == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaNameT = null;
            nameT = fullNameT;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (fullNameT.startsWith("\"")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (fullNameT.endsWith("\"")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String[] parts = fullNameT.split("\"\\.\"");
                    schemaNameT = parts.length == 2 ? parts[0] + "\"" : null;
                    nameT = parts.length == 2 ? "\"" + parts[1] : parts[0];
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int lastDotIndex = fullNameT.lastIndexOf(46);
                    nameT = fullNameT.substring(lastDotIndex + 1);
                    schemaNameT = fullNameT.substring(0, lastDotIndex);
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                schemaNameT = fullNameT.substring(0, dotIndexT);
                nameT = fullNameT.substring(dotIndexT + 1);
            }
        }
        if (schemaNameT != null && schemaNameT.startsWith("\"") && schemaNameT.endsWith("\"")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaNameT = schemaNameT.substring(1, schemaNameT.length() - 1);
        } else if (schemaNameT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaNameT = schemaNameT.toLowerCase();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (nameT.startsWith("\"") && nameT.endsWith("\"")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nameT = nameT.substring(1, nameT.length() - 1);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nameT = nameT.toLowerCase();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidStatementComplexPst.setString(1, nameT);
        oidStatementComplexPst.setString(2, schemaNameT);
        oidStatementComplexPst.setBoolean(3, schemaNameT == null);
        return oidStatementComplexPst;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer oid = this.pgNameToOid.get(pgTypeName);
        if (oid != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oid = 0;
        ResultSet resultSet = oidStatement.getResultSet();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            oid = (int)resultSet.getLong(1);
            String internalName = resultSet.getString(2);
            this.oidToPgName.put(oid, internalName);
            this.pgNameToOid.put(internalName, oid);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgNameToOid.put(pgTypeName, oid);
        resultSet.close();
        return oid;
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        String pgTypeName = this.oidToPgName.get(oid);
        if (pgTypeName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return pgTypeName;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getNameStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM PG_CATALOG.PG_type t JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getNameStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getNameStatementPst.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getNameStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getNameStatementPst.getResultSet();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean onPath = resultSet.getBoolean(1);
            String schemaName = resultSet.getString(2);
            String name = resultSet.getString(3);
            if (onPath) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pgTypeName = name;
                this.pgNameToOid.put(schemaName + "." + name, oid);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pgTypeName = "\"" + schemaName + "\".\"" + name + "\"";
                if (schemaName.equals(schemaName.toLowerCase()) && schemaName.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.pgNameToOid.put(schemaName + "." + name, oid);
                }
            }
            this.pgNameToOid.put(pgTypeName, oid);
            this.oidToPgName.put(oid, pgTypeName);
        }
        resultSet.close();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return pgTypeName;
    }

    @Override
    public synchronized String getPGTypeWithMod(int oid, int mod) throws SQLException {
        int position;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        String pgTypeNameWithMod = new String();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getTypeWithModStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "select pg_catalog.format_type(?,?)";
            this.getTypeWithModStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getTypeWithModStatementPst.setInt(1, oid);
        this.getTypeWithModStatementPst.setInt(2, mod);
        if (!((BaseStatement)((Object)this.getTypeWithModStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getTypeWithModStatementPst.getResultSet();
        if (resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            pgTypeNameWithMod = resultSet.getString(1);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        resultSet.close();
        if (oid != 7002 && oid != 7000 && (position = pgTypeNameWithMod.indexOf(40)) != -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            pgTypeNameWithMod = pgTypeNameWithMod.substring(0, position);
        }
        return pgTypeNameWithMod;
    }

    @Override
    public int getPGArrayType(String elementTypeNameT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        elementTypeNameT = this.getTypeForAlias(elementTypeNameT);
        return this.getPGType(elementTypeNameT + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int oidT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Integer iT = this.pgArrayToKbType.get(oidT);
        if (iT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return oidT;
        }
        return iT;
    }

    @Override
    public synchronized char getArrayDelimiter(int oidT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oidT == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ',';
        }
        Character delimiter = this.arrayOidToDelimiter.get(oidT);
        if (delimiter != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return delimiter.charValue();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getArrayDelimiterStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT e.typdelim FROM PG_CATALOG.PG_type t, PG_CATALOG.PG_type e WHERE t.oid = ? and t.typelem = e.oid";
            this.getArrayDelimiterStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getArrayDelimiterStatementPst.setInt(1, oidT);
        if (!((BaseStatement)((Object)this.getArrayDelimiterStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getArrayDelimiterStatementPst.getResultSet();
        if (!resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = resultSet.getString(1);
        delimiter = Character.valueOf(s.charAt(0));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.arrayOidToDelimiter.put(oidT, delimiter);
        resultSet.close();
        return delimiter.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        Integer pgType = this.pgArrayToKbType.get(oid);
        if (pgType != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return pgType;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getArrayElementOidStatementPst == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM PG_CATALOG.PG_type t JOIN PG_CATALOG.PG_type e ON t.typelem = e.oid JOIN PG_CATALOG.PG_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getArrayElementOidStatementPst = this.baseConnection.prepareStatement(_sql);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.getArrayElementOidStatementPst.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayElementOidStatementPst)).executeWithFlags(16)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = this.getArrayElementOidStatementPst.getResultSet();
        if (!resultSet.next()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        pgType = (int)resultSet.getLong(1);
        boolean onPath = resultSet.getBoolean(2);
        String schemaName = resultSet.getString(3);
        String name = resultSet.getString(4);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgArrayToKbType.put(oid, pgType);
        this.pgNameToOid.put(schemaName + "." + name, pgType);
        String fullName = "\"" + schemaName + "\".\"" + name + "\"";
        this.pgNameToOid.put(fullName, pgType);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (onPath && name.equals(name.toLowerCase())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.oidToPgName.put(pgType, name);
            this.pgNameToOid.put(name, pgType);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.oidToPgName.put(pgType, fullName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        resultSet.close();
        return pgType;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.pgNameToKbObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String pgTypeName = this.getPGType(oid);
        String _result = this.pgNameToJavaClass.get(pgTypeName);
        if (_result != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _result;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getSQLType(pgTypeName) == 2003) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _result = "java.sql.Array";
            this.pgNameToJavaClass.put(pgTypeName, _result);
        }
        return _result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String type = this.getTypeAliases().get(alias);
        if (type != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return type;
        }
        if (alias.indexOf(34) == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            type = this.getTypeAliases().get(alias.toLowerCase());
            if (type != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return type;
            }
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getPrecision(oid, typemod);
    }

    @Override
    public int getColumnSize(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getColumnSize(oid, typemod);
    }

    @Override
    public int getScale(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getScale(oid, typemod);
    }

    @Override
    public boolean isCaseSensitive(int oidT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.convertArrayToBaseOid(oidT);
        if (caseSensitiveSet.contains(oidT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int baseOid = this.convertArrayToBaseOid(oid);
        if (signedSet.contains(baseOid)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int getDisplaySize(int oid, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCacheFactory.getTypeInfoCache().getDisplaySize(oid, typemod);
    }

    @Override
    public int getMaximumPrecision(int oidT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.convertArrayToBaseOid(oidT);
        if (oidT == 1700) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1000;
        }
        if (oidT == 1266 || oidT == 1083 || oidT == 7950) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 6;
        }
        if (oidT == 1186 || oidT == 1114 || oidT == 1184 || oidT == 7952 || oidT == 7954) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 6;
        }
        if (oidT == 1043 || oidT == 1042 || oidT == 8018 || oidT == 8016) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0xA00000;
        }
        if (oidT == 1562 || oidT == 1560) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0x5000000;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(_sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (requiresQuotingSqlTypeSet.contains(_sqlType)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        caseSensitiveSet.add(8100);
        caseSensitiveSet.add(26);
        caseSensitiveSet.add(21);
        caseSensitiveSet.add(7014);
        caseSensitiveSet.add(7016);
        caseSensitiveSet.add(7015);
        caseSensitiveSet.add(20);
        caseSensitiveSet.add(23);
        caseSensitiveSet.add(701);
        caseSensitiveSet.add(700);
        caseSensitiveSet.add(16);
        caseSensitiveSet.add(1700);
        caseSensitiveSet.add(1562);
        caseSensitiveSet.add(1560);
        caseSensitiveSet.add(8020);
        caseSensitiveSet.add(1082);
        caseSensitiveSet.add(1114);
        caseSensitiveSet.add(1083);
        caseSensitiveSet.add(1266);
        caseSensitiveSet.add(7950);
        caseSensitiveSet.add(7944);
        caseSensitiveSet.add(7952);
        caseSensitiveSet.add(7954);
        caseSensitiveSet.add(1186);
        caseSensitiveSet.add(1184);
        caseSensitiveSet.add(7000);
        caseSensitiveSet.add(7002);
        signedSet = new HashSet<Integer>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        signedSet.add(7014);
        signedSet.add(8100);
        signedSet.add(7015);
        signedSet.add(21);
        signedSet.add(23);
        signedSet.add(7016);
        signedSet.add(700);
        signedSet.add(20);
        signedSet.add(1700);
        signedSet.add(701);
        signedSet.add(7000);
        signedSet.add(7002);
        requiresQuotingSqlTypeSet = new HashSet<Integer>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        requiresQuotingSqlTypeSet.add(8);
        requiresQuotingSqlTypeSet.add(-5);
        requiresQuotingSqlTypeSet.add(4);
        requiresQuotingSqlTypeSet.add(6);
        requiresQuotingSqlTypeSet.add(5);
        requiresQuotingSqlTypeSet.add(7);
        requiresQuotingSqlTypeSet.add(2);
        requiresQuotingSqlTypeSet.add(-6);
        requiresQuotingSqlTypeSet.add(-7);
        requiresQuotingSqlTypeSet.add(3);
    }
}

