/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.executor;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.postgresql.PGProperty;
import org.postgresql.core.ParameterList;
import org.postgresql.dispatcher.entity.DispatchConnection;
import org.postgresql.dispatcher.entity.FakeConnection;
import org.postgresql.dispatcher.executor.command.StatementCreateCommand;
import org.postgresql.dispatcher.parser.statement.Statement;
import org.postgresql.dispatcher.sqlParser.sql.SqlParser;
import org.postgresql.jdbc.PgCallableStatement;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PgPreparedStatement;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class DispatchAbstractStatement {
    public static final int DISPATCH_TYPE_MAIN = 0;
    public static final int DISPATCH_TYPE_SLAVE = 1;
    public static final int DISPATCH_TYPE_ALL = 2;
    public static final int DISPATCH_TYPE_ALL_CURRENT = 3;
    protected DispatchConnection dispatchConnection;
    protected java.sql.Statement mainStatement;
    protected java.sql.Statement slaveStatement;
    StatementCreateCommand<? extends java.sql.Statement> createCommand;
    String strategyValue;
    String _sqlType = "NULL";
    private boolean slaveConnectionDisable;
    protected volatile int dispatchType;
    protected volatile int currentDispatchType;
    ParameterList record_main_prepl = null;
    ParameterList record_slave_prepl = null;
    java.sql.Statement record_main_stm = null;
    java.sql.Statement record_slave_stm = null;
    protected static final String TYPE_INTRANSACTION = "in transaction";
    private static final String TYPE_UPDATE_IN_INTRANSACTION = "update in transaction";
    private static final String TYPE_SELECT = "select";
    private static final String TYPE_SET = "set or reset";
    protected static final String TYPE_UPDATE = "insert or delete or update";
    private String slave_key = "";
    Statement _sqlStmt = null;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected boolean escapeProcessing = true;
    protected int queryTimeout = 0;
    protected String cursorName;
    protected int fetchDirection = 1000;
    protected boolean fetchSizeModify;
    protected int fetchSize = 0;
    protected boolean poolable;
    protected boolean closeOnCompletion;

    public void cleanStatement() throws SQLException {
        if (this.mainStatement != null) {
            this.record_main_stm = this.mainStatement;
            this.mainStatement.close();
            this.mainStatement = null;
        }
        if (this.slaveStatement != null) {
            this.record_slave_stm = this.slaveStatement;
            this.slaveStatement.close();
            this.slaveStatement = null;
        }
    }

    public synchronized java.sql.Statement getMainStatement() throws SQLException {
        if (this.mainStatement == null) {
            Connection _conn = this.dispatchConnection.getMainConn();
            if (_conn instanceof FakeConnection) {
                throw new PSQLException("Master _connection is FakeConnection.", PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            this.mainStatement = this.createCommand.getStatement(_conn);
        }
        return this.mainStatement;
    }

    public List<java.sql.Statement> getAllStatement() throws SQLException {
        ArrayList<java.sql.Statement> _result = new ArrayList<java.sql.Statement>();
        _result.add(this.getMainStatement());
        int slaveCount = this.dispatchConnection.slaveCount;
        java.sql.Statement st = this.slaveStatement;
        while (slaveCount-- > 0) {
            if (this.slaveStatement != null) {
                this.slaveStatement = null;
            }
            this.slaveStatement = this.getSlaveStatement();
            if (this.slaveStatement == null) continue;
            _result.add(this.slaveStatement);
        }
        if (st != null) {
            this.resetStmtInfo(this.slaveStatement, st);
        }
        return _result;
    }

    public synchronized java.sql.Statement getSlaveStatement() throws SQLException {
        if (this.slaveStatement == null) {
            Connection _conn = null;
            int tempsttartSlaveID = 0;
            for (int j = 0; j < this.dispatchConnection.slaveCount; ++j) {
                String _key = "";
                if (PGProperty.STABLE_SLAVE.getBoolean(this.dispatchConnection.m_pros) || PGProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) == 2) {
                    _key = DispatchConnection.SLAVE + this.dispatchConnection.stable_slave_key;
                    j = this.dispatchConnection.slaveCount;
                    LOGGER.log(Level.INFO, "STABLE_SLAVE get _key: [SLAVE" + _key + "] ", new Object[0]);
                } else if (PGProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) == 3) {
                    LOGGER.log(Level.INFO, "CONSUMET_TIME get _key: [SLAVE" + _key + "] ", new Object[0]);
                } else {
                    tempsttartSlaveID = this.dispatchConnection.lastSlaveID.getAndIncrement();
                    _key = DispatchConnection.SLAVE + Math.abs(tempsttartSlaveID % this.dispatchConnection.slaveCount);
                }
                this.slave_key = _key;
                _conn = this.dispatchConnection.getSlaveConnection(_key);
                if (_conn instanceof FakeConnection) {
                    int masterport;
                    String node = this.dispatchConnection.pCMV2.nodeMap.get(((FakeConnection)_conn).getSlaveIP() + ":" + ((FakeConnection)_conn).getSlavePort());
                    String dmsg = String.format("getSlaveStatement: slave_online_ip is : {%s}  FakeConnection is: {%s}", this.dispatchConnection.pCMV2.slave_online_ip, node);
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, dmsg, new Object[0]);
                    }
                    String sip = this.dispatchConnection.pCMV2.slave_online_ip;
                    String[] sip_arra = sip.split(",");
                    int i = 0;
                    for (i = 0; i < sip_arra.length; ++i) {
                        if (!sip_arra[i].equalsIgnoreCase(node)) continue;
                        ((FakeConnection)_conn).setSlaveStatus(true);
                        String debugmsg = String.format("getSlaveStatement: need recreate slave _connection for : {%s}", node);
                        if (!LOGGER.isLoggable(Level.INFO)) break;
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        break;
                    }
                    if (((FakeConnection)_conn).getSlaveStatus()) continue;
                    String masterip = "";
                    String debugmsg = "";
                    Connection master_con = this.dispatchConnection.getMainConn();
                    if (master_con instanceof PgConnection) {
                        masterip = ((PgConnection)master_con).getHostIp();
                        masterport = ((PgConnection)master_con).getHostPort();
                        debugmsg = String.format("getSlaveStatement: offline slave _connection for : {%s} and Master ip is :{%s}", node, this.dispatchConnection.pCMV2.nodeMap.get(masterip + ":" + masterport));
                    } else if (master_con instanceof FakeConnection) {
                        masterip = ((FakeConnection)master_con).getSlaveIP();
                        masterport = ((FakeConnection)master_con).getSlavePort();
                        debugmsg = String.format("getSlaveStatement: offline slave _connection for : {%s} and FakeMaster ip is :{%s}", node, this.dispatchConnection.pCMV2.nodeMap.get(masterip + ":" + masterport));
                    }
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    continue;
                }
                String node = this.dispatchConnection.pCMV2.nodeMap.get(((PgConnection)_conn).getHostIp() + ":" + ((PgConnection)_conn).getHostPort());
                if (!this.dispatchConnection.pCMV2.slave_online_ip.contains(node)) {
                    LOGGER.log(Level.INFO, node + " can _connect, but is not included in slave_online_ip.", new Object[0]);
                    _conn = null;
                    continue;
                }
                if (PGProperty.STABLE_SLAVE.getBoolean(this.dispatchConnection.m_pros) || PGProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) != 1) break;
                break;
            }
            if (_conn == null || _conn instanceof FakeConnection) {
                return null;
            }
            this.slaveStatement = this.createCommand.getStatement(_conn);
        }
        return this.slaveStatement;
    }

    public List<java.sql.Statement> getAllCurrentStatement() throws SQLException {
        ArrayList<java.sql.Statement> _result = new ArrayList<java.sql.Statement>();
        if (this.mainStatement != null) {
            _result.add(this.mainStatement);
        }
        if (this.slaveStatement != null) {
            _result.add(this.slaveStatement);
        }
        return _result;
    }

    protected int getExecuteType(String _sql) {
        int _result;
        block11: {
            _result = 0;
            if (this.strategyValue == null) {
                this.strategyValue = PGProperty.TRANSACTIONDISPATCHSTRATEGY.get(this.dispatchConnection.m_pros);
            }
            SqlParser oscarParser = new SqlParser(_sql, this.strategyValue);
            try {
                this._sqlStmt = oscarParser.doParse(this.dispatchConnection);
                this.strategyValue = oscarParser.getStrategyValue();
                this._sqlType = "NULL";
                int type = this._sqlStmt.getSQLType();
                switch (type) {
                    case 0: {
                        _result = 0;
                        this._sqlType = TYPE_INTRANSACTION;
                        this.add(1);
                        break;
                    }
                    case 1: {
                        _result = 0;
                        this._sqlType = TYPE_UPDATE_IN_INTRANSACTION;
                        this.add(1);
                        break;
                    }
                    case 2: {
                        _result = 1;
                        _result = this.changeExecuteType();
                        this._sqlType = TYPE_SELECT;
                        break;
                    }
                    case 5: {
                        _result = 2;
                        this._sqlType = TYPE_SET;
                        this.add(1 + this.dispatchConnection.slaveCount);
                        break;
                    }
                    default: {
                        _result = 0;
                        this._sqlType = TYPE_UPDATE;
                        this.add(1);
                    }
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, " getExecuteType (session={0} _sql={1} _sqlType={2})", this.dispatchConnection, _sql, this._sqlType);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                LOGGER.log(Level.SEVERE, " prase (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
        if (this.dispatchConnection.slaveCount == 0) {
            _result = 0;
        }
        return _result;
    }

    protected int getExecuteType() {
        return this.dispatchType;
    }

    protected ParameterList recordParamlist(java.sql.Statement st) {
        ParameterList prepl = null;
        if (st instanceof PgPreparedStatement) {
            prepl = ((PgPreparedStatement)st).getPreParmlist();
        } else if (st instanceof PgCallableStatement) {
            prepl = ((PgCallableStatement)st).getPreParmlist();
        }
        return prepl;
    }

    protected void resetParamlist(java.sql.Statement st, ParameterList prepl) {
        if (st instanceof PgPreparedStatement) {
            ((PgPreparedStatement)st).setPreParmlist(prepl);
        } else if (st instanceof PgCallableStatement) {
            ((PgCallableStatement)st).setPreParmlist(prepl);
        }
    }

    protected void resetStmtInfo(java.sql.Statement current_st, java.sql.Statement record_st) {
        if (current_st instanceof PgStatement) {
            ((PgStatement)current_st).copyStatementInfo((PgStatement)record_st);
        }
        if (current_st instanceof PgPreparedStatement) {
            ((PgPreparedStatement)current_st).copyPreparedStatementInfo((PgPreparedStatement)record_st);
        }
        if (current_st instanceof PgCallableStatement) {
            ((PgCallableStatement)current_st).copyCallableStatementInfo((PgCallableStatement)record_st);
        }
    }

    private synchronized void reconnect() throws SQLException {
        if (this.dispatchConnection.isClosed()) {
            LOGGER.log(Level.INFO, "CloseConnectCluter and ReConnectCluter", new Object[0]);
            this.dispatchConnection.CloseConnectCluter();
            this.dispatchConnection.ReConnectCluter();
            this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_pros);
            this.dispatchConnection.resetConnInfo();
        }
    }

    protected <R> R executeTemplet(ExecuteCommand<R> command, int dispatchType) throws SQLException {
        String debugmsg;
        this.currentDispatchType = dispatchType;
        R r = null;
        StringBuilder _sql = null;
        java.sql.Statement st = null;
        if (LOGGER.isLoggable(Level.INFO)) {
            _sql = new StringBuilder();
            _sql.append("Main session: ").append(this.dispatchConnection).append(", ").append(DispatchAbstractStatement.class).append(", executeTemplet()" + command.getFunctionName() + " ,dispatchType :").append(dispatchType + " ");
            debugmsg = String.format("executeTemplet (Main session={%s} command={%s} dispatchType={%s})", this.dispatchConnection, command.getFunctionName(), dispatchType);
            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
        }
        if (this.dispatchConnection.getLastSqlType() != null && this.dispatchConnection.getLastSqlType().equals(TYPE_INTRANSACTION)) {
            this._sqlType = TYPE_INTRANSACTION;
        }
        AtomicLong t1 = new AtomicLong(System.currentTimeMillis());
        block12 : switch (dispatchType) {
            case 0: {
                try {
                    st = this.getMainStatement();
                    if (command.isExecuteFunction()) {
                        this.resetStatement(st);
                    }
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    r = command.execute(st);
                    if (this.dispatchConnection.getAutoCommit() || !command.isExecuteFunction() || !this._sqlType.equalsIgnoreCase(TYPE_UPDATE)) break;
                    this.dispatchConnection.setHasUpdate(true);
                    this._sqlType = TYPE_INTRANSACTION;
                    if (!LOGGER.isLoggable(Level.INFO)) break;
                    LOGGER.log(Level.INFO, "Enter transactional state from _sql[" + this._sqlStmt.getCommandText() + "].", new Object[0]);
                    break;
                }
                catch (SQLException e) {
                    if (this.expectionHandler(e, null, null) && (this._sqlType.equals("NULL") || !this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                        int looperation;
                        if (LOGGER.isLoggable(Level.INFO) && st != null) {
                            LOGGER.log(Level.INFO, "Error Main stmt url:" + ((PgConnection)st.getConnection()).getURL() + "\n", new Object[0]);
                        }
                        if ((looperation = this.dispatchConnection.retrytimes) <= 0) {
                            this.dispatchConnection.close();
                            throw e;
                        }
                        int interval = this.dispatchConnection.retryinterval;
                        while (looperation-- > 0) {
                            try {
                                if (this.dispatchConnection.isClosed()) {
                                    this.reconnect();
                                    if (!this.dispatchConnection.CheckIsMaster(this.dispatchConnection.getMainConn())) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.log(Level.INFO, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_main_stm != null) {
                                    this.resetStmtInfo(st, this.record_main_stm);
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to master stmt, send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                r = command.execute(st);
                                if (!this.dispatchConnection.getAutoCommit() && command.isExecuteFunction() && this._sqlType.equalsIgnoreCase(TYPE_UPDATE)) {
                                    this.dispatchConnection.setHasUpdate(true);
                                    this._sqlType = TYPE_INTRANSACTION;
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Enter transactional state from _sql[" + this._sqlStmt.getCommandText() + "].", new Object[0]);
                                    }
                                }
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                break block12;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to master SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                if (looperation > 0) {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Connect Main _error retry _connect:" + looperation + " Exception \n", new Object[0]);
                                    }
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        LOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to master retry maximnum times still SQLException: %s", ei.getMessage());
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                                    LOGGER.log(Level.SEVERE, ei);
                                }
                                this.dispatchConnection.close();
                                throw new SQLException(debugmsg, ei.getSQLState());
                            }
                            catch (InterruptedException e1) {
                                LOGGER.log(Level.SEVERE, e1);
                            }
                        }
                        break;
                    }
                    if (this.expectionHandler(e, null, null)) {
                        this.dispatchConnection.close();
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        debugmsg = String.format("failare execute in Master Exception: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    throw e;
                }
            }
            case 1: {
                try {
                    st = this.getSlaveStatement();
                    if (st == null) {
                        this.currentDispatchType = 0;
                        st = this.getMainStatement();
                        if (command.isExecuteFunction()) {
                            this.resetStatement(st);
                        }
                        this.slaveStatement = st;
                        this.record_slave_stm = st;
                        if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                            debugmsg = String.format("getSlaveStatement _error ,send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        r = command.execute(st);
                        break;
                    }
                    if (command.isExecuteFunction() && this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) {
                        this.currentDispatchType = 0;
                        this.dispatchType = 0;
                        this.cleanStatement();
                        st = this.getMainStatement();
                        if (this.record_slave_stm != null) {
                            this.resetStmtInfo(st, this.record_slave_stm);
                        }
                        this.resetStatement(st);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", ((PgConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        r = command.execute(st);
                        break;
                    }
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to slave session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    if (command.isExecuteFunction()) {
                        this.resetStatement(st);
                    }
                    r = command.execute(st);
                    break;
                }
                catch (SQLException e) {
                    if (command.getFunctionName().contains("executeBatch")) {
                        if (this.expectionHandler(e, null, null)) {
                            this.dispatchConnection.close();
                        }
                        throw e;
                    }
                    int looperation = this.dispatchConnection.retrytimes;
                    if (looperation == 0 && this.currentDispatchType == 1 && !this.expectionHandler(e, null, null)) {
                        ++looperation;
                    }
                    if (looperation <= 0) {
                        this.dispatchConnection.close();
                        throw e;
                    }
                    int interval = this.dispatchConnection.retryinterval;
                    SQLException excep = e;
                    while (looperation-- > 0) {
                        try {
                            if (this.currentDispatchType == 1) {
                                if (this.expectionHandler(excep, null, null)) {
                                    this.dispatchConnection.setSlaveToFakebyKey(this.slave_key);
                                    this.cleanStatement();
                                    st = this.getSlaveStatement();
                                    if (st != null) {
                                        this.resetStmtInfo(st, this.record_slave_stm);
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            debugmsg = String.format("Send to slave exception: (%s) ,change this to anoter slave db: (slave={%s}).Send to slave session: (session={%s} url={%s} st={%s} _sqlType={%s})", e.getMessage(), ((PgConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                        }
                                        r = command.execute(st);
                                        break block12;
                                    }
                                }
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_slave_stm != null) {
                                    this.resetStmtInfo(st, this.record_slave_stm);
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to slave exception: (%s) ,change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", e.getMessage(), ((PgConnection)st.getConnection()).getHostIp() + ":" + ((PgConnection)st.getConnection()).getHostPort(), this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                r = command.execute(st);
                                break block12;
                            }
                            this.currentDispatchType = 0;
                            this.dispatchType = 0;
                            if (this.dispatchConnection.isClosed()) {
                                this.reconnect();
                                if (this.dispatchConnection.getMainConn() == null) {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                    }
                                    Thread.sleep(interval * 1000);
                                    continue;
                                }
                            }
                            this.cleanStatement();
                            st = this.getMainStatement();
                            if (this.record_main_stm != null) {
                                this.resetStmtInfo(st, this.record_main_stm);
                            }
                            if (LOGGER.isLoggable(Level.INFO)) {
                                debugmsg = String.format("Send switch slave to master session, send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                            }
                            r = command.execute(st);
                            break block12;
                        }
                        catch (SQLException ei) {
                            if (!this.expectionHandler(ei, null, null)) {
                                throw ei;
                            }
                            excep = ei;
                            if (LOGGER.isLoggable(Level.INFO)) {
                                debugmsg = String.format("Send to master from switch slave SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                            }
                            if (looperation > 0) {
                                try {
                                    Thread.sleep(interval * 1000);
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                                continue;
                            }
                            debugmsg = String.format("Send to master from switch slave retry failare maxtimes still SQLException: %s", ei.getMessage());
                            if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                            }
                            this.dispatchConnection.close();
                            throw new SQLException(debugmsg, ei.getSQLState());
                        }
                        catch (InterruptedException e1) {
                            LOGGER.log(Level.SEVERE, e1);
                        }
                    }
                    break;
                }
            }
            case 2: {
                List<java.sql.Statement> list = null;
                try {
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to all session: (_sql={%s}, _sqlType={%s})", _sql.toString(), this._sqlType);
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    list = this.getAllStatement();
                    Iterator<java.sql.Statement> i$ = list.iterator();
                    while (i$.hasNext()) {
                        java.sql.Statement stm;
                        st = stm = i$.next();
                        if (command.isExecuteFunction()) {
                            this.resetStatement(st);
                        }
                        r = command.execute(st);
                    }
                }
                catch (SQLException e) {
                    if (!this.expectionHandler(e, null, null) && st != null && ((PgConnection)st.getConnection()).isSlave()) break;
                    if (this.expectionHandler(e, null, null) && (this._sqlType.equals("NULL") || !this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                        int looperation = this.dispatchConnection.retrytimes;
                        if (looperation <= 0) {
                            this.dispatchConnection.close();
                            throw e;
                        }
                        int interval = this.dispatchConnection.retryinterval;
                        while (looperation-- > 0) {
                            try {
                                if (this.dispatchConnection.isClosed()) {
                                    this.reconnect();
                                    if (this.dispatchConnection.getMainConn() == null) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.log(Level.INFO, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_main_stm != null) {
                                    this.resetStmtInfo(st, this.record_main_stm);
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to all stmt,send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                r = command.execute(st);
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to AllStatement SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                if (looperation > 0) {
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        LOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to AllStatement retry maxtimes still SQLException: %s", ei.getMessage());
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                this.dispatchConnection.close();
                                throw new SQLException(debugmsg, ei.getSQLState());
                            }
                            catch (InterruptedException e1) {
                                LOGGER.log(Level.SEVERE, e1);
                            }
                        }
                    }
                    if (this.expectionHandler(e, null, null)) {
                        this.dispatchConnection.close();
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        debugmsg = String.format("failare execute in all main and slave SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    throw e;
                }
                for (int i = 1; list != null && i < list.size() - 1; ++i) {
                    list.get(i).close();
                }
                break;
            }
            case 3: {
                List<java.sql.Statement> lis = this.getAllCurrentStatement();
                if (LOGGER.isLoggable(Level.INFO)) {
                    _sql.append(", send to current:");
                    for (java.sql.Statement t : lis) {
                        _sql.append("session : ").append(this.dispatchConnection).append(" , url:").append(((PgConnection)t.getConnection()).getURL() + " st" + st).append(" , ");
                    }
                    debugmsg = String.format("Send to current session: (_sql={%s},_sqlType={%s})", _sql.toString(), this._sqlType);
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                block40: for (java.sql.Statement t : lis) {
                    try {
                        r = command.execute(t);
                    }
                    catch (SQLException e) {
                        if (this.expectionHandler(e, null, null) && (this._sqlType.equals("NULL") || !this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                            int looperation = this.dispatchConnection.retrytimes;
                            if (looperation <= 0) {
                                this.dispatchConnection.close();
                                throw e;
                            }
                            int interval = this.dispatchConnection.retryinterval;
                            while (looperation-- > 0) {
                                try {
                                    if (this.dispatchConnection.isClosed()) {
                                        this.reconnect();
                                        if (this.dispatchConnection.getMainConn() == null) {
                                            if (LOGGER.isLoggable(Level.INFO)) {
                                                LOGGER.log(Level.INFO, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                            }
                                            Thread.sleep(interval * 1000);
                                            continue;
                                        }
                                    }
                                    this.cleanStatement();
                                    st = this.getMainStatement();
                                    if (this.record_main_stm != null) {
                                        this.resetStmtInfo(st, this.record_main_stm);
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to current stmt,send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((PgConnection)st.getConnection()).getURL(), st, this._sqlType);
                                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                    }
                                    r = command.execute(st);
                                    this.currentDispatchType = 0;
                                    this.dispatchType = 0;
                                    continue block40;
                                }
                                catch (SQLException ei) {
                                    if (!this.expectionHandler(ei, null, null)) {
                                        throw ei;
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to current SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                    }
                                    if (looperation > 0) {
                                        try {
                                            Thread.sleep(interval * 1000);
                                        }
                                        catch (InterruptedException e1) {
                                            LOGGER.log(Level.SEVERE, e1);
                                        }
                                        continue;
                                    }
                                    debugmsg = String.format("Send to current retry failare maxtimes still SQLException: %s", ei.getMessage());
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                    }
                                    this.dispatchConnection.close();
                                    throw new SQLException(debugmsg, ei.getSQLState());
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                            }
                            continue;
                        }
                        if (this.expectionHandler(e, null, null)) {
                            this.dispatchConnection.close();
                        }
                        if (LOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("failare execute in current stmt SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        throw e;
                    }
                }
                break;
            }
        }
        if (command.isExecuteFunction()) {
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            if (LOGGER.isLoggable(Level.INFO)) {
                if (st instanceof PreparedStatement) {
                    debugmsg = dispatchType == 0 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] master consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), ((PgConnection)st.getConnection()).getBackendPID(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get()) : (dispatchType == 1 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] slave consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), ((PgConnection)st.getConnection()).getBackendPID(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get()) : (dispatchType == 2 ? String.format("url=[%s] _sql=[%s] all consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get()) : String.format("url=[%s] _sql=[%s] current consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get())));
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                } else {
                    debugmsg = dispatchType == 0 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] master consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), ((PgConnection)st.getConnection()).getBackendPID(), command.getFunctionName(), t2.get()) : (dispatchType == 1 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] slave consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), ((PgConnection)st.getConnection()).getBackendPID(), command.getFunctionName(), t2.get()) : (dispatchType == 2 ? String.format("url=[%s] _sql=[%s] all consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), command.getFunctionName(), t2.get()) : String.format("url=[%s] _sql=[%s] current consume time:::[%s](ms)", ((PgConnection)st.getConnection()).getURL(), command.getFunctionName(), t2.get())));
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
            }
            this.dispatchConnection.setLastSqlType(this._sqlType);
        }
        return r;
    }

    protected boolean getErrorCode(SQLException e) {
        boolean _flag = false;
        if (e.getSQLState() == null) {
            _flag = true;
            return _flag;
        }
        if (PSQLState.isConnectionError(e.getSQLState()) || e.getSQLState().equals("57P01") || e.getSQLState().equals("57P02") || e.getSQLState().equals("57P03")) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "getErrorCode: (SQLState={0},Message={1})", e.getSQLState(), e.getMessage());
            }
            _flag = true;
        }
        return _flag;
    }

    private Integer changeExecuteType() {
        int _result = 1;
        String rate = PGProperty.HOSTLOADRATE.get(this.dispatchConnection.m_pros);
        if (Integer.valueOf(rate) > 0) {
            BigDecimal _hostRate;
            String url = this.dispatchConnection.url;
            if (this.dispatchConnection.pCMV2.totalA_count.get(url).get() == Integer.MAX_VALUE) {
                _hostRate = new BigDecimal(this.dispatchConnection.pCMV2._hostA_count.get(url).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.totalA_count.get(url).get()), 2, 1);
                this.dispatchConnection.pCMV2.totalA_count.get(url).set(100);
                this.dispatchConnection.pCMV2._hostA_count.get(url).set(_hostRate.multiply(new BigDecimal(100)).intValue());
            }
            this.dispatchConnection.pCMV2.totalA_count.get(url).incrementAndGet();
            if (this.dispatchConnection.pCMV2._hostA_count.get(url).get() > 0) {
                _hostRate = new BigDecimal(this.dispatchConnection.pCMV2._hostA_count.get(url).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.totalA_count.get(url).get()), 2, 1);
                if (_hostRate.multiply(new BigDecimal(100)).compareTo(new BigDecimal(rate)) == -1) {
                    _result = 0;
                    this.dispatchConnection.pCMV2._hostA_count.get(url).incrementAndGet();
                }
            } else {
                _result = 0;
                this.dispatchConnection.pCMV2._hostA_count.get(url).incrementAndGet();
            }
        }
        return _result;
    }

    public void add(int _count) {
        if (PGProperty.HOSTLOADRATE.getIntNoCheck(this.dispatchConnection.m_pros) > 0) {
            String url = this.dispatchConnection.url;
            if (this.dispatchConnection.pCMV2.totalA_count.get(url).get() + _count > Integer.MAX_VALUE) {
                BigDecimal _hostRate = new BigDecimal(this.dispatchConnection.pCMV2._hostA_count.get(url).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.totalA_count.get(url).get()), 2, 1);
                this.dispatchConnection.pCMV2.totalA_count.get(url).set(100);
                this.dispatchConnection.pCMV2._hostA_count.get(url).set(_hostRate.multiply(new BigDecimal(100)).intValue());
            }
            this.dispatchConnection.pCMV2.totalA_count.get(url).addAndGet(_count);
            this.dispatchConnection.pCMV2._hostA_count.get(url).incrementAndGet();
        }
    }

    protected StatementCreateCommand<? extends java.sql.Statement> getCommand() {
        return this.createCommand;
    }

    protected abstract boolean expectionHandler(SQLException var1, java.sql.Statement var2, java.sql.Statement var3) throws SQLException;

    public void resetStatement(java.sql.Statement st) throws SQLException {
        st.setMaxFieldSize(this.maxFieldSize);
        st.setMaxRows(this.maxRows);
        st.setEscapeProcessing(this.escapeProcessing);
        st.setQueryTimeout(this.queryTimeout);
        st.setCursorName(this.cursorName);
        st.setFetchDirection(this.fetchDirection);
        if (this.fetchSizeModify) {
            st.setFetchSize(this.fetchSize);
        }
        st.setPoolable(this.poolable);
        if (this.closeOnCompletion) {
            ((PgStatement)st).closeOnCompletion();
        }
    }

    protected static interface ExecuteCommand<R> {
        public boolean isExecuteFunction();

        public String getFunctionName();

        public R execute(java.sql.Statement var1) throws SQLException;
    }
}

