/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.util.TraceLogger;

public class ExpressionProperties
extends Properties {
    private static final Pattern EXPRESSION_T = Pattern.compile("\\$\\{([^}]+)\\}");
    private final Properties[] defaultsPros;

    public ExpressionProperties(Properties ... properties) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.defaultsPros = properties;
    }

    @Override
    public String getProperty(String _key) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _value = this.getRawPropertyValue(_key);
        return this.replaceProperties(_value);
    }

    @Override
    public String getProperty(String _key, String defaultValue) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _value = this.getRawPropertyValue(_key);
        if (_value == null) {
            _value = defaultValue;
        }
        return this.replaceProperties(_value);
    }

    public String getRawPropertyValue(String _key) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _value = super.getProperty(_key);
        if (_value != null) {
            return _value;
        }
        for (Properties propes : this.defaultsPros) {
            _value = propes.getProperty(_key);
            if (_value == null) continue;
            return _value;
        }
        return null;
    }

    private String replaceProperties(String _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_value == null) {
            return null;
        }
        Matcher matcher = EXPRESSION_T.matcher(_value);
        StringBuffer sbu = null;
        while (matcher.find()) {
            String propValue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (sbu == null) {
                sbu = new StringBuffer();
            }
            if ((propValue = this.getProperty(matcher.group(1))) == null) {
                propValue = matcher.group();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            matcher.appendReplacement(sbu, Matcher.quoteReplacement(propValue));
        }
        if (sbu == null) {
            return _value;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        matcher.appendTail(sbu);
        return sbu.toString();
    }
}

