/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jre7.sasl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import org.postgresql.core.PGStream;
import org.postgresql.shaded.com.ongres.scram.client.ScramClient;
import org.postgresql.shaded.com.ongres.scram.client.ScramSession;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramException;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import org.postgresql.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import org.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparations;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class ScramAuthenticator {
    private final String userT;
    private final String passwordT;
    private final PGStream pgStream;
    private ScramSession.ClientFinalProcessor clientFinalProcessorT;
    private ScramSession.ServerFirstProcessor serverFirstProcessorT;
    private ScramSession scramSessionT;
    private ScramClient scramClientT;

    private void sendAuthenticationMessage(int bodyLength, BodySender bodySender) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pgStream.sendChar(112);
        this.pgStream.sendInteger4(4 + bodyLength);
        bodySender.sendBody(this.pgStream);
        this.pgStream.flush();
    }

    public ScramAuthenticator(String user, String password, PGStream pgStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.userT = user;
        this.passwordT = password;
        this.pgStream = pgStream;
    }

    public void processServerMechanismsAndInit() throws IOException, PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<String> mechanismsT = new ArrayList<String>();
        do {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            mechanismsT.add(this.pgStream.receiveString());
        } while (this.pgStream.peekChar() != 0);
        int c = this.pgStream.receiveChar();
        assert (c == 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mechanismsT.size() < 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("No SCRAM mechanism(s) advertised by the server", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.scramClientT = ScramClient.channelBinding(ScramClient.ChannelBinding.NO).stringPreparation(StringPreparations.SASL_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanismsT.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid or unsupported by client SCRAM mechanisms", illegalArgumentException), PSQLState.CONNECTION_REJECTED);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINEST, " Using SCRAM mechanism-- {0}", this.scramClientT.getScramMechanism().getName());
        }
        this.scramSessionT = this.scramClientT.scramSession("*");
    }

    public void sendScramClientFirstMessage() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String clientFirstMsg = this.scramSessionT.clientFirstMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLInitialResponse( {0} )", clientFirstMsg);
        String scramMechanismNameT = this.scramClientT.getScramMechanism().getName();
        final byte[] scramMechanismNameBytesT = scramMechanismNameT.getBytes(StandardCharsets.UTF_8);
        final byte[] clientFirstMessageBytesT = clientFirstMsg.getBytes(StandardCharsets.UTF_8);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sendAuthenticationMessage(scramMechanismNameBytesT.length + 1 + 4 + clientFirstMessageBytesT.length, new BodySender(){

            @Override
            public void sendBody(PGStream pgStream) throws IOException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pgStream.send(scramMechanismNameBytesT);
                pgStream.sendChar(0);
                pgStream.sendInteger4(clientFirstMessageBytesT.length);
                pgStream.send(clientFirstMessageBytesT);
            }
        });
    }

    public void processServerFirstMessage(int length) throws IOException, PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String serverFirstMsg = this.pgStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue( {0} )", serverFirstMsg);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.serverFirstProcessorT = this.scramSessionT.receiveServerFirstMessage(serverFirstMsg);
        }
        catch (ScramException scramException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid server-first-message: {0}", serverFirstMsg), PSQLState.CONNECTION_REJECTED, (Throwable)scramException);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue(salt={0}, iterations={1})", this.serverFirstProcessorT.getSalt(), this.serverFirstProcessorT.getIteration());
        }
        this.clientFinalProcessorT = this.serverFirstProcessorT.clientFinalProcessor(this.passwordT);
        String clientFinalMsg = this.clientFinalProcessorT.clientFinalMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLResponse( {0} )", clientFinalMsg);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        final byte[] clientFinalMessageBytesT = clientFinalMsg.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(clientFinalMessageBytesT.length, new BodySender(){

            @Override
            public void sendBody(PGStream pgStream) throws IOException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pgStream.send(clientFinalMessageBytesT);
            }
        });
    }

    public void verifyServerSignature(int length) throws IOException, PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String serverFinalMsg = this.pgStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLFinal( {0} )", serverFinalMsg);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.clientFinalProcessorT.receiveServerFinalMessage(serverFinalMsg);
        }
        catch (ScramParseException scramParseException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid server-final-message: {0}", serverFinalMsg), PSQLState.CONNECTION_REJECTED, (Throwable)scramParseException);
        }
        catch (ScramServerErrorException scramServerErrorException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("SCRAM authentication failed, server returned _error: {0}", scramServerErrorException.getError().getErrorMessage()), PSQLState.CONNECTION_REJECTED, (Throwable)scramServerErrorException);
        }
        catch (ScramInvalidServerSignatureException scramInvalidServerSignatureException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid server SCRAM signature", new Object[0]), PSQLState.CONNECTION_REJECTED, (Throwable)scramInvalidServerSignatureException);
        }
    }

    private static interface BodySender {
        public void sendBody(PGStream var1) throws IOException;
    }
}

