/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGlseg
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] pointArray = new PGpoint[2];

    public PGlseg(double x1, double y1, double x2, double y2) {
        this(new PGpoint(x1, y1), new PGpoint(x2, y2));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGlseg(PGpoint point1, PGpoint point2) {
        this();
        this.pointArray[0] = point1;
        this.pointArray[1] = point2;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGlseg(String value) throws SQLException {
        this();
        this.setValue(value);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public PGlseg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("lseg");
    }

    @Override
    public void setValue(String value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeBox(value), ',');
        if (t.getSize() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, value), PSQLState.DATA_TYPE_MISMATCH);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pointArray[0] = new PGpoint(t.getToken(0));
        this.pointArray[1] = new PGpoint(t.getToken(1));
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (objt instanceof PGlseg) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGlseg lseg = (PGlseg)objt;
            return lseg.pointArray[0].equals(this.pointArray[0]) && lseg.pointArray[1].equals(this.pointArray[1]) || lseg.pointArray[0].equals(this.pointArray[1]) && lseg.pointArray[1].equals(this.pointArray[0]);
        }
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGlseg newPGlseg = (PGlseg)super.clone();
        if (newPGlseg.pointArray != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newPGlseg.pointArray = (PGpoint[])newPGlseg.pointArray.clone();
            for (int i = 0; i < newPGlseg.pointArray.length; ++i) {
                if (newPGlseg.pointArray[i] == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newPGlseg.pointArray[i] = (PGpoint)newPGlseg.pointArray[i].clone();
            }
        }
        return newPGlseg;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.pointArray[1].hashCode() ^ this.pointArray[0].hashCode();
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "[" + this.pointArray[0] + "," + this.pointArray[1] + "]";
    }
}

