/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.util.logging.Level;
import org.postgresql.core.SqlCommandType;
import org.postgresql.util.TraceLogger;

public class SqlCommand {
    public static final SqlCommand BLANK = SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK);
    private final SqlCommandType _commandType;
    private final boolean parsedSQLhasRETURNINGKeyword;
    private final int valuesBraceOpenPos;
    private final int valuesBraceClosePos;

    public boolean isBatchedReWriteCompatible() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.valuesBraceOpenPos >= 0;
    }

    public int getBatchRewriteValuesBraceOpenPosition() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.valuesBraceOpenPos;
    }

    public int getBatchRewriteValuesBraceClosePosition() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.valuesBraceClosePos;
    }

    public SqlCommandType getType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._commandType;
    }

    public boolean isReturningKeywordPresent() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.parsedSQLhasRETURNINGKeyword;
    }

    public boolean returnsRows() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.parsedSQLhasRETURNINGKeyword || this._commandType == SqlCommandType.SELECT || this._commandType == SqlCommandType.WITH;
    }

    public boolean isDML() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._commandType == SqlCommandType.INSERT || this._commandType == SqlCommandType.UPDATE || this._commandType == SqlCommandType.DELETE || this._commandType == SqlCommandType.MERGE;
    }

    public static SqlCommand createStatementTypeInfo(SqlCommandType type, boolean isBatchedReWritePropertyConfigured, int valuesBraceOpenPos, int valuesBraceClosePos, boolean isRETURNING_keywordPresent, int priorQueryCount) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new SqlCommand(type, isBatchedReWritePropertyConfigured, valuesBraceOpenPos, valuesBraceClosePos, isRETURNING_keywordPresent, priorQueryCount);
    }

    public static SqlCommand createStatementTypeInfo(SqlCommandType type) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new SqlCommand(type, false, -1, -1, false, 0);
    }

    public static SqlCommand createStatementTypeInfo(SqlCommandType type, boolean isRETURNING_keywordPresent) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new SqlCommand(type, false, -1, -1, isRETURNING_keywordPresent, 0);
    }

    private SqlCommand(SqlCommandType type, boolean isBatchedReWriteConfigured, int valuesBraceOpenPos, int valuesBraceClosePos, boolean isPresent, int priorQueryCount) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._commandType = type;
        this.parsedSQLhasRETURNINGKeyword = isPresent;
        boolean batchedReWriteCompatible = type == SqlCommandType.INSERT && isBatchedReWriteConfigured && valuesBraceOpenPos >= 0 && valuesBraceClosePos > valuesBraceOpenPos && !isPresent && priorQueryCount == 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.valuesBraceOpenPos = batchedReWriteCompatible ? valuesBraceOpenPos : -1;
        this.valuesBraceClosePos = batchedReWriteCompatible ? valuesBraceClosePos : -1;
    }
}

