/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds;

import com.kingbase8.ds.KBPooledConnection;
import com.kingbase8.ds.common.BaseDataSource;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class KBConnectionPoolDataSource
extends BaseDataSource
implements ConnectionPoolDataSource,
Serializable {
    private boolean defaultAutoCommit = true;

    @Override
    public String getDescription() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "ConnectionPoolDataSource from Kingbase8 JDBC Driver V008R006C008B0014";
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KBPooledConnection(this.getConnection(), this.defaultAutoCommit);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KBPooledConnection(this.getConnection(user, password), this.defaultAutoCommit);
    }

    public boolean isDefaultAutoCommit() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.readBaseObject(inputStream);
        this.defaultAutoCommit = inputStream.readBoolean();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.writeBaseObject(objectOutputStream);
        objectOutputStream.writeBoolean(this.defaultAutoCommit);
    }
}

