/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.executor.AbstractExecuteCommand;
import com.kingbase8.dispatcher.executor.DispatchAbstractStatement;
import com.kingbase8.dispatcher.executor.command.StatmentCommand;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DispatchStatementV2
extends DispatchAbstractStatement
implements Statement {
    protected boolean _isClosed = false;

    public DispatchStatementV2(DispatchConnection _con) {
        this.dispatchConnection = _con;
        this.createCommand = new StatmentCommand();
    }

    public DispatchStatementV2(DispatchConnection _con, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) {
        this.dispatchConnection = _con;
        this.createCommand = new StatmentCommand(_resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    public DispatchStatementV2(DispatchConnection _con, int _resultSetType, int _resultSetConcurrency) {
        this.dispatchConnection = _con;
        this.createCommand = new StatmentCommand(_resultSetType, _resultSetConcurrency);
    }

    @Override
    public ResultSet executeQuery(final String _sql) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeQuery(" + _sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                KbResultSet brs;
                BaseConnection _conn = (BaseConnection)t.getConnection();
                ResultSet resultSet = t.executeQuery(_sql);
                if (_conn.isSlave() && _conn.isZeroResend() && (brs = (KbResultSet)resultSet).getTupleCount() == 0) {
                    resultSet.close();
                    throw new KSQLException("_resultSet size is 0 ,try to switch to main", KSQLState.NO_DATA);
                }
                return resultSet;
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String _sql) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + _sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(_sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public void close() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.close()";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.close();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
        this._isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.cancel();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        AbstractExecuteCommand<SQLWarning> ec = new AbstractExecuteCommand<SQLWarning>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getWarnings";
            }

            @Override
            public SQLWarning execute(Statement t) throws SQLException {
                return t.getWarnings();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void clearWarnings() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.clearWarnings";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearWarnings();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
    }

    @Override
    public boolean execute(final String _sql) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + _sql + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(_sql);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getResultSet()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getResultSet();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getUpdateCount()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSizeModify = true;
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.fetchSizeModify) {
            return this.fetchSize;
        }
        return this.dispatchConnection.getDefaultFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetConcurrency();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int getResultSetType() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetType();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void addBatch(final String _sql) throws SQLException {
        if (this._sqlType.equals("NULL") || !this._sqlType.equalsIgnoreCase("insert or delete or update") && !this._sqlType.equalsIgnoreCase("in transaction")) {
            this.getExecuteType(_sql);
        }
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.addBatch(" + _sql + ")";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.addBatch(_sql);
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public void clearBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearBatch();
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeBatch()";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public int[] execute(Statement t) throws SQLException {
                return t.executeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dispatchConnection;
    }

    @Override
    public boolean getMoreResults(final int current) throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults(current);
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getGeneratedKeys()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getGeneratedKeys();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int executeUpdate(final String _sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + _sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(_sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String _sql, final int[] _columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + _sql + "," + _columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(_sql, _columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int executeUpdate(final String _sql, final String[] _columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + _sql + "," + _columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(_sql, _columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String _sql, final int autoGeneratedKeys) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + _sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(_sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String _sql, final int[] _columnIndexes) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + _sql + "," + _columnIndexes + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(_sql, _columnIndexes);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public boolean execute(final String _sql, final String[] _columnNames) throws SQLException {
        this.dispatchType = this.getExecuteType(_sql);
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + _sql + "," + _columnNames + ")";
            }

            @Override
            public boolean isExecuteFunction() {
                return true;
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(_sql, _columnNames);
            }
        };
        return this.executeTemplet(ec, this.dispatchType);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetHoldability();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    protected boolean expectionHandler(SQLException e, Statement slave, Statement master) throws SQLException {
        boolean changeSuccess = false;
        if (this.getErrorCode(e)) {
            changeSuccess = true;
        }
        return changeSuccess;
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        if (clz.isAssignableFrom(this.getClass())) {
            return clz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        return clz.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this._isClosed) {
            return true;
        }
        if (this.mainStatement != null && this.mainStatement.isClosed()) {
            this._isClosed = true;
            if (this.slaveStatement != null && !this.slaveStatement.isClosed()) {
                try {
                    this.slaveStatement.close();
                }
                catch (Exception e) {}
            }
        } else if (this.slaveStatement != null && this.slaveStatement.isClosed()) {
            this._isClosed = true;
            if (this.mainStatement != null && !this.mainStatement.isClosed()) {
                try {
                    this.mainStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this._isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }
}

