/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpolygon
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] points;

    public KBpolygon(KBpoint[] points) {
        this();
        this.points = points;
    }

    public KBpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KBpolygon() {
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        KBtokenizer t = new KBtokenizer(KBtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new KBpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new KBpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KBpolygon) {
            KBpolygon p = (KBpolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KBpolygon newKBpolygon = (KBpolygon)super.clone();
        if (newKBpolygon.points != null) {
            newKBpolygon.points = (KBpoint[])newKBpolygon.points.clone();
            for (int i = 0; i < newKBpolygon.points.length; ++i) {
                if (newKBpolygon.points[i] == null) continue;
                newKBpolygon.points[i] = (KBpoint)newKBpolygon.points[i].clone();
            }
        }
        return newKBpolygon;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

