/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.largeobject.ClobOutputStream;
import org.postgresql.largeobject.ClobWriter;
import org.postgresql.util.LOGGER;
import org.postgresql.util.TraceLogger;

public class EsClob
implements Clob {
    private char[] _buf;
    private Clob clob;
    private long leng;
    private PgResultSet resultSet;
    private int _columnIndex;
    private String _encoding = System.getProperty("file.encoding");

    public EsClob(char[] chr) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.leng = chr.length;
        this._buf = new char[(int)this.leng];
        int i = 0;
        while ((long)i < this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._buf[i] = chr[i];
            ++i;
        }
        this.clob = null;
    }

    public EsClob(char[] chr, String _encoding) throws SQLException, SQLException {
        this(chr);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encoding = _encoding;
    }

    public EsClob(char[] chr, PgResultSet resultSet, int _columnIndex, String _encoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (chr != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = chr.length;
            this._buf = new char[(int)this.leng];
            int i = 0;
            while ((long)i < this.leng) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._buf[i] = chr[i];
                ++i;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = 0L;
            this._buf = new char[(int)this.leng];
        }
        this.clob = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.resultSet = resultSet;
        this._columnIndex = _columnIndex;
        this._encoding = _encoding;
    }

    public EsClob(Clob clob) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clob == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Cannot instantiate a EsClob object with a null Clob object");
        }
        this.leng = clob.length();
        this.clob = clob;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._buf = new char[(int)this.leng];
        int read = 0;
        int _offset = 0;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Reader charStream = clob.getCharacterStream();
            if (charStream == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new SQLException("Invalid Clob object. The call to getCharacterStream returned null which cannot be serialized.");
            }
            InputStream asciiStream = clob.getAsciiStream();
            if (asciiStream == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new SQLException("Invalid Clob object. The call to getAsciiStream returned null which cannot be serialized.");
            }
            BufferedReader reader = new BufferedReader(charStream);
            do {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                read = ((Reader)reader).read(this._buf, _offset, (int)(this.leng - (long)_offset));
                _offset += read;
            } while (read > 0);
        }
        catch (IOException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("EsClob: " + ex.getMessage());
        }
    }

    public EsClob(Clob clob, String _encoding) throws SQLException, SQLException {
        this(clob);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encoding = _encoding;
    }

    @Override
    public long length() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        return this.leng;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        return new CharArrayReader(this._buf);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        String s_buf = this.getSubString(1L, (int)this.length());
        ByteArrayInputStream ins = new ByteArrayInputStream(s_buf.getBytes());
        return ins;
    }

    @Override
    public String getSubString(long position, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (position < 1L || position > this.length() && this.length() > 0L || position > 1L && this.length() == 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in EsClob object set");
        }
        if (position - 1L + (long)length > this.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position and substring length");
        }
        try {
            return new String(this._buf, (int)position - 1, length);
        }
        catch (StringIndexOutOfBoundsException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("StringIndexOutOfBoundsException: " + e.getMessage());
        }
    }

    @Override
    public long position(String searchStr, long start) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (start < 1L || start > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return -1L;
        }
        char[] pat = searchStr.toCharArray();
        int position = (int)start - 1;
        int i = 0;
        long patleng = pat.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while ((long)position < this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pat[i] == this._buf[position]) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((long)(i + 1) == patleng) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return (long)(position + 1) - (patleng - 1L);
                }
                ++i;
                ++position;
                continue;
            }
            if (pat[i] == this._buf[position]) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++position;
        }
        return -1L;
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        return this.position(searchStr.getSubString(1L, (int)searchStr.length()), start);
    }

    @Override
    public int setString(long position, String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "position: {0},str: {1}", position, str);
        }
        return this.setString(position, str, 0, str.length());
    }

    @Override
    public int setString(long position, String str, int _offset, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.WARNING, "position: {0}, str: {1}, _offset: {2}, length: {3}", position, str, _offset, length);
        }
        this.isValid();
        String temp = str.substring(_offset);
        char[] cPattern = temp.toCharArray();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_offset < 0 || _offset > str.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid _offset in char array set");
        }
        if (length < 0 || length > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid length in char array set");
        }
        if (length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        if (position < 1L || position + (long)length - 1L > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in Clob object set");
        }
        int newleng = 0;
        if (position <= this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long remainleng = this.leng - position + 1L;
            if (remainleng < (long)length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newleng = (int)(this.leng + (long)length - remainleng);
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newleng = (int)(position + (long)length - 1L);
        }
        if ((long)newleng > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = newleng;
            char[] btemp = new char[(int)this.leng];
            btemp = Arrays.copyOf(this._buf, (int)this.leng);
            this._buf = btemp;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int cpleng = 0;
        if (_offset + length > str.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            cpleng = str.length() - (int)position;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            cpleng = length;
        }
        System.arraycopy(cPattern, _offset, this._buf, (int)(--position), cpleng);
        if (this.resultSet != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.resultSet.insertLob(this);
        }
        return length;
    }

    @Override
    public OutputStream setAsciiStream(long position) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.WARNING, "position: {0}", position);
        }
        this.isValid();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (position < 1L || position > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in CLOB object set");
        }
        return new ClobOutputStream(this, (int)position, this._encoding);
    }

    @Override
    public Writer setCharacterStream(long position) throws SQLException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.WARNING)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LOGGER.log(Level.WARNING, "position: {0}", position);
        }
        this.isValid();
        if (position < 1L || position > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in Clob object set");
        }
        return new ClobWriter(this, (int)position);
    }

    @Override
    public void truncate(long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (length > this.leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = length;
            char[] btemp = new char[(int)this.leng];
            btemp = Arrays.copyOf(this._buf, (int)this.leng);
            this._buf = btemp;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.leng = length;
            if (this.leng == 0L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._buf = new char[0];
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._buf = this.getSubString(1L, (int)this.leng).toCharArray();
            }
        }
    }

    @Override
    public Reader getCharacterStream(long position, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isValid();
        if (position < 1L || position > this.length() && this.length() > 0L || position > 1L && this.length() == 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position in Clob object set");
        }
        if (position - 1L + length > this.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid position and substring length");
        }
        if (length < 0L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Invalid length specified");
        }
        return new CharArrayReader(this._buf, (int)position - 1, (int)length);
    }

    @Override
    public void free() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._buf != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._buf = null;
            if (this.clob != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.clob.free();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.clob = null;
        }
    }

    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this == objt) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (objt instanceof EsClob) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            EsClob sc = (EsClob)objt;
            if (this.leng == sc.leng) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Arrays.equals(this._buf, sc._buf);
            }
        }
        return false;
    }

    private void isValid() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._buf == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("Error: You cannot call a mtd on a EsClob instance once free() has been called.");
        }
    }

    public int getColumnIndex() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._columnIndex;
    }

    public void setColumnIndex(int _columnIndex) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._columnIndex = _columnIndex;
    }
}

