/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.Driver;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.jdbc.BatchResultHandler;
import org.postgresql.jdbc.CallableBatchResultHandler;
import org.postgresql.jdbc.CompatibleDB;
import org.postgresql.jdbc.EsBlob;
import org.postgresql.jdbc.EsClob;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PgPreparedStatement;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.jdbc.PgRowId;
import org.postgresql.jdbc.ResultWrapper;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private boolean isFunctionT;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    private int lastIndex = 0;
    protected boolean outParmBeforeFunc = false;
    private List<String> functionParameterNames = new ArrayList<String>();
    private String schemaName;
    private String functionName;
    private Map<String, Integer> callParameterNames = new HashMap<String, Integer>();
    private Map<Integer, Boolean> markExistMap = new HashMap<Integer, Boolean>();
    private int _paramIndex = 0;
    private int inParamCount = 0;

    PgCallableStatement(PgConnection _connection, String _sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(_connection, _connection.borrowCallableQuery(_sql), resultSetType, resultSetConcurrency, resultSetHoldability);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isFunctionT = this.preparedQuery.isFunction;
        this.outParmBeforeFunc = this.preparedQuery.outParmBeforeFunc;
        this.schemaName = this.preparedQuery.schemaName;
        this.functionName = this.preparedQuery.funName;
        this.inParamCount = this.preparedParameterList.getInParameterCount();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isFunctionT) {
            int inParamCount = this.preparedParameterList.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
    }

    private void parseFuncMark(CachedQuery query) {
        int i;
        if (query == null || !query.isFunction || query.funName == null) {
            return;
        }
        String sql = Parser.removeCallRemarks(query.query.toString());
        char[] chars = sql.toCharArray();
        boolean isInDoubleQuote = false;
        boolean isInSingleQuote = false;
        boolean beginParameter = false;
        List<String> p = new ArrayList();
        int startPos = 0;
        int index = 0;
        if (query.isFunction) {
            index = sql.indexOf(query.origFuncName) + query.origFuncName.length();
        }
        block3: for (i = index; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == '\"') {
                isInDoubleQuote = !isInDoubleQuote;
            } else if (aChar == '\'') {
                if (isInDoubleQuote) {
                    if (isInSingleQuote) {
                        isInSingleQuote = false;
                        isInDoubleQuote = false;
                    } else {
                        isInSingleQuote = true;
                    }
                } else {
                    isInSingleQuote = !isInSingleQuote;
                }
            } else if (isInDoubleQuote || isInSingleQuote) continue;
            switch (aChar) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case ';': 
                case '=': 
                case '{': 
                case '}': {
                    if (!beginParameter) continue block3;
                    p.add(sql.substring(startPos, i));
                    beginParameter = false;
                    continue block3;
                }
                default: {
                    if (beginParameter) continue block3;
                    beginParameter = true;
                    startPos = i;
                }
            }
        }
        if (query.outParmBeforeFunc) {
            p = p.subList(1, p.size());
        }
        this.markExistMap.clear();
        for (i = 0; i < p.size(); ++i) {
            if (((String)p.get(i)).equalsIgnoreCase("?")) {
                this.markExistMap.put(i, true);
                continue;
            }
            this.markExistMap.put(i, false);
        }
    }

    public void copyCallableStatementInfo(PgCallableStatement stnew) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isFunctionT = stnew.isFunctionT;
        this.functionReturnType = stnew.functionReturnType;
        this.testReturn = stnew.testReturn;
        this.returnTypeSet = stnew.returnTypeSet;
        this.callResult = stnew.callResult;
        this.lastIndex = stnew.lastIndex;
        this.outParmBeforeFunc = stnew.outParmBeforeFunc;
    }

    @Override
    public int executeUpdate() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isFunctionT) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> mapT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getObjectImpl(parameterIndex, mapT);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> mapT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getObjectImpl(parameterName, mapT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean hasResultSet = super.executeWithFlags(_flags);
        if (!this.isFunctionT || !this.returnTypeSet) {
            return hasResultSet;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSet resultSet = null;
        PgCallableStatement pgCallableStatement = this;
        synchronized (pgCallableStatement) {
            this.checkClosed_();
            for (ResultWrapper rw = this.resultT; rw != null; rw = rw.getNext()) {
                resultSet = rw.getResultSet();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!resultSet.next()) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        String columnName = metaData.getColumnName(1);
        int _cols = metaData.getColumnCount();
        int startIndex = 0;
        int outParameterCount = this.preparedParameterList.getOutParameterCount();
        int relCols = _cols;
        if (!this.preparedQuery.outParmBeforeFunc && "_RETVAL_".equalsIgnoreCase(columnName)) {
            relCols = _cols - 1;
            startIndex = 1;
        }
        if (relCols != outParameterCount) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of _parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.lastIndex = 0;
        this.callResult = new Object[this.preparedParameterList.getParameterCount() + 1];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int i = startIndex;
        int j = 0;
        while (i < _cols) {
            while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                ++j;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
                ((PgResultSet)resultSet).checkResultSet_(i + 1);
                if (((PgResultSet)resultSet).wasNullFlagT) {
                    this.callResult[j] = null;
                } else {
                    switch (this.functionReturnType[j]) {
                        case 2009: {
                            this.callResult[j] = resultSet.getSQLXML(i + 1);
                            break;
                        }
                        case -6: 
                        case 5: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.callResult[j] = resultSet.getShort(i + 1);
                            break;
                        }
                        case 4: {
                            this.callResult[j] = resultSet.getInt(i + 1);
                            break;
                        }
                        case -5: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.callResult[j] = resultSet.getLong(i + 1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.callResult[j] = resultSet.getBigDecimal(i + 1);
                            break;
                        }
                        case 7: {
                            this.callResult[j] = Float.valueOf(resultSet.getFloat(i + 1));
                            break;
                        }
                        case 6: 
                        case 8: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.callResult[j] = resultSet.getDouble(i + 1);
                            break;
                        }
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.callResult[j] = resultSet.getString(i + 1);
                            break;
                        }
                        case 91: {
                            this.callResult[j] = resultSet.getDate(i + 1);
                            break;
                        }
                        case 92: {
                            this.callResult[j] = resultSet.getTime(i + 1);
                            break;
                        }
                        case 93: {
                            this.callResult[j] = resultSet.getTimestamp(i + 1);
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.callResult[j] = resultSet.getBytes(i + 1);
                            break;
                        }
                        case 2003: {
                            this.callResult[j] = resultSet.getArray(i + 1);
                            break;
                        }
                        case 2005: {
                            this.callResult[j] = resultSet.getClob(i + 1);
                            break;
                        }
                        case 2004: {
                            this.callResult[j] = resultSet.getBlob(i + 1);
                            break;
                        }
                        case 2011: {
                            this.callResult[j] = resultSet.getNClob(i + 1);
                            break;
                        }
                        case -8: {
                            this.callResult[j] = resultSet.getRowId(i + 1);
                            break;
                        }
                        default: {
                            this.callResult[j] = resultSet.getObject(i + 1);
                            break;
                        }
                    }
                }
            } else {
                this.callResult[j] = resultSet.getObject(i + 1);
            }
            int _columnType = resultSet.getMetaData().getColumnType(i + 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!"oracle".equals(this.baseConnection.getCompatibleLevel()) && !"mysql".equals(this.baseConnection.getCompatibleLevel()) && _columnType != this.functionReturnType[j]) {
                if (_columnType == 8 && this.functionReturnType[j] == 7) {
                    if (this.callResult[j] != null) {
                        this.callResult[j] = Float.valueOf(((Double)this.callResult[j]).floatValue());
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new PSQLException(GT.tr("A CallableStatement function was executed and the out _parameter {0} was of type {1} however type {2} was registered.", i + 1, "java.sql.Types=" + _columnType, "java.sql.Types=" + this.functionReturnType[j]), PSQLState.DATA_TYPE_MISMATCH);
                }
            }
            ++i;
            ++j;
        }
        resultSet.close();
        PgCallableStatement pgCallableStatement2 = this;
        synchronized (pgCallableStatement2) {
            if (this.resultT.getNext() == null) {
                this.resultT = null;
            }
        }
        return false;
    }

    @Override
    public void registerOutParameter(int _parameterIndex, int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        switch (_sqlType) {
            case -6: {
                _sqlType = 5;
                break;
            }
            case -1: {
                _sqlType = 12;
                break;
            }
            case 3: {
                _sqlType = 2;
                break;
            }
            case 6: {
                _sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                _sqlType = -2;
                break;
            }
            case 16: {
                _sqlType = -7;
                break;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.isFunctionT) {
            throw new PSQLException(GT.tr("This stmt does not declare an OUT _parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(_parameterIndex, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            int oidT = 0;
            switch (_sqlType) {
                case 4: {
                    oidT = 23;
                    break;
                }
                case -6: 
                case 5: {
                    oidT = 21;
                    break;
                }
                case 2009: {
                    oidT = 142;
                    break;
                }
                case -5: {
                    oidT = 20;
                    break;
                }
                case 6: 
                case 8: {
                    oidT = 701;
                    break;
                }
                case 7: {
                    oidT = 700;
                    break;
                }
                case 1: {
                    oidT = 1042;
                    break;
                }
                case 2: 
                case 3: {
                    oidT = 1700;
                    break;
                }
                case -9: 
                case -1: 
                case 12: {
                    oidT = this.baseConnection.getStringVarcharFlag() ? 1043 : 0;
                    break;
                }
                case 91: {
                    if ("oracle".equals(this.baseConnection.getCompatibleLevel())) {
                        oidT = 8020;
                        break;
                    }
                    if ("mysql".equals(this.baseConnection.getCompatibleLevel())) {
                        oidT = 7944;
                        break;
                    }
                    oidT = 1082;
                    break;
                }
                case 92: {
                    oidT = 1083;
                    if (!CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) break;
                    oidT = 7950;
                    break;
                }
                case -7: 
                case 16: {
                    oidT = 16;
                    break;
                }
                case 93: {
                    oidT = 1114;
                    if (!CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) break;
                    oidT = 7952;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    oidT = 17;
                    break;
                }
                case 2004: {
                    oidT = 8013;
                    break;
                }
                case 2011: {
                    oidT = 8015;
                    break;
                }
                case 2005: {
                    oidT = 8014;
                    break;
                }
                case -10: 
                case 1111: 
                case 2001: 
                case 2002: 
                case 2003: {
                    oidT = 0;
                    break;
                }
                case -8: {
                    if (this.baseConnection.isDatabaseSupportRowid()) {
                        oidT = 6123;
                        break;
                    }
                    oidT = 27;
                    break;
                }
                default: {
                    throw new PSQLException(GT.tr("Unknown Types _value.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
                }
            }
            this.preparedParameterList.registerOutParameter(_parameterIndex, oidT, this.outParmBeforeFunc);
        } else {
            this.preparedParameterList.registerOutParameter(_parameterIndex, _sqlType, this.outParmBeforeFunc);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.functionReturnType[_parameterIndex - 1] = _sqlType;
        this.testReturn[_parameterIndex - 1] = _sqlType;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.functionReturnType[_parameterIndex - 1] == 1 || this.functionReturnType[_parameterIndex - 1] == -1) {
            this.testReturn[_parameterIndex - 1] = 12;
        } else if (this.functionReturnType[_parameterIndex - 1] == 6) {
            this.testReturn[_parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a _result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.callResult[this.lastIndex - 1] == null;
    }

    @Override
    public String getString(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return null;
        }
        if (this.callResult[_parameterIndex - 1] instanceof Clob) {
            return ((Clob)this.callResult[_parameterIndex - 1]).getSubString(1L, (int)((Clob)this.callResult[_parameterIndex - 1]).length());
        }
        return this.callResult[_parameterIndex - 1].toString();
    }

    @Override
    public boolean getBoolean(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex, -7, "Boolean");
        if (this.callResult[_parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[_parameterIndex - 1];
    }

    @Override
    public byte getByte(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[_parameterIndex - 1]).byteValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[_parameterIndex - 1]).byteValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[_parameterIndex - 1]).byteValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[_parameterIndex - 1]).byteValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[_parameterIndex - 1]).byteValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[_parameterIndex - 1]).byteValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]).byteValue();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIndex(_parameterIndex, 5, "Byte");
        return ((Integer)this.callResult[_parameterIndex - 1]).byteValue();
    }

    @Override
    public short getShort(int _parameterIndex) throws SQLException {
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return 0;
        }
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[_parameterIndex - 1]).shortValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[_parameterIndex - 1]).shortValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[_parameterIndex - 1]).shortValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[_parameterIndex - 1]).shortValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[_parameterIndex - 1]).shortValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return (Short)this.callResult[_parameterIndex - 1];
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]).shortValue();
        }
        this.checkIndex(_parameterIndex, 5, "Short");
        return ((Integer)this.callResult[_parameterIndex - 1]).shortValue();
    }

    @Override
    public int getInt(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return 0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[_parameterIndex - 1]).intValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[_parameterIndex - 1]).intValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[_parameterIndex - 1]).intValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[_parameterIndex - 1]).intValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[_parameterIndex - 1]).intValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return (Integer)this.callResult[_parameterIndex - 1];
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]).intValue();
        }
        this.checkIndex(_parameterIndex, 4, "Int");
        return (Integer)this.callResult[_parameterIndex - 1];
    }

    @Override
    public long getLong(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return 0L;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[_parameterIndex - 1]).longValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[_parameterIndex - 1]).longValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[_parameterIndex - 1]).longValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[_parameterIndex - 1]).longValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[_parameterIndex - 1]).longValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return (Long)this.callResult[_parameterIndex - 1];
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]).longValue();
        }
        this.checkIndex(_parameterIndex, -5, "Long");
        return (Long)this.callResult[_parameterIndex - 1];
    }

    @Override
    public float getFloat(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return 0.0f;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return ((Double)this.callResult[_parameterIndex - 1]).floatValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[_parameterIndex - 1]).floatValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[_parameterIndex - 1]).floatValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[_parameterIndex - 1]).floatValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[_parameterIndex - 1]).floatValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[_parameterIndex - 1]).floatValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]).floatValue();
        }
        this.checkIndex(_parameterIndex, 7, "Float");
        return ((Float)this.callResult[_parameterIndex - 1]).floatValue();
    }

    @Override
    public double getDouble(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] == null) {
            return 0.0;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return ((Float)this.callResult[_parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return ((Long)this.callResult[_parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return ((Short)this.callResult[_parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return ((Integer)this.callResult[_parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return ((BigDecimal)this.callResult[_parameterIndex - 1]).doubleValue();
        }
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return (Double)this.callResult[_parameterIndex - 1];
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]).doubleValue();
        }
        this.checkIndex(_parameterIndex, 8, "Double");
        return (Double)this.callResult[_parameterIndex - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int _parameterIndex, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBigDecimal(_parameterIndex);
    }

    @Override
    public byte[] getBytes(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[_parameterIndex - 1];
    }

    @Override
    public Date getDate(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return Date.valueOf((String)this.callResult[_parameterIndex - 1]);
        }
        if (this.callResult[_parameterIndex - 1] instanceof Time) {
            return new Date(((Time)this.callResult[_parameterIndex - 1]).getTime());
        }
        if (this.callResult[_parameterIndex - 1] instanceof Timestamp) {
            return new Date(((Timestamp)this.callResult[_parameterIndex - 1]).getTime());
        }
        this.checkIndex(_parameterIndex, 91, "Date");
        if (("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) && this.callResult[_parameterIndex - 1] instanceof Timestamp) {
            return new Date(((Timestamp)this.callResult[_parameterIndex - 1]).getTime());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Date)this.callResult[_parameterIndex - 1];
    }

    @Override
    public Time getTime(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return Time.valueOf((String)this.callResult[_parameterIndex - 1]);
        }
        if (this.callResult[_parameterIndex - 1] instanceof Date) {
            return new Time(((Date)this.callResult[_parameterIndex - 1]).getTime());
        }
        if (this.callResult[_parameterIndex - 1] instanceof Timestamp) {
            return new Time(((Timestamp)this.callResult[_parameterIndex - 1]).getTime());
        }
        this.checkIndex(_parameterIndex, 92, "Time");
        return (Time)this.callResult[_parameterIndex - 1];
    }

    @Override
    public Timestamp getTimestamp(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return Timestamp.valueOf((String)this.callResult[_parameterIndex - 1]);
        }
        if (this.callResult[_parameterIndex - 1] instanceof Date) {
            return new Timestamp(((Date)this.callResult[_parameterIndex - 1]).getTime());
        }
        if (this.callResult[_parameterIndex - 1] instanceof Time) {
            return new Timestamp(((Time)this.callResult[_parameterIndex - 1]).getTime());
        }
        this.checkIndex(_parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[_parameterIndex - 1];
    }

    @Override
    public Object getObject(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        return this.callResult[_parameterIndex - 1];
    }

    protected void checkIndex(int _parameterIndex, int type1, int type2, String getName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIndex(_parameterIndex);
        if (type1 != this.testReturn[_parameterIndex - 1] && type2 != this.testReturn[_parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (_sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[_parameterIndex - 1], getName, "java.sql.Types=" + type1), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int _parameterIndex, int type, String getName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIndex(_parameterIndex);
        if (type != this.testReturn[_parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (_sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[_parameterIndex - 1], getName, "java.sql.Types=" + type), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIndex(_parameterIndex, true);
    }

    private void checkIndex(int _parameterIndex, boolean fetchingData) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.isFunctionT) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.lastIndex = _parameterIndex;
        }
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] _parameterLists) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new CallableBatchResultHandler(this, queries, _parameterLists);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex);
        if (this.callResult[_parameterIndex - 1] instanceof Float) {
            return BigDecimal.valueOf(((Float)this.callResult[_parameterIndex - 1]).floatValue());
        }
        if (this.callResult[_parameterIndex - 1] instanceof Double) {
            return BigDecimal.valueOf((Double)this.callResult[_parameterIndex - 1]);
        }
        if (this.callResult[_parameterIndex - 1] instanceof Long) {
            return BigDecimal.valueOf((Long)this.callResult[_parameterIndex - 1]);
        }
        if (this.callResult[_parameterIndex - 1] instanceof Short) {
            return BigDecimal.valueOf(((Short)this.callResult[_parameterIndex - 1]).shortValue());
        }
        if (this.callResult[_parameterIndex - 1] instanceof Integer) {
            return BigDecimal.valueOf(((Integer)this.callResult[_parameterIndex - 1]).intValue());
        }
        if (this.callResult[_parameterIndex - 1] instanceof BigDecimal) {
            return (BigDecimal)this.callResult[_parameterIndex - 1];
        }
        if (this.callResult[_parameterIndex - 1] instanceof String) {
            return new BigDecimal((String)this.callResult[_parameterIndex - 1]);
        }
        this.checkIndex(_parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[_parameterIndex - 1];
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            this.checkClosed_();
            this.checkIndex(i);
            if (this.callResult[i - 1] instanceof byte[]) {
                return new EsBlob((byte[])this.callResult[i - 1]);
            }
            return (Blob)this.callResult[i - 1];
        }
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            this.checkClosed_();
            this.checkIndex(i);
            if (this.callResult[i - 1] instanceof String) {
                return new EsClob(((String)this.callResult[i - 1]).toCharArray());
            }
            return (Clob)this.callResult[i - 1];
        }
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int index, Map<String, Class<?>> mapT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mapT == null || mapT.isEmpty()) {
            return this.getObject(index);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int ,Map)");
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "getRef( int)");
    }

    @Override
    public Date getDate(int i, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(i);
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String _value = this.callResult[i - 1].toString();
        return this.baseConnection.getTimestampUtils().toDate(calendar, _value);
    }

    @Override
    public Time getTime(int i, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(i);
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String _value = this.callResult[i - 1].toString();
        return this.baseConnection.getTimestampUtils().toTime(calendar, _value);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(i);
        if (this.callResult[i - 1] == null) {
            return null;
        }
        String _value = this.callResult[i - 1].toString();
        return this.baseConnection.getTimestampUtils().toTimestamp(calendar, _value);
    }

    @Override
    public void registerOutParameter(int _parameterIndex, int _sqlType, String typeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            int oid = this.baseConnection.getTypeInfo().getPGType(typeName);
            if (oid == 0) {
                this.registerOutParameter(_parameterIndex, _sqlType);
            } else {
                this.preparedParameterList.registerOutParameter(_parameterIndex, oid, this.outParmBeforeFunc);
                this.functionReturnType[_parameterIndex - 1] = _sqlType;
                this.testReturn[_parameterIndex - 1] = _sqlType;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.functionReturnType[_parameterIndex - 1] == 1 || this.functionReturnType[_parameterIndex - 1] == -1) {
                    this.testReturn[_parameterIndex - 1] = 12;
                } else if (this.functionReturnType[_parameterIndex - 1] == 6) {
                    this.testReturn[_parameterIndex - 1] = 7;
                }
                this.returnTypeSet = true;
            }
            return;
        }
        throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
    }

    @Override
    public RowId getRowId(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            this.checkClosed_();
            this.checkIndex(_parameterIndex);
            if (this.callResult[_parameterIndex - 1] == null) {
                return null;
            }
            if (this.callResult[_parameterIndex - 1] instanceof String) {
                return new PgRowId((String)this.callResult[_parameterIndex - 1]);
            }
            if (this.baseConnection.isDatabaseSupportRowid()) {
                this.checkIndex(_parameterIndex, -8, 1111, "rowid");
            } else {
                this.checkIndex(_parameterIndex, -8, 1111, "tid");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (RowId)this.callResult[_parameterIndex - 1];
        }
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (RowId)this.getXXX("getRowId", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setRowId", new Class[]{Integer.TYPE, RowId.class}, parameterName, x);
    }

    @Override
    public void setNString(String parameterName, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNString", new Class[]{Integer.TYPE, String.class}, parameterName, _value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, _value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class}, parameterName, _value);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, _value, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setCharacterStream", new Class[]{Integer.TYPE, Reader.class}, parameterName, _value);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterName, _value, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class}, parameterName, _value);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterName, _value, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class}, parameterName, _value);
    }

    @Override
    public void setNClob(String parameterName, NClob _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNClob", new Class[]{Integer.TYPE, NClob.class}, parameterName, _value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setClob", new Class[]{Integer.TYPE, Reader.class}, parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterName, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBlob", new Class[]{Integer.TYPE, InputStream.class}, parameterName, inputStream);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBlob", new Class[]{Integer.TYPE, Blob.class}, parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setClob", new Class[]{Integer.TYPE, Clob.class}, parameterName, x);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNClob", new Class[]{Integer.TYPE, Reader.class}, parameterName, reader);
    }

    @Override
    public NClob getNClob(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (NClob)this.getXXX("getNClob", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}, parameterName, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkClosed_();
        this.checkIndex(_parameterIndex, 2009, "SQLXML");
        return (SQLXML)this.callResult[_parameterIndex - 1];
    }

    @Override
    public SQLXML getSQLXML(String _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (SQLXML)this.getXXX("getSQLXML", new Class[]{Integer.TYPE}, _parameterIndex);
    }

    @Override
    public String getNString(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
            return this.getString(_parameterIndex);
        }
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (String)this.getXXX("getNString", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Reader getNCharacterStream(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Reader)this.getXXX("getNCharacterStream", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Reader getCharacterStream(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Reader)this.getXXX("getCharacterStream", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public <T> T getObject(int _parameterIndex, Class<T> type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (type == ResultSet.class) {
            return type.cast(this.getObject(_parameterIndex));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", type), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (T)this.getXXX("getObject", new Class[]{Integer.TYPE, Class.class}, parameterName, type);
    }

    @Override
    public void registerOutParameter(String parameterName, int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE}, parameterName, _sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int _sqlType, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, parameterName, _sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int _sqlType, String typeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE, String.class}, parameterName, _sqlType, typeName);
    }

    @Override
    public URL getURL(int _parameterIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public void setURL(String parameterName, URL value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setURL", new Class[]{Integer.TYPE, URL.class}, parameterName, value);
    }

    @Override
    public void setNull(String parameterName, int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNull", new Class[]{Integer.TYPE, Integer.TYPE}, parameterName, _sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setByte", new Class[]{Integer.TYPE, Byte.TYPE}, parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setShort", new Class[]{Integer.TYPE, Short.TYPE}, parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setInt", new Class[]{Integer.TYPE, Integer.TYPE}, parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setLong", new Class[]{Integer.TYPE, Long.TYPE}, parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setFloat", new Class[]{Integer.TYPE, Float.TYPE}, parameterName, Float.valueOf(x));
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setDouble", new Class[]{Integer.TYPE, Double.TYPE}, parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBigDecimal", new Class[]{Integer.TYPE, BigDecimal.class}, parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setString", new Class[]{Integer.TYPE, String.class}, parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBytes", new Class[]{Integer.TYPE, byte[].class}, parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setDate", new Class[]{Integer.TYPE, Date.class}, parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setTime", new Class[]{Integer.TYPE, Time.class}, parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class}, parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterName, x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}, parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE}, parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setObject", new Class[]{Integer.TYPE, Object.class}, parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Integer.TYPE}, parameterName, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setDate", new Class[]{Integer.TYPE, Date.class, Calendar.class}, parameterName, x, calendar);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setTime", new Class[]{Integer.TYPE, Time.class, Calendar.class}, parameterName, x, calendar);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class, Calendar.class}, parameterName, x, calendar);
    }

    @Override
    public void setNull(String parameterName, int _sqlType, String typeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setXXX("setNull", new Class[]{Integer.TYPE, Integer.TYPE, String.class}, parameterName, _sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (String)this.getXXX("getString", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Boolean)this.getXXX("getBoolean", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Byte)this.getXXX("getByte", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Short)this.getXXX("getShort", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Integer)this.getXXX("getInt", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Long)this.getXXX("getLong", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ((Float)this.getXXX("getFloat", new Class[]{Integer.TYPE}, parameterName)).floatValue();
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Double)this.getXXX("getDouble", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (byte[])this.getXXX("getBytes", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Date)this.getXXX("getDate", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Time)this.getXXX("getTime", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Timestamp)this.getXXX("getTimestamp", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getXXX("getObject", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (BigDecimal)this.getXXX("getBigDecimal", new Class[]{Integer.TYPE}, parameterName);
    }

    public Object getObjectImpl(String parameterName, Map<String, Class<?>> map) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getXXX("getObjectImpl", new Class[]{Integer.TYPE, Map.class}, parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Ref)this.getXXX("getRef", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Blob)this.getXXX("getBlob", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Clob)this.getXXX("getClob", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Array)this.getXXX("getArray", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Date)this.getXXX("getDate", new Class[]{Integer.TYPE, Calendar.class}, parameterName, calendar);
    }

    @Override
    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Time)this.getXXX("getTime", new Class[]{Integer.TYPE, Calendar.class}, parameterName, calendar);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (Timestamp)this.getXXX("getTimestamp", new Class[]{Integer.TYPE, Calendar.class}, parameterName, calendar);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (URL)this.getXXX("getURL", new Class[]{Integer.TYPE}, parameterName);
    }

    @Override
    public void registerOutParameter(int _parameterIndex, int _sqlType, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.registerOutParameter(_parameterIndex, _sqlType);
    }

    public void registerOutParameterAtName(String parameterName, int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, _sqlType: {1}", parameterName, _sqlType);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            this.registerOutParameter(_index, _sqlType);
        }
    }

    public void registerOutParameterAtName(String parameterName, int _sqlType, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, _sqlType: {1}, scale: {2}", parameterName, _sqlType, scale);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            this.registerOutParameter(_index, _sqlType, scale);
        }
    }

    public void registerOutParameterAtName(String parameterName, int _sqlType, String typeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, _sqlType: {1}, typeName: {2}", parameterName, _sqlType, typeName);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            this.registerOutParameter(_index, _sqlType, typeName);
        }
    }

    private void fillFunctionParameterNames() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.functionParameterNames.isEmpty() && this.inParamCount != 0) {
            List<String> columnNameList;
            int index = 0;
            this.parseFuncMark(this.preparedQuery);
            ResultSet resultSet = this.baseConnection.getMetaData().getProcedureColumns(null, this.schemaName, this.functionName, "%");
            HashMap<String, ArrayList<String>> specificNameMap = new HashMap<String, ArrayList<String>>();
            while (resultSet.next()) {
                String column_name = resultSet.getString("COLUMN_NAME").toLowerCase();
                String specific_name = resultSet.getString("SPECIFIC_NAME").toLowerCase();
                columnNameList = (ArrayList<String>)specificNameMap.get(specific_name);
                if (columnNameList == null) {
                    columnNameList = new ArrayList<String>();
                    specificNameMap.put(specific_name, (ArrayList<String>)columnNameList);
                }
                columnNameList.add(column_name);
            }
            block1: for (String key : specificNameMap.keySet()) {
                columnNameList = (List)specificNameMap.get(key);
                int columnNameSize = columnNameList.size();
                if (columnNameSize != this.markExistMap.size() + 1 && columnNameSize != this.markExistMap.size()) continue;
                for (int i = 0; i < columnNameSize; ++i) {
                    String columnName = (String)columnNameList.get(i);
                    if ("returnvalue".equalsIgnoreCase(columnName)) {
                        if (columnNameSize == this.markExistMap.size()) continue block1;
                        if (!this.preparedQuery.outParmBeforeFunc) continue;
                        this.functionParameterNames.add(columnName);
                        continue;
                    }
                    if (this.markExistMap.containsKey(index) && this.markExistMap.get(index).booleanValue()) {
                        this.functionParameterNames.add(columnName);
                    }
                    ++index;
                }
            }
        }
    }

    private void setXXX(String mtdName, Class<?>[] classes, Object ... x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            Method mtd = this.getClass().getMethod(mtdName, classes);
            if (this.isFunctionT && this.functionName != null && this.preparedParameterNames.isEmpty()) {
                this.fillFunctionParameterNames();
                List<Integer> _indexes = this.findIndexByName(((String)x[0]).toLowerCase(), this.functionParameterNames);
                for (int _index : _indexes) {
                    x[0] = _index;
                    mtd.invoke((Object)this, x);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            } else {
                if (!this.callParameterNames.containsKey(((String)x[0]).toLowerCase())) {
                    if (this.callParameterNames.size() >= this.inParamCount) {
                        throw new PSQLException("Invalid column index.", PSQLState.INVALID_NAME);
                    }
                    this.callParameterNames.put(((String)x[0]).toLowerCase(), ++this._paramIndex);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                x[0] = this.callParameterNames.get(((String)x[0]).toLowerCase());
                mtd.invoke((Object)this, x);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            exception.printStackTrace();
        }
    }

    private Object getXXX(String mtdName, Class<?>[] classes, Object ... x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            List<Integer> _indexes;
            Iterator<Integer> i$;
            Method mtd = this.getClass().getMethod(mtdName, classes);
            if (this.isFunctionT && this.functionName != null && this.preparedParameterNames.isEmpty() && (i$ = (_indexes = this.findIndexByName(((String)x[0]).toLowerCase(), this.functionParameterNames)).iterator()).hasNext()) {
                int _index = i$.next();
                x[0] = _index;
                return mtd.invoke((Object)this, x);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.callParameterNames.size() == 0) {
                throw new PSQLException("Ordinal binding and Named binding cannot be combined!", PSQLState.INVALID_NAME);
            }
            if (this.callParameterNames.get(((String)x[0]).toLowerCase()) == null) {
                throw new PSQLException("Invalid column name.", PSQLState.INVALID_NAME);
            }
            x[0] = this.callParameterNames.get(((String)x[0]).toLowerCase());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return mtd.invoke((Object)this, x);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            exception.printStackTrace();
            return new Object();
        }
    }
}

