/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ds.common;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.postgresql.ds.PGConnectionPoolDataSource;
import org.postgresql.ds.PGPoolingDataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.ds.common.BaseDataSource;
import org.postgresql.util.TraceLogger;

public class PGObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object objt, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Reference reference = (Reference)objt;
        String className = reference.getClassName();
        if (className.equals("org.postgresql.ds.PGSimpleDataSource") || className.equals("org.postgresql.jdbc2.optional.SimpleDataSource") || className.equals("org.postgresql.jdbc3.Jdbc3SimpleDataSource")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.loadSimpleDataSource(reference);
        }
        if (className.equals("org.postgresql.ds.PGConnectionPoolDataSource") || className.equals("org.postgresql.jdbc2.optional.ConnectionPool") || className.equals("org.postgresql.jdbc3.Jdbc3ConnectionPool")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.loadConnectionPool(reference);
        }
        if (className.equals("org.postgresql.ds.PGPoolingDataSource") || className.equals("org.postgresql.jdbc2.optional.PoolingDataSource") || className.equals("org.postgresql.jdbc3.Jdbc3PoolingDataSource")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.loadPoolingDataSource(reference);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String name = this.getProperty(reference, "dSName");
        PGPoolingDataSource poolingDataSource = PGPoolingDataSource.getDataSource(name);
        if (poolingDataSource != null) {
            return poolingDataSource;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        poolingDataSource = new PGPoolingDataSource();
        poolingDataSource.setDataSourceName(name);
        this.loadBaseDataSource(poolingDataSource, reference);
        String minString = this.getProperty(reference, "initialConnections");
        if (minString != null) {
            poolingDataSource.setInitialConnections(Integer.parseInt(minString));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String maxString = this.getProperty(reference, "maxConnections");
        if (maxString != null) {
            poolingDataSource.setMaxConnections(Integer.parseInt(maxString));
        }
        return poolingDataSource;
    }

    private Object loadSimpleDataSource(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGSimpleDataSource ds = new PGSimpleDataSource();
        return this.loadBaseDataSource(ds, reference);
    }

    private Object loadConnectionPool(Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGConnectionPoolDataSource cp = new PGConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, reference);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference reference) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ds.setFromReference(reference);
        return ds;
    }

    protected String getProperty(Reference reference, String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        RefAddr addr = reference.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

