/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.hostchooser;

import java.util.logging.Level;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.util.TraceLogger;

public enum HostRequirement {
    any{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus != HostStatus.ConnectFail;
        }
    }
    ,
    master{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus == HostStatus.Master || hostStatus == HostStatus.ConnectOK || hostStatus == HostStatus.First;
        }
    }
    ,
    secondary{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus == HostStatus.Secondary || hostStatus == HostStatus.ConnectOK || hostStatus == HostStatus.First;
        }
    }
    ,
    preferSecondary{

        @Override
        public boolean allowConnectingTo(HostStatus hostStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return hostStatus != HostStatus.ConnectFail;
        }
    };


    public abstract boolean allowConnectingTo(HostStatus var1);

    public static HostRequirement getTargetServerType(String targetServerTypeT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String allowSlaveT = targetServerTypeT.replace("lave", "econdary");
        return HostRequirement.valueOf(allowSlaveT);
    }
}

