/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.TypeInfoCacheFactory;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> pgNameToSQLType;
    private Map<String, String> pgNameToJavaClass;
    private Map<Integer, String> oidToPgName;
    private Map<String, Integer> pgNameToOid;
    private Map<String, Class<? extends PGobject>> pgNameToPgObject;
    private Map<Integer, Integer> pgArrayToPgType;
    private Map<Integer, Character> arrayOidToDelimiter;
    private BaseConnection conn;
    protected final int unknownLength;
    private PreparedStatement getOidStatementSimple;
    private PreparedStatement getOidStatementComplexNonArray;
    private PreparedStatement getOidStatementComplexArray;
    private PreparedStatement getNameStatement;
    private PreparedStatement getArrayElementOidStatement;
    private PreparedStatement getArrayDelimiterStatement;
    private PreparedStatement getTypeInfoStatement;
    private PreparedStatement getTypeInfoStatement2;
    private PreparedStatement getTypeWithModStatement;
    private TypeInfoCacheFactory typeInfoCacheFactory;

    public Object[][] getTypes() {
        return this.typeInfoCacheFactory.getTypeInfoCache().getTypes();
    }

    public HashMap<String, String> getTypeAliases() {
        return this.typeInfoCacheFactory.getTypeInfoCache().getTypeAliases();
    }

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this.conn = conn;
        this.typeInfoCacheFactory = new TypeInfoCacheFactory(conn, this);
        this.unknownLength = unknownLength;
        this.oidToPgName = new HashMap<Integer, String>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgNameToOid = new HashMap<String, Integer>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgNameToJavaClass = new HashMap<String, String>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>((int)Math.round((double)this.getTypes().length * 1.5));
        this.pgArrayToPgType = new HashMap<Integer, Integer>((int)Math.round((double)this.getTypes().length * 1.5));
        this.arrayOidToDelimiter = new HashMap<Integer, Character>((int)Math.round((double)this.getTypes().length * 2.5));
        this.pgNameToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)this.getTypes().length * 1.5)));
        for (Object[] type : this.getTypes()) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
        this.pgNameToJavaClass.put("hstore", Map.class.getName());
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this.pgNameToJavaClass.put(pgTypeName, javaClass);
        this.pgNameToOid.put(pgTypeName, oid);
        this.oidToPgName.put(oid, pgTypeName);
        this.pgArrayToPgType.put(arrayOid, oid);
        this.pgNameToSQLType.put(pgTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this.arrayOidToDelimiter.put(oid, delim);
        this.arrayOidToDelimiter.put(arrayOid, delim);
        String pgArrayTypeName = pgTypeName + "[]";
        this.pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this.pgNameToSQLType.put(pgArrayTypeName, 2003);
        this.pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        if (!this.pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            this.pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this.pgNameToSQLType.put(pgArrayTypeName, 2003);
            this.pgNameToOid.put(pgArrayTypeName, arrayOid);
            this.oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this.pgNameToPgObject.put(type, klass);
        this.pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this.pgNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(Object param) throws SQLException {
        ResultSet rs;
        String pgTypeName;
        int oid = 0;
        if (param instanceof Integer) {
            oid = (Integer)param;
            pgTypeName = this.getPGType(oid);
        } else {
            pgTypeName = (String)param;
        }
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this.pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        String sql = "SELECT typinput='array_in'::regproc, typtype   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace ";
        if (param instanceof Integer) {
            if (this.getTypeInfoStatement2 == null) {
                sql = sql + " WHERE pg_type.oid = ? " + " ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getTypeInfoStatement2 = this.conn.prepareStatement(sql);
            }
            this.getTypeInfoStatement2.setInt(1, oid);
            if (!((BaseStatement)((Object)this.getTypeInfoStatement2)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            rs = this.getTypeInfoStatement2.getResultSet();
        } else {
            if (this.getTypeInfoStatement == null) {
                sql = sql + " WHERE typname = ? " + " ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getTypeInfoStatement = this.conn.prepareStatement(sql);
            }
            this.getTypeInfoStatement.setString(1, pgTypeName);
            if (!((BaseStatement)((Object)this.getTypeInfoStatement)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            rs = this.getTypeInfoStatement.getResultSet();
        }
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String typtype = rs.getString(2);
            if (isArray) {
                type = 2003;
            } else if ("c".equals(typtype)) {
                type = 2002;
            } else if ("d".equals(typtype)) {
                type = 2001;
            } else if ("e".equals(typtype)) {
                type = 12;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        this.pgNameToSQLType.put(pgTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        String name;
        String schema;
        String fullName;
        PreparedStatement oidStatementComplex;
        String sql;
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        if (dotIndex == -1 && !hasQuote && !isArray) {
            if (this.getOidStatementSimple == null) {
                String sql2 = "SELECT pg_type.oid, typname   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getOidStatementSimple = this.conn.prepareStatement(sql2);
            }
            String lcName = pgTypeName.toLowerCase();
            this.getOidStatementSimple.setString(1, lcName);
            return this.getOidStatementSimple;
        }
        if (isArray) {
            if (this.getOidStatementComplexArray == null) {
                sql = this.conn.haveMinimumServerVersion(ServerVersion.v8_3) ? "SELECT t.typarray, arr.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid  JOIN pg_catalog.pg_type arr ON arr.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1" : "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this.getOidStatementComplexArray = this.conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexArray;
        } else {
            if (this.getOidStatementComplexNonArray == null) {
                sql = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArray = this.conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexNonArray;
        }
        String string = fullName = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName;
        } else if (fullName.startsWith("\"")) {
            if (fullName.endsWith("\"")) {
                String[] parts = fullName.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName.lastIndexOf(46);
                name = fullName.substring(lastDotIndex + 1);
                schema = fullName.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName.substring(0, dotIndex);
            name = fullName.substring(dotIndex + 1);
        }
        if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
            schema = schema.substring(1, schema.length() - 1);
        } else if (schema != null) {
            schema = schema.toLowerCase();
        }
        name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase();
        oidStatementComplex.setString(1, name);
        oidStatementComplex.setString(2, schema);
        oidStatementComplex.setBoolean(3, schema == null);
        return oidStatementComplex;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = this.pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this.oidToPgName.put(oid, internalName);
            this.pgNameToOid.put(internalName, oid);
        }
        this.pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = this.oidToPgName.get(oid);
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this.getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getNameStatement = this.conn.prepareStatement(sql);
        }
        this.getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this.getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                pgTypeName = name;
                this.pgNameToOid.put(schema + "." + name, oid);
            } else {
                pgTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this.pgNameToOid.put(schema + "." + name, oid);
                }
            }
            this.pgNameToOid.put(pgTypeName, oid);
            this.oidToPgName.put(oid, pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    @Override
    public synchronized String getPGTypeWithMod(int oid, int mod) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeNameWithMod = new String();
        if (this.getTypeWithModStatement == null) {
            String sql = "select pg_catalog.format_type(?,?)";
            this.getTypeWithModStatement = this.conn.prepareStatement(sql);
        }
        this.getTypeWithModStatement.setInt(1, oid);
        this.getTypeWithModStatement.setInt(2, mod);
        if (!((BaseStatement)((Object)this.getTypeWithModStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this.getTypeWithModStatement.getResultSet();
        if (rs.next()) {
            pgTypeNameWithMod = rs.getString(1);
        }
        rs.close();
        int pos = pgTypeNameWithMod.indexOf(40);
        if (pos != -1) {
            pgTypeNameWithMod = pgTypeNameWithMod.substring(0, pos);
        }
        return pgTypeNameWithMod;
    }

    @Override
    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        return this.getPGType(elementTypeName + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this.pgArrayToPgType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this.arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this.getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this.getArrayDelimiterStatement = this.conn.prepareStatement(sql);
        }
        this.getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this.getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this.arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = this.pgArrayToPgType.get(oid);
        if (pgType != null) {
            return pgType;
        }
        if (this.getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getArrayElementOidStatement = this.conn.prepareStatement(sql);
        }
        this.getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this.getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        pgType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this.pgArrayToPgType.put(oid, pgType);
        this.pgNameToOid.put(schema + "." + name, pgType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this.pgNameToOid.put(fullName, pgType);
        if (onPath && name.equals(name.toLowerCase())) {
            this.oidToPgName.put(pgType, name);
            this.pgNameToOid.put(name, pgType);
        } else {
            this.oidToPgName.put(pgType, fullName);
        }
        rs.close();
        return pgType;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        return this.pgNameToPgObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        String result = this.pgNameToJavaClass.get(pgTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this.pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = this.getTypeAliases().get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = this.getTypeAliases().get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        return this.typeInfoCacheFactory.getTypeInfoCache().getPrecision(oid, typmod);
    }

    @Override
    public int getColumnSize(int oid, int typmod) {
        return this.typeInfoCacheFactory.getTypeInfoCache().getColumnSize(oid, typmod);
    }

    @Override
    public int getScale(int oid, int typmod) {
        return this.typeInfoCacheFactory.getTypeInfoCache().getScale(oid, typmod);
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: 
            case 7014: 
            case 7015: 
            case 7016: 
            case 8020: 
            case 8100: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: 
            case 7014: 
            case 7015: 
            case 7016: 
            case 8100: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        return this.typeInfoCacheFactory.getTypeInfoCache().getDisplaySize(oid, typmod);
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: 
            case 8016: 
            case 8018: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }
}

