/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.copy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.copy.CopyDual;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyOperation;
import org.postgresql.copy.CopyOut;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class CopyManager {
    static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Encoding _encoding;
    private final QueryExecutor queryExecutorImpl;
    private final BaseConnection _connection;

    public CopyManager(BaseConnection _connection) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encoding = _connection.getEncoding();
        this.queryExecutorImpl = _connection.getQueryExecutor();
        this._connection = _connection;
    }

    public CopyIn copyIn(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CopyOperation operation = this.queryExecutorImpl.startCopy(_sql, this._connection.getAutoCommit());
        if (operation == null || operation instanceof CopyIn) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (CopyIn)operation;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        operation.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyIn but got {0}", operation.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public CopyOut copyOut(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CopyOperation operation = this.queryExecutorImpl.startCopy(_sql, this._connection.getAutoCommit());
        if (operation == null || operation instanceof CopyOut) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (CopyOut)operation;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        operation.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyOut but got {0}", operation.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public CopyDual copyDual(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CopyOperation operation = this.queryExecutorImpl.startCopy(_sql, this._connection.getAutoCommit());
        if (operation == null || operation instanceof CopyDual) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return (CopyDual)operation;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        operation.cancelCopy();
        throw new PSQLException(GT.tr("Requested CopyDual but got {0}", operation.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public long copyOut(String _sql, Writer to) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CopyOut cpT = this.copyOut(_sql);
        try {
            byte[] _buf;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while ((_buf = cpT.readFromCopy()) != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                to.write(this._encoding.decode(_buf));
            }
            long l = cpT.getHandledRowCount();
            return l;
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cpT.isActive()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.cancelCopy();
            }
            try {
                byte[] _buf;
                while ((_buf = cpT.readFromCopy()) != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
            catch (SQLException sqlException) {}
            throw ioException;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cpT.isActive()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.cancelCopy();
            }
        }
    }

    public long copyOut(String _sql, OutputStream to) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CopyOut cpT = this.copyOut(_sql);
        try {
            byte[] _buf;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while ((_buf = cpT.readFromCopy()) != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                to.write(_buf);
            }
            long l = cpT.getHandledRowCount();
            return l;
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cpT.isActive()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.cancelCopy();
            }
            try {
                byte[] _buf;
                while ((_buf = cpT.readFromCopy()) != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
            catch (SQLException sqlException) {}
            throw ioException;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cpT.isActive()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.cancelCopy();
            }
        }
    }

    public long copyIn(String _sql, Reader from) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.copyIn(_sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String _sql, Reader from, int _bufferSize) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char[] c_buf = new char[_bufferSize];
        CopyIn cpT = this.copyIn(_sql);
        try {
            int leng;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while ((leng = from.read(c_buf)) >= 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (leng <= 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] _buf = this._encoding.encode(new String(c_buf, 0, leng));
                cpT.writeToCopy(_buf, 0, _buf.length);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long l = cpT.endCopy();
            return l;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cpT.isActive()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.cancelCopy();
            }
        }
    }

    public long copyIn(String _sql, InputStream from) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.copyIn(_sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String _sql, InputStream from, int _bufferSize) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _buf = new byte[_bufferSize];
        CopyIn cpT = this.copyIn(_sql);
        try {
            int leng;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while ((leng = from.read(_buf)) >= 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (leng <= 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.writeToCopy(_buf, 0, leng);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long l = cpT.endCopy();
            return l;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (cpT.isActive()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                cpT.cancelCopy();
            }
        }
    }
}

