/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint[] points;

    public PGpath(PGpoint[] pointsT, boolean openT) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.open = openT;
        this.points = pointsT;
    }

    public PGpath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("path");
    }

    public PGpath(String s) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(s);
    }

    @Override
    public void setValue(String value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (value.startsWith("[") && value.endsWith("]")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.open = true;
            value = PGtokenizer.removeBox(value);
        } else if (value.startsWith("(") && value.endsWith(")")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.open = false;
            value = PGtokenizer.removePara(value);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", value), PSQLState.DATA_TYPE_MISMATCH);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGtokenizer t = new PGtokenizer(value, ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.points[p] = new PGpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof PGpath) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGpath pnt = (PGpath)objt;
            if (pnt.points.length != this.points.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            if (pnt.open != this.open) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.points[i].equals(pnt.points[i])) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGpath newPGpath = (PGpath)super.clone();
        if (newPGpath.points != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newPGpath.points = (PGpoint[])newPGpath.points.clone();
            for (int i = 0; i < newPGpath.points.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newPGpath.points[i] = (PGpoint)newPGpath.points[i].clone();
            }
        }
        return newPGpath;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hashVal = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hashVal ^= this.points[i].hashCode();
        }
        return hashVal;
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder stringBuilder = new StringBuilder(this.open ? "[" : "(");
        for (int i = 0; i < this.points.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(",");
            }
            stringBuilder.append(this.points[i].toString());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(this.open ? "]" : ")");
        return stringBuilder.toString();
    }

    public boolean isOpen() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open;
    }

    public void openPath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.open = true;
    }

    public void closePath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.open = false;
    }

    public boolean isClosed() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return !this.open;
    }
}

