/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.util.HashMap;
import java.util.logging.Level;
import org.postgresql.jdbc.AbstractTypeInfoCache;
import org.postgresql.jdbc.TypeInfoCache;
import org.postgresql.util.TraceLogger;

public class PgTypeInfoCache
extends AbstractTypeInfoCache {
    private static final Object[][] typesT = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"json", 114, 1111, "org.postgresql.util.PGobject", 199}, {"point", 600, 1111, "org.postgresql.geometric.PGpoint", 1017}};
    private static final HashMap<String, String> typeAliasesMap;

    public PgTypeInfoCache(TypeInfoCache typeInfoCache) {
        super(typeInfoCache);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public Object[][] getTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return typesT;
    }

    @Override
    public HashMap<String, String> getTypeAliases() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return typeAliasesMap;
    }

    @Override
    public int getPrecision(int oidT, int typemod) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 7015: 
            case 7016: 
            case 7017: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 7;
            }
            case 7014: 
            case 8100: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 3;
            }
            case 21: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 5;
            }
            case 23: 
            case 26: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 10;
            }
            case 701: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 17;
            }
            case 20: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 19;
            }
            case 700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 8;
            }
            case 16: 
            case 18: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 1;
            }
            case 1700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemod == -1) {
                    return 0;
                }
                return (typemod - 4 & 0xFFFF0000) >> 16;
            }
            case 1042: 
            case 1043: 
            case 8016: 
            case 8018: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 8020: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getDisplaySize(oidT, typemod);
            }
            case 1560: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return typemod;
            }
            case 1562: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemod == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemod;
            }
            case 27: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 18;
            }
            case 7000: 
            case 7002: {
                return typemod >> 8 & 0xFF;
            }
            case 6123: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 23;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getDisplaySize(int oidT, int typemodT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int value = 0;
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 7015: 
            case 7016: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 8;
            }
            case 7014: 
            case 8100: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 4;
            }
            case 21: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 6;
                return value;
            }
            case 23: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 11;
                return value;
            }
            case 26: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 10;
                return value;
            }
            case 20: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 20;
                return value;
            }
            case 18: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 1;
            }
            case 700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 15;
            }
            case 701: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 25;
            }
            case 16: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 1;
                return value;
            }
            case 1082: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = 13;
                return value;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 8020: {
                int secondSizeT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                switch (typemodT) {
                    case -1: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = 7;
                        break;
                    }
                    case 0: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = 0;
                        break;
                    }
                    case 1: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = 3;
                        break;
                    }
                    default: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        secondSizeT = typemodT + 1;
                    }
                }
                switch (oidT) {
                    case 1083: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 8 + secondSizeT;
                    }
                    case 1266: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 8 + secondSizeT + 6;
                    }
                    case 1184: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 22 + secondSizeT + 6;
                    }
                    case 1114: 
                    case 8020: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return 22 + secondSizeT;
                    }
                }
            }
            case 1186: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 49;
            }
            case 1042: 
            case 1043: 
            case 8016: 
            case 8018: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT - 4;
            }
            case 1700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 131089;
                }
                int precision = typemodT - 4 >> 16 & 0xFFFF;
                int scale = typemodT - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return typemodT;
            }
            case 1562: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return this.typeInfoCache.unknownLength;
                }
                return typemodT;
            }
            case 17: 
            case 25: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.typeInfoCache.unknownLength;
            }
            case 27: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 18;
            }
            case 6123: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 23;
            }
            case 7002: {
                return 5;
            }
            case 7000: {
                return 11;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.typeInfoCache.unknownLength;
    }

    @Override
    public int getScale(int oidT, int typemodT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        oidT = this.typeInfoCache.convertArrayToBaseOid(oidT);
        switch (oidT) {
            case 700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 8;
            }
            case 701: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 17;
            }
            case 1700: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 0;
                }
                return typemodT - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 6;
                }
                return typemodT;
            }
            case 1186: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (typemodT == -1) {
                    return 6;
                }
                return typemodT & 0xFFFF;
            }
            case 7000: 
            case 7002: {
                return typemodT & 0xFF;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getColumnSize(int oidT, int typemodT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getPrecision(oidT, typemodT);
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        typeAliasesMap = new HashMap();
        typeAliasesMap.put("smallint", "int2");
        typeAliasesMap.put("integer", "int4");
        typeAliasesMap.put("int", "int4");
        typeAliasesMap.put("bigint", "int8");
        typeAliasesMap.put("float", "float8");
        typeAliasesMap.put("boolean", "bool");
        typeAliasesMap.put("decimal", "numeric");
    }
}

