/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.util.logging.Level;
import org.postgresql.core.Encoding;
import org.postgresql.util.TraceLogger;

public class EncodingPredictor {
    private static final TranslationT[] FATAL_TRANSLATIONS_T = new TranslationT[]{new TranslationT("\u0412\u0410\u0416\u041d\u041e", null, "ru", "WIN", "ALT", "KOI8"), new TranslationT("\u81f4\u547d\u9519\u8bef", null, "zh_CN", "EUC_CN", "GBK", "BIG5"), new TranslationT("KATASTROFALNY", null, "pl", "LATIN2"), new TranslationT("FATALE", null, "it", "LATIN1", "LATIN9"), new TranslationT("FATAL", new String[]{"\u306f\u5b58\u5728\u3057\u307e\u305b\u3093", "\u30ed\u30fc\u30eb", "\u30e6\u30fc\u30b6"}, "ja", "EUC_JP", "SJIS"), new TranslationT(null, null, "fr/de/es/pt_BR", "LATIN1", "LATIN3", "LATIN4", "LATIN5", "LATIN7", "LATIN9")};

    public static DecodeResult decode(byte[] bytesT, int offsetT, int length) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Encoding defaultEncode = Encoding.defaultEncoding();
        for (TranslationT translationT : FATAL_TRANSLATIONS_T) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (String encodingStr : translationT.encodingsT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Encoding encoderT = Encoding.getDatabaseEncoding(encodingStr);
                if (encoderT == defaultEncode) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    continue;
                }
                if (translationT.fatalTextT != null) {
                    byte[] encodedBytes;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        byte[] tmp = encoderT.encode(translationT.fatalTextT);
                        encodedBytes = new byte[tmp.length + 2];
                        encodedBytes[0] = 83;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        encodedBytes[encodedBytes.length - 1] = 0;
                        System.arraycopy(tmp, 0, encodedBytes, 1, tmp.length);
                    }
                    catch (IOException e) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue;
                    }
                    if (!EncodingPredictor.arrayContains(bytesT, offsetT, length, encodedBytes, 0, encodedBytes.length)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue;
                    }
                }
                if (translationT.textsT != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    boolean found = false;
                    for (String text : translationT.textsT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        try {
                            byte[] textBytes = encoderT.encode(text);
                            if (!EncodingPredictor.arrayContains(bytesT, offsetT, length, textBytes, 0, textBytes.length)) continue;
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            found = true;
                            break;
                        }
                        catch (IOException e) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        }
                    }
                    if (!found) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue;
                    }
                }
                try {
                    String decoded = encoderT.decode(bytesT, offsetT, length);
                    if (decoded.indexOf(65533) == -1) {
                        return new DecodeResult(decoded, encoderT.name());
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                catch (IOException e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
        }
        return null;
    }

    private static boolean arrayContains(byte[] first, int firstOffset, int theFirstLength, byte[] second, int secondOffset, int theSecondLength) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (theFirstLength < theSecondLength) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        for (int i = 0; i < theFirstLength; ++i) {
            int j;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (i < theFirstLength && first[firstOffset + i] != second[secondOffset]) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ++i;
            }
            for (j = 1; j < theSecondLength && first[firstOffset + i + j] == second[secondOffset + j]; ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            if (j != theSecondLength) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        return false;
    }

    static class TranslationT {
        public final String fatalTextT;
        private final String[] textsT;
        public final String languageT;
        public final String[] encodingsT;

        TranslationT(String fatalText, String[] texts, String language, String ... _encodings) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.fatalTextT = fatalText;
            this.textsT = texts;
            this.languageT = language;
            this.encodingsT = _encodings;
        }
    }

    public static class DecodeResult {
        public final String _encoding;
        public final String _result;

        DecodeResult(String _result, String _encoding) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._encoding = _encoding;
            this._result = _result;
        }
    }
}

