/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.DriverPropertyInfo;
import java.util.Properties;
import java.util.logging.Level;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public enum PGProperty {
    USEDISPATCH("USEDISPATCH", "false", "Use dispatch  to _connect", false, "true", "false"),
    HOSTLOADRATE("HOSTLOADRATE", "0", "Use dispatch  to _connect", false),
    SLAVE_ADD("SLAVE_ADD", null, "ip of the slave server to _connect", false),
    SLAVE_PORT("SLAVE_PORT", null, "port of the slave server to _connect", false),
    USECONNECT_POOL("USECONNECT_POOL", "false", "Use jdbc _connect pool to cache _connect", false, "true", "false"),
    CONNECT_POOLSIZE("CONNECT_POOLSIZE", "10", "default jdbc _connect pool size", false),
    MASTER_CHECK("MASTER_CHECK", "true", "open check DB is master or no", false, "true", "false"),
    CLUSTER_MONITOR("CLUSTER_MONITOR", "true", "start a thread do CLUSTER_MONITOR", false, "true", "false"),
    MONITORINTERVAL("MONITORINTERVAL", "5", "CLUSTER_MONITOR thread sleep xx seconds every time", false),
    MONITOR_SOCKET_TIMEOUT("monitorSocketTimeout", "5", "The timeout value used for CLUSTER_MONITOR socket read operations.", false),
    RETRYTIMES("RETRYTIMES", "10", "For dispatch retry execute stmt when stmt fail", false),
    RETRYINTERVAL("RETRYINTERVAL", "5", "For dispatch retry execute stmt sleep xx seconds when stmt fail", false),
    CONFIGUREPATH("ConfigurePath", null, "Path of configuration file"),
    WHITELIST("WhiteList", null, "Specifies a list of read-only functions"),
    BLACKLIST("BlackList", null, "Specifies a list of write functions"),
    MASTERFUNCTIONLIST("MasterFunctionList", null, "Specifies a list of write functions that do not change transaction status"),
    ALL_SEND_FUNCTION_LIST("allSendFunctionList", null, "Specifies a list of functions which send to all nodes."),
    TEMPTABLE("TempTable", null, "Specifies a list of temp tables"),
    BLACKSQLLIST("BlackSqlList", null, "Specifies a list of _sql stmts that send to master but do not change transaction status"),
    TRANSACTIONDISPATCHSTRATEGY("TransactionDispatchStrategy", "2", "Controlling dispatch strategy for transactions"),
    READ_LIST_STRATEGY("readListStrategy", "1", "Specifies the data synchronization level:1 means the stmt can send to all machines.2 means the stmt is only sent to the synchronous standby machines.3 means the statement can send to the standby machines within the allowable difference with the host machine.4 means the statement is only sent to the asynchronous standby machines."),
    DIFFERENT_LSN("differentLsn", "0", "Allowable difference between the standby machine and the host machine."),
    STABLE_SLAVE("StableSlave", "false", "for a dispatch_conn only send to a fixed slave or master node."),
    LOADBALANCE_STRATEGY("loadBalanceStrategy", "1", "Specifies the data synchronization level:1 means use _sql items strategy.2 means use stable slave _connect strategy.3 means use _sql consume time strategy."),
    MASTER_KEYWORD("masterKeyword", null, "Specifies the _keyword included in notes that send to master but do not change transaction status."),
    USE_FETCH_SIZE_IN_AUTO_COMMIT("useFetchSizeInAutoCommit", "false", "Specifies whether to use fetchsize in autocomit mode."),
    NULL_CONVERT_EMPTY_LOB("nullConvertEmptyLob", "true", "Specifies whether the driver returns null or empty large object to the client when the large object is returned from the database as null"),
    INIT_PARAMS("initParams", null, "Specify the GUC _parameters to initialize the database _connection."),
    CLIENT_ENCODING("clientEncoding", null, "client _encoding", false),
    NODE_LIST("nodeList", null, "Specifies the application_name of each _host defined in table pg_stat_replication."),
    OPTIMIZE_BATCHED_DML("optimizeBatchedDML", "false", "When DML stmts are executed in batch, all binding _parameters are sent to the database in a _bind message."),
    STORE_CASE("storeCase", "lower", "Specifies how database identifiers are stored.", false, "lower", "upper", "original"),
    STRUCT_TYPE("structType", null, "The type to return Types.STRUCT as (usually 'PGobject')", false, "Struct", "PGobject"),
    ROWID_TYPE("rowidType", null, "The type to return Types.ROWID as (usually 'PGobject')", false, "rowid", "PGobject"),
    ZIP_LEVEL("zipLevel", "0", "Specifies the compression level of the data."),
    FAST_FAILOVER("fastFailover", "false", "Specifies whether to turn on stand-alone fast failover."),
    UKPWD_CERT("ukpwdcert", null, "The location of the client's UKPWD certificate"),
    UKPWD_KEY("ukpwdkey", null, "The location of the client's PKCS#8 UKPWD key"),
    UKPWD_ROOT_CERT("ukpwdrootcert", null, "The location of the root certificate for authenticating the server."),
    UKPWD_PASSWORD("ukpwdpassword", null, "The password for the client's UKPWD key (ignored if sslpasswordcallback is set)"),
    UKPWD_PASSWORD_CALLBACK("ukpwdpasswordcallback", null, "A class, implementing javax.security.auth.callback.CallbackHandler that can handle PassworCallback for the ssl password."),
    PG_HOST("PGHOST", null, "Hostname of the PostgreSQL server (may be specified directly in the JDBC URL)", false),
    PG_DBNAME("PGDBNAME", null, "Database name to _connect to (may be specified directly in the JDBC URL)", true),
    USER("user", null, "Username to _connect to the database as.", true),
    PG_PORT("PGPORT", null, "Port of the PostgreSQL server (may be specified directly in the JDBC URL)"),
    PASSWORD("password", null, "Password to use when authenticating. ", false),
    PROTOCOL_VERSION("protocolVersion", null, "Force use of a particular protocol _version when _connecting, currently only _version 3 is supported. ", false, "3"),
    PASSWORD_ENCRYPTION("passwordEncryption", null, "The way of _encoding the password.", false),
    LOGGER_LEVEL("loggerLevel", null, "Logger level of the driver", false, "OFF", "DEBUG", "TRACE"),
    OPTIONS("options", null, "Specify 'options' _connection initialization _parameter."),
    PREPARE_THRESHOLD("prepareThreshold", "5", "Statement prepare threshold. A _value of {@code -1} stands for forceBinary"),
    LOGGER_FILE("loggerFile", null, "File name output of the Logger"),
    PREPARED_STATEMENT_CACHE_SIZE_MIB("preparedStatementCacheSizeMiB", "5", "Specifies the maximum size (in mega_bytes) of a per-_connection prepared stmt cache. A _value of {@code 0} disables the cache."),
    PREPARED_STATEMENT_CACHE_QUERIES("preparedStatementCacheQueries", "256", "Specifies the maximum number of entries in per-_connection cache of prepared stmts. A _value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS_MIB("databaseMetadataCacheFieldsMiB", "5", "Specifies the maximum size (in mega_bytes) of _fields to be cached per _connection. A _value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS("databaseMetadataCacheFields", "65536", "Specifies the maximum number of _fields to be cached per _connection. A _value of {@code 0} disables the cache."),
    READ_ONLY("readOnly", "false", "Puts this _connection in read-only mode"),
    BINARY_TRANSFER("binaryTransfer", "true", "Use binary format for sending and receiving data if possible"),
    BINARY_TRANSFER_DISABLE("binaryTransferDisable", "", "Comma separated list of types to disable binary transfer. Either OID numbers or names. Overrides values in the driver default set and values set with binaryTransferEnable."),
    BINARY_TRANSFER_ENABLE("binaryTransferEnable", "", "Comma separated list of types to enable binary transfer. Either OID numbers or names"),
    UNKNOWN_LENGTH("unknownLength", Integer.toString(Integer.MAX_VALUE), "Specifies the length to return for types of unknown length"),
    STRING_TYPE("stringtype", null, "The type to _bind String _parameters as (usually 'varchar', 'unspecified' allows implicit casting to other types)", false, "unspecified", "varchar"),
    LOG_SERVER_ERROR_DETAIL("logServerErrorDetail", "true", "Include full server _error detail in exception messages. If disabled then only the _error itself will be included."),
    LOG_UNCLOSED_CONNECTIONS("logUnclosedConnections", "false", "When _connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the _connection to trace the leak source"),
    DISABLE_COLUMN_SANITISER("disableColumnSanitiser", "false", "Enable optimization that disables _column name sanitiser"),
    DEFAULT_ROW_FETCH_SIZE("defaultRowFetchSize", "0", " Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    SSL_MODE("sslmode", null, "Parameter governing the use of SSL", false, "disable", "allow", "prefer", "require", "verify-ca", "verify-full"),
    SSL("ssl", null, "Control use of SSL (any non-null _value causes SSL to be required)"),
    SSL_FACTORY_ARG("sslfactoryarg", null, "Argument forwarded to constructor of SSLSocketFactory class."),
    SSL_FACTORY("sslfactory", null, "Provide a SSLSocketFactory class when using SSL."),
    SSL_CERT("sslcert", null, "The location of the client's SSL certificate"),
    SSL_HOSTNAME_VERIFIER("sslhostnameverifier", null, "A class, implementing javax.net.ssl.HostnameVerifier that can verify the server"),
    SSL_ROOT_CERT("sslrootcert", null, "The location of the root certificate for authenticating the server."),
    SSL_KEY("sslkey", null, "The location of the client's PKCS#8 SSL _key"),
    TCP_KEEP_ALIVE("tcpKeepAlive", "false", "enable or disable TCP keep-alive. The default is false."),
    SSL_PASSWORD("sslpassword", null, "The password for the client's ssl _key (ignored if sslpasswordcallback is set)"),
    CONNECT_TIMEOUT("connectTimeout", "10", "The _timeout _value used for socket _connect operations."),
    LOGIN_TIMEOUT("loginTimeout", "0", "Specify how long to wait for establishment of a database _connection."),
    CANCEL_SIGNAL_TIMEOUT("cancelSignalTimeout", "10", "The _timeout that is used for sending cancel command."),
    SOCKET_TIMEOUT("socketTimeout", "0", "The _timeout _value used for socket read operations."),
    RECEIVE_BUFFER_SIZE("receiveBufferSize", "-1", "Socket read _buffer size"),
    SOCKET_FACTORY("socketFactory", null, "Specify a socket factory for socket creation"),
    ASSUME_MIN_SERVER_VERSION("assumeMinServerVersion", "12.1", "Assume the server is at least that _version"),
    SEND_BUFFER_SIZE("sendBufferSize", "-1", "Socket write _buffer size"),
    JAAS_APPLICATION_NAME("jaasApplicationName", null, "specifies the name of the JAAS system or application login configuration."),
    APPLICATION_NAME("ApplicationName", "PostgreSQL JDBC Driver", "Name of the Application (backend >= 9.0)"),
    KERBEROS_SERVER_NAME("kerberosServerName", null, "The Kerberos service name to use when authenticating with GSSAPI."),
    SOCKET_FACTORY_ARG("socketFactoryArg", null, "argument forwarded to constructor of SocketFactory class."),
    USE_SPNEGO("useSpnego", "false", "Use SPNEGO in SSPI authentication requests"),
    SSL_PASSWORD_CALLBACK("sslpasswordcallback", null, "a class, implementing javax.security.auth.callback.CallbackHandler that can handle PassworCallback for the ssl password."),
    SSPI_SERVICE_CLASS("sspiServiceClass", "POSTGRES", "The Windows SSPI service class for SPN"),
    GSS_LIB("gsslib", "auto", "Force SSSPI or GSSAPI", false, "auto", "sspi", "gssapi"),
    CURRENT_SCHEMA("currentSchema", null, "Specify the schema (or several schema separated by commas) to be set in the search-path"),
    ALLOW_ENCODING_CHANGES("allowEncodingChanges", "true", "Allow for changes in client_encoding"),
    LOAD_BALANCE_HOSTS("loadBalanceHosts", "false", "If disabled _hosts are _connected in the given order. If enabled _hosts are chrosen randomly from the set of suitable candidates"),
    TARGET_SERVER_TYPE("targetServerType", "any", "Specifies what kind of server to _connect", false, "any", "master", "slave", "secondary", "preferSlave", "preferSecondary"),
    PREFER_QUERY_MODE("preferQueryMode", "extended", "Specifies which mode is used to execute queries to database: simple means ('Q' execute, no parse, no _bind, text mode only), extended means always use _bind/execute messages, extendedForPrepared means extended for prepared stmts only, extendedCacheEverything means use extended protocol and try cache every stmt (including Statement.execute(String _sql)) in a query cache.", false, "extended", "extendedForPrepared", "extendedCacheEverything", "simple"),
    HOST_RECHECK_SECONDS("hostRecheckSeconds", "10", "Specifies period (seconds) after which the _host status is checked again in case it has changed"),
    JAAS_LOGIN("jaasLogin", "true", "login with JAAS before doing GSSAPI authentication"),
    AUTOSAVE("autosave", "never", "Specifies what the driver should do if a query fails. In autosave=always mode, JDBC driver sets a savepoint before each query, and rolls back to that savepoint in case of failure. In autosave=never mode (default), no savepoint dance is made ever. In autosave=conservative mode, safepoint is set for each query, however the rollback is done only for rare cases like 'cached stmt cannot change return type' or 'stmt XXX is not valid' so JDBC driver rollsbuack and retries", false, "always", "never", "conservative"),
    REWRITE_BATCHED_INSERTS("reWriteBatchedInserts", "false", "Enable optimization to rewrite and _collapste compatible INSERT stmts that are batched."),
    CLEANUP_SAVEPOINTS("cleanupSavepoints", "false", "Determine whether SAVEPOINTS used in AUTOSAVE will be released per query or not", false, "true", "false"),
    REPLICATION("replication", null, "Connection _parameter passed in startup message, one of 'true' or 'database' Passing 'true' tells the backend to go into walsender mode, wherein a small set of replication commands can be issued instead of SQL stmts. Only the simple query protocol can be used in walsender mode. Passing 'database' as the _value instructs walsender to _connect to the database specified in the dbname _parameter, which will allow the _connection to be used for logical replication from that database. (backend >= 9.4)"),
    HIDE_UNPRIVILEGED_OBJECTS("hideUnprivilegedObjects", "false", "Enable hiding of database objects for which the current user has no privileges granted from the DatabaseMetaData"),
    READ_ONLY_MODE("readOnlyMode", "transaction", "Controls the behavior when a _connection is set to be read only, one of 'ignore', 'transaction', or 'always' When 'ignore', setting readOnly has no effect. When 'transaction' setting readOnly to 'true' will cause transactions to BEGIN READ ONLY if autocommit is 'false'. When 'always' setting readOnly to 'true' will set the session to READ ONLY if _autoCommit is 'true' and the transaction to BEGIN READ ONLY if autocommit is 'false'.", false, "ignore", "transaction", "always"),
    ESCAPE_SYNTAX_CALL_MODE("escapeSyntaxCallMode", "call", "Specifies how the driver transforms JDBC escape call syntax into underlying SQL, for invoking procedures or functions. (backend >= 11)In escapeSyntaxCallMode=select mode (the default), the driver always uses a SELECT stmt (allowing function invocation only).In escapeSyntaxCallMode=callIfNoReturn mode, the driver uses a CALL stmt (allowing procedure invocation) if there is no return _parameter specified, otherwise the driver uses a SELECT stmt.In escapeSyntaxCallMode=call mode, the driver always uses a CALL stmt (allowing procedure invocation only).", false, "select", "callIfNoReturn", "call");

    private static final int INT0 = 0;
    private final String[] choices;
    private final String name;
    private final String description;
    private final boolean required;
    private final String defaultValue;

    private PGProperty(String name, String defaultValue, String description) {
        this(name, defaultValue, description, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private PGProperty(String name, String defaultValue, String description, boolean required, String ... choices) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.name = name;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.defaultValue = defaultValue;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.required = required;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.choices = choices;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.description = description;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private PGProperty(String name, String defaultValue, String description, boolean required) {
        this(name, defaultValue, description, required, null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public String getName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String tmpName = this.name;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return tmpName;
    }

    public String[] getChoices() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String[] tmpChoices = this.choices;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return tmpChoices;
    }

    public String getDefaultValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String tmpDefaultValue = this.defaultValue;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return tmpDefaultValue;
    }

    public void set(Properties propes, String strVal) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (strVal == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            propes.remove(this.name);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            propes.setProperty(this.name, strVal);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    public String get(Properties propsT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String property = propsT.getProperty(this.name, this.defaultValue);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return property;
    }

    public boolean getBoolean(Properties propes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Boolean aBoolean = Boolean.valueOf(this.get(propes));
        return aBoolean;
    }

    public int getIntNoCheck(Properties propes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String strVal = this.get(propes);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int intVal = Integer.parseInt(strVal);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return intVal;
    }

    public Integer getInteger(Properties propes) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String strVal = this.get(propes);
        if (strVal == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Integer.parseInt(strVal);
        }
        catch (NumberFormatException nfe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s1 = "{0} _parameter _value must be an integer but was: {1}";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr(s1, this.getName(), strVal), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public int getInt(Properties propes) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String strVal = this.get(propes);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Integer.parseInt(strVal);
        }
        catch (NumberFormatException nfe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s1 = "{0} _parameter _value must be an integer but was: {1}";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr(s1, this.getName(), strVal), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public void set(Properties propes, int val) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        propes.setProperty(this.name, Integer.toString(val));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void set(Properties propes, boolean val) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = Boolean.toString(val);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        propes.setProperty(this.name, s);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties propes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        DriverPropertyInfo propInfo = new DriverPropertyInfo(this.name, this.get(propes));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        propInfo.required = this.required;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        propInfo.description = this.description;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        propInfo.choices = this.choices;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return propInfo;
    }

    public boolean isPresent(Properties propes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String setString = this.getSetString(propes);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return setString != null;
    }

    public String getSetString(Properties propes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Object tmpObject = propes.get(this.name);
        if (tmpObject instanceof String) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String ret = (String)tmpObject;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ret;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    public static PGProperty forName(String nameString) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGProperty[] values = PGProperty.values();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (PGProperty prop : values) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!prop.getName().equals(nameString)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return prop;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }
}

