/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class PGpoint
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public double y;
    public double x;

    public PGpoint(String valueStr) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(valueStr);
    }

    public PGpoint(double x, double y) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.y = y;
        this.x = x;
    }

    public PGpoint() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("point");
    }

    @Override
    public void setValue(String value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PGtokenizer tokenizer = new PGtokenizer(PGtokenizer.removePara(value), ',');
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.y = Double.parseDouble(tokenizer.getToken(1));
            this.x = Double.parseDouble(tokenizer.getToken(0));
        }
        catch (NumberFormatException numberFormatException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, value), PSQLState.DATA_TYPE_MISMATCH, (Throwable)numberFormatException);
        }
    }

    @Override
    public void setByteValue(byte[] bytes, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.y = ByteConverter.float8(bytes, _offset + 8);
        this.x = ByteConverter.float8(bytes, _offset);
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof PGpoint) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            PGpoint point = (PGpoint)objt;
            return this.x == point.x && this.y == point.y;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long v1T = Double.doubleToLongBits(this.x);
        long v2T = Double.doubleToLongBits(this.y);
        return (int)(v1T ^ v2T ^ v1T >>> 32 ^ v2T >>> 32);
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String v = "(" + this.x + "," + this.y + ")";
        return v;
    }

    @Override
    public int lengthInBytes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 16;
        return v;
    }

    @Override
    public void toBytes(byte[] b, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteConverter.float8(b, _offset, this.x);
        ByteConverter.float8(b, _offset + 8, this.y);
    }

    public void translate(int x, int y) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.translate((double)x, (double)y);
    }

    public void translate(double x, double y) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.y += y;
        this.x += x;
    }

    public void move(int x, int y) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setLocation(x, y);
    }

    public void move(double x, double y) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.y = y;
        this.x = x;
    }

    public void setLocation(int x, int y) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.move((double)x, (double)y);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return super.clone();
    }

    public void setLocation(Point point) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setLocation(point.x, point.y);
    }
}

