/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.Connection;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.PgArray;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.TraceLogger;

abstract class PrimitiveArraySupport<A> {
    private static final int ZERO = 0;
    private static final PrimitiveArraySupport<long[]> LONG_ARRAY_T = new PrimitiveArraySupport<long[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            return 1016;
        }

        @Override
        public String toArrayString(char delimiter, long[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(64, array.length * 8));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, long[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(array[i]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(Connection _connection, long[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int length = 20 + 12 * array.length;
            byte[] _bytes = new byte[length];
            ByteConverter.int4(_bytes, 0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 4, 0);
            ByteConverter.int4(_bytes, 8, 20);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 12, array.length);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int index = 20;
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _bytes[index + 3] = 8;
                ByteConverter.int8(_bytes, index + 4, array[i]);
                index += 12;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes;
        }
    };
    private static final PrimitiveArraySupport<short[]> SHORT_ARRAY = new PrimitiveArraySupport<short[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1005;
        }

        @Override
        public String toArrayString(char delimiter, short[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(32, array.length * 4));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, short[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(array[i]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(Connection _connection, short[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int length = 20 + 6 * array.length;
            byte[] _bytes = new byte[length];
            ByteConverter.int4(_bytes, 0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 4, 0);
            ByteConverter.int4(_bytes, 8, 21);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 12, array.length);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int index = 20;
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _bytes[index + 3] = 2;
                ByteConverter.int2(_bytes, index + 4, array[i]);
                index += 6;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes;
        }
    };
    private static final PrimitiveArraySupport<int[]> INT_ARRAY = new PrimitiveArraySupport<int[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1007;
        }

        @Override
        public String toArrayString(char delimiter, int[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(32, array.length * 6));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, int[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(array[i]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(Connection _connection, int[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int length = 20 + 8 * array.length;
            byte[] _bytes = new byte[length];
            ByteConverter.int4(_bytes, 0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 4, 0);
            ByteConverter.int4(_bytes, 8, 23);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 12, array.length);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int index = 20;
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _bytes[index + 3] = 4;
                ByteConverter.int4(_bytes, index + 4, array[i]);
                index += 8;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes;
        }
    };
    private static final PrimitiveArraySupport<float[]> FLOAT_ARRAY = new PrimitiveArraySupport<float[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1021;
        }

        @Override
        public String toArrayString(char delimiter, float[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(64, array.length * 8));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, float[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append('\"');
                sbu.append(array[i]);
                sbu.append('\"');
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(Connection _connection, float[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int length = 20 + 8 * array.length;
            byte[] _bytes = new byte[length];
            ByteConverter.int4(_bytes, 0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 4, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 8, 700);
            ByteConverter.int4(_bytes, 12, array.length);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int index = 20;
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _bytes[index + 3] = 4;
                ByteConverter.float4(_bytes, index + 4, array[i]);
                index += 8;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes;
        }
    };
    private static final PrimitiveArraySupport<double[]> DOUBLE_ARRAY = new PrimitiveArraySupport<double[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1022;
        }

        @Override
        public String toArrayString(char delimiter, double[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(64, array.length * 8));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, double[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                sbu.append('\"');
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(array[i]);
                sbu.append('\"');
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(Connection _connection, double[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int length = 20 + 12 * array.length;
            byte[] _bytes = new byte[length];
            ByteConverter.int4(_bytes, 0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 4, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 8, 701);
            ByteConverter.int4(_bytes, 12, array.length);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int index = 20;
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _bytes[index + 3] = 8;
                ByteConverter.float8(_bytes, index + 4, array[i]);
                index += 12;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes;
        }
    };
    private static final PrimitiveArraySupport<String[]> STRING_ARRAY = new PrimitiveArraySupport<String[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1015;
        }

        @Override
        public String toArrayString(char delimiter, String[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(64, array.length * 8));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, String[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                if (array[i] == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append('N');
                    sbu.append('U');
                    sbu.append('L');
                    sbu.append('L');
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                PgArray.escapeArrayElement(sbu, array[i]);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public boolean supportBinaryRepresentation() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }

        @Override
        public byte[] toBinaryRepresentation(Connection conn, String[] arrayT) throws SQLFeatureNotSupportedException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLFeatureNotSupportedException();
        }
    };
    private static final PrimitiveArraySupport<boolean[]> BOOLEAN_ARRAY = new PrimitiveArraySupport<boolean[]>(){

        @Override
        public int getDefaultArrayTypeOid(TypeInfo typeCache) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 1000;
        }

        @Override
        public String toArrayString(char delimiter, boolean[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder sbu = new StringBuilder(Math.max(64, array.length * 8));
            this.appendArray(sbu, delimiter, array);
            return sbu.toString();
        }

        @Override
        public void appendArray(StringBuilder sbu, char delimiter, boolean[] array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('{');
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append(delimiter);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(array[i] ? (char)'1' : '0');
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('}');
        }

        @Override
        public byte[] toBinaryRepresentation(Connection _connection, boolean[] array) throws SQLFeatureNotSupportedException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int length = 20 + 5 * array.length;
            byte[] _bytes = new byte[length];
            ByteConverter.int4(_bytes, 0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 4, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(_bytes, 8, 16);
            ByteConverter.int4(_bytes, 12, array.length);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int index = 20;
            for (int i = 0; i < array.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _bytes[index + 3] = 1;
                ByteConverter.bool(_bytes, index + 4, array[i]);
                index += 5;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes;
        }
    };
    private static final Map<Class, PrimitiveArraySupport> ARRAY_CLASS_TO_SUPPORT_T = new HashMap<Class, PrimitiveArraySupport>(10);

    PrimitiveArraySupport() {
    }

    public static <A> PrimitiveArraySupport<A> getArraySupport(A array) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ARRAY_CLASS_TO_SUPPORT_T.get(array.getClass());
    }

    public abstract String toArrayString(char var1, A var2);

    public abstract int getDefaultArrayTypeOid(TypeInfo var1);

    public static boolean isSupportedPrimitiveArray(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return objt != null && ARRAY_CLASS_TO_SUPPORT_T.containsKey(objt.getClass());
    }

    public abstract byte[] toBinaryRepresentation(Connection var1, A var2) throws SQLFeatureNotSupportedException;

    public abstract void appendArray(StringBuilder var1, char var2, A var3);

    public boolean supportBinaryRepresentation() {
        return true;
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ARRAY_CLASS_TO_SUPPORT_T.put(long[].class, LONG_ARRAY_T);
        ARRAY_CLASS_TO_SUPPORT_T.put(short[].class, SHORT_ARRAY);
        ARRAY_CLASS_TO_SUPPORT_T.put(int[].class, INT_ARRAY);
        ARRAY_CLASS_TO_SUPPORT_T.put(double[].class, DOUBLE_ARRAY);
        ARRAY_CLASS_TO_SUPPORT_T.put(float[].class, FLOAT_ARRAY);
        ARRAY_CLASS_TO_SUPPORT_T.put(String[].class, STRING_ARRAY);
        ARRAY_CLASS_TO_SUPPORT_T.put(boolean[].class, BOOLEAN_ARRAY);
    }
}

