/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.logging.Level;
import org.postgresql.core.Field;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.util.TraceLogger;

public class ResultHandlerDelegate
implements ResultHandler {
    private final ResultHandler _delegate;

    public ResultHandlerDelegate(ResultHandler _delegate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._delegate = _delegate;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            this._delegate.handleResultRows(fromQuery, _fields, _tuples, cursor);
        }
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, boolean isLast) {
        if (this._delegate != null) {
            this._delegate.handleResultRows(fromQuery, fields, tuples, cursor, isLast);
        }
    }

    @Override
    public void handleCommandStatus(String status, long updateNum, long insertOID) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            this._delegate.handleCommandStatus(status, updateNum, insertOID);
        }
    }

    @Override
    public void handleWarning(SQLWarning _warning) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            this._delegate.handleWarning(_warning);
        }
    }

    @Override
    public void handleError(SQLException _error) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            this._delegate.handleError(_error);
        }
    }

    @Override
    public void handleCompletion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            this._delegate.handleCompletion();
        }
    }

    @Override
    public void secureProgress() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            this._delegate.secureProgress();
        }
    }

    @Override
    public SQLException getException() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            return this._delegate.getException();
        }
        return null;
    }

    @Override
    public SQLWarning getWarning() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._delegate != null) {
            return this._delegate.getWarning();
        }
        return null;
    }
}

