/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.dispatcher.entity;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.PGProperty;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ReplicationProtocol;
import org.postgresql.core.TransactionState;
import org.postgresql.core.TypeInfo;
import org.postgresql.core.Version;
import org.postgresql.dispatcher.core.ConnectionMangerV2;
import org.postgresql.dispatcher.entity.FakeConnection;
import org.postgresql.dispatcher.executor.DispatchCallableStatementV2;
import org.postgresql.dispatcher.executor.DispatchPreparedStatementV2;
import org.postgresql.dispatcher.executor.DispatchStatementV2;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.jdbc.AutoSave;
import org.postgresql.jdbc.FieldMetadata;
import org.postgresql.jdbc.PSQLSavepoint;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.replication.PGReplicationConnection;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.LruCache;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class DispatchConnection
implements BaseConnection {
    private PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private int transStatus;
    public ConnectionMangerV2 pCMV2;
    public int stable_slave_key;
    private Connection mainConn;
    boolean bmaster_check = false;
    public int retrytimes = 0;
    public int retryinterval = 0;
    SQLException master_error = null;
    private String lastSqlType;
    public String passward;
    public String dbName;
    public Properties m_pros = new Properties();
    public String url;
    private Map<String, Connection> slaveConnMap = new HashMap<String, Connection>();
    private Map<String, Map<String, String>> slaveConnInfo = new HashMap<String, Map<String, String>>();
    public static String SLAVE = "slave";
    public int slaveCount;
    public List<String> whiteList = null;
    public List<String> blackList = null;
    public List<String> masterFunctionList = null;
    public List<String> allSendFunctionList = null;
    public List<String> tempTables = null;
    public String masterKeyword = null;
    protected volatile boolean _autoCommit = true;
    protected volatile boolean hasUpdate = false;
    private int resultSetHoldability = 2;
    private boolean readOnly = false;
    private AutoSave autoSave;
    private int fetchSize;
    private int level = 0;
    protected Map<String, Class<?>> typemap;
    private Properties _clientInfo;
    private boolean flushCacheOnDeallocate = true;
    private int threshold = 5;
    private String schema;
    private Executor exec;
    private int networkTimeout;
    private boolean hasSetNetworkTimeout;
    public AtomicInteger lastSlaveID = new AtomicInteger(0);

    public String getLastSqlType() {
        return this.lastSqlType;
    }

    public void setLastSqlType(String lastSqlType) {
        this.lastSqlType = lastSqlType;
    }

    public Connection getMainConn() throws SQLException {
        if (this.mainConn != null && !this.mainConn.isClosed()) {
            return this.mainConn;
        }
        String _hostip = Driver._hostSpecs(this.m_pros)[0].getHost();
        int _hostport = Driver._hostSpecs(this.m_pros)[0].getPort();
        String node = this.pCMV2.nodeMap.get(_hostip + ":" + _hostport);
        if (this.m_pros.getProperty("isMonitor") == null && !this.pCMV2.master_online_ip.equals(node) && !this.pCMV2.slave_online_ip.contains(node + ",")) {
            String debugmsg = String.format("Create Fake Master _connection for : {%s} ", node);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
            }
            this.mainConn = new FakeConnection("master_key", _hostip, _hostport);
            return this.mainConn;
        }
        boolean b_connect = true;
        PgConnection _con = null;
        try {
            _con = new PgConnection(Driver._hostSpecs(this.m_pros), Driver.user(this.m_pros), Driver.database(this.m_pros), this.m_pros, this.url, this.pCMV2._connVersion.get(node), this.pCMV2);
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Master _connection for : {%s} Exception: {%s}", node, e.getMessage());
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                LOGGER.log(Level.SEVERE, e);
            }
            if (!this.bmaster_check) {
                throw new SQLException(e);
            }
            this.master_error = new SQLException(e);
            b_connect = false;
        }
        if (!b_connect) {
            this.mainConn = new FakeConnection("master_key", _hostip, _hostport);
            return this.mainConn;
        }
        _con.setDispatchConn(this);
        _con.setIsSlave(false);
        this.mainConn = _con;
        return this.mainConn;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setHasUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public DispatchConnection(PgConnection main_Conn, String pass_ward, String db_Name, Properties prop_s, ConnectionMangerV2 cCMV2) throws SQLException {
        this.pCMV2 = cCMV2;
        this.mainConn = main_Conn;
        this.passward = pass_ward;
        this.dbName = db_Name;
        this.m_pros = prop_s;
        this.bmaster_check = PGProperty.MASTER_CHECK.getBoolean(prop_s);
        this.lastSlaveID.set(this.pCMV2.lastSlaveID.getAndIncrement());
        this.retrytimes = PGProperty.RETRYTIMES.getIntNoCheck(prop_s);
        this.retryinterval = PGProperty.RETRYINTERVAL.getIntNoCheck(prop_s);
        this.whiteList = this.initFunctionList(PGProperty.WHITELIST.get(prop_s));
        this.blackList = this.initFunctionList(PGProperty.BLACKLIST.get(prop_s));
        this.masterFunctionList = this.initFunctionList(PGProperty.MASTERFUNCTIONLIST.get(prop_s));
        this.tempTables = this.initFunctionList(PGProperty.TEMPTABLE.get(prop_s));
        this.masterKeyword = PGProperty.MASTER_KEYWORD.get(prop_s);
        this.allSendFunctionList = this.initFunctionList(PGProperty.ALL_SEND_FUNCTION_LIST.get(prop_s));
        this.initSlavesInfo(this.m_pros);
        if (PGProperty.STABLE_SLAVE.getBoolean(this.m_pros) || PGProperty.LOADBALANCE_STRATEGY.getInt(this.m_pros) == 2) {
            this.stable_slave_key = this.slaveCount > 0 ? Math.abs(this.lastSlaveID.getAndIncrement() % this.slaveCount) : -1;
        }
        this.url = this.getUrl();
        this.getMasterConnection();
        this.getAllSlaveConn();
        if (this.bmaster_check) {
            this.CheckClusteInfo(prop_s);
        }
        this.replicationConnection = PGProperty.REPLICATION.get(this.m_pros) != null;
    }

    public List<String> initFunctionList(String function) {
        if (function != null) {
            String[] funs;
            ArrayList<String> functions = new ArrayList<String>();
            for (String fun : funs = function.split(";")) {
                int start = 0;
                int _index = fun.indexOf("\"", start);
                String str = "";
                boolean _flag = false;
                while (_index != -1) {
                    str = !_flag ? str + fun.substring(start, _index).toLowerCase() : str + fun.substring(start, _index);
                    _flag = !_flag;
                    start = _index + 1;
                    _index = fun.indexOf("\"", start);
                }
                str = str + fun.substring(start, fun.length()).toLowerCase();
                functions.add(str);
            }
            return functions;
        }
        return null;
    }

    public void initSlavesInfo(Properties pros) throws PSQLException {
        String[] slavePorts;
        HashMap<String, HashMap<String, String>> nodeToSlaveIPMap = new HashMap<String, HashMap<String, String>>();
        String nodeList = PGProperty.NODE_LIST.get(pros);
        if (nodeList == null || nodeList.isEmpty()) {
            throw new PSQLException("The nodeList cannot be empty.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        String[] nodes = nodeList.split(",");
        String[] _hosts = PGProperty.PG_HOST.get(pros).split(",");
        String[] _hostPorts = PGProperty.PG_PORT.get(pros).split(",");
        String slaveList = PGProperty.SLAVE_ADD.get(pros);
        String slavePortList = PGProperty.SLAVE_PORT.get(pros);
        String[] slaves = slaveList == null || slaveList.isEmpty() ? new String[]{} : slaveList.split(",");
        String[] stringArray = slavePorts = slavePortList == null || slavePortList.isEmpty() ? new String[]{} : slavePortList.split(",");
        if (slaves.length != slavePorts.length) {
            throw new PSQLException("The number of standby machines does not match the number of ports.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (slaves.length + _hosts.length != nodes.length) {
            throw new PSQLException("The number of _hosts does not match the number of nodes.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i = _hosts.length; i < nodes.length; ++i) {
            HashMap<String, String> info = (HashMap<String, String>)nodeToSlaveIPMap.get(nodes[i]);
            if (info == null) {
                info = new HashMap<String, String>();
                info.put("ADDRESS", slaves[i - _hosts.length]);
                info.put("PGPORT", slavePorts[i - _hosts.length]);
            } else {
                info.put("ADDRESS", (String)info.get("ADDRESS") + "," + slaves[i - _hosts.length]);
                info.put("PGPORT", (String)info.get("PGPORT") + "," + slavePorts[i - _hosts.length]);
            }
            nodeToSlaveIPMap.put(nodes[i], info);
        }
        this.slaveConnInfo.clear();
        int _index = 0;
        for (String _key : nodeToSlaveIPMap.keySet()) {
            String slaveName = "slave" + _index;
            this.slaveConnInfo.put(slaveName, (Map<String, String>)nodeToSlaveIPMap.get(_key));
            ++_index;
        }
        this.slaveCount = _index;
    }

    public Connection createSlaveConnection(String _key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(_key);
        String url = "jdbc:postgresql://" + infoMap.get("ADDRESS") + ":" + infoMap.get("PGPORT") + "/" + this.dbName;
        LOGGER.log(Level.SEVERE, "createSlaveConnection _key " + _key + " " + url, new Object[0]);
        String _host = infoMap.get("ADDRESS").split(",")[0] + ":" + infoMap.get("PGPORT").split(",")[0];
        String node = this.pCMV2.nodeMap.get(_host);
        if (this.m_pros.getProperty("isMonitor") == null && !this.pCMV2.slave_online_ip.contains(node + ",") && !this.pCMV2.master_online_ip.equals(node)) {
            String debugmsg = String.format("Create Fake Slave _connection for : {_key:%s %s} ", _key, node);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
            }
            Connection tagConn = this.setSlaveToFakebyKey(_key);
            return tagConn;
        }
        try {
            PgConnection _conn = null;
            Properties slave_pros = new Properties(this.m_pros);
            slave_pros.setProperty("PGHOST", infoMap.get("ADDRESS"));
            slave_pros.setProperty("PGPORT", infoMap.get("PGPORT"));
            _conn = new PgConnection(Driver._hostSpecs(slave_pros), Driver.user(slave_pros), Driver.database(slave_pros), slave_pros, url, this.pCMV2._connVersion.get(node), this.pCMV2);
            _conn.setDispatchConn(this);
            _conn.setMasterConnection(this.mainConn);
            _conn.setIsSlave(true);
            this.slaveConnMap.put(_key, _conn);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "create SlaveConnection success (session={0} url={1})", this, url);
            }
            return _conn;
        }
        catch (SQLException e) {
            String debugmsg = String.format("Create Slave _connection for : {_key:%s %s} Exception: {%s}", _key, node, e.getMessage());
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                LOGGER.log(Level.SEVERE, e);
            }
            Connection tagConn = this.setSlaveToFakebyKey(_key);
            return tagConn;
        }
    }

    public Connection setSlaveToFakebyKey(String _key) throws SQLException {
        Map<String, String> infoMap = this.slaveConnInfo.get(_key);
        String debugmsg = String.format("set Slave _connection to Fake state for : {_key:%s %s} ", _key, infoMap.get("ADDRESS") + ":" + infoMap.get("PGPORT"));
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
        }
        FakeConnection tagConn = new FakeConnection(_key, infoMap.get("ADDRESS").split(",")[0], Integer.valueOf(infoMap.get("PGPORT").split(",")[0]));
        this.slaveConnMap.put(_key, tagConn);
        return tagConn;
    }

    public Connection getSlaveConnection(String _key) throws SQLException {
        LOGGER.log(Level.INFO, "getSlaveConnection _key:" + _key, new Object[0]);
        if (_key == null) {
            return this.mainConn;
        }
        Connection _conn = null;
        if (!this.slaveConnMap.containsKey(_key)) {
            _conn = this.createSlaveConnection(_key);
        } else {
            _conn = this.slaveConnMap.get(_key);
            if (_conn == null || _conn.isClosed() && !(_conn instanceof FakeConnection) || _conn instanceof FakeConnection && ((FakeConnection)_conn).getSlaveStatus()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    String debugmsg;
                    if (_conn instanceof FakeConnection) {
                        String node = this.pCMV2.nodeMap.get(((FakeConnection)_conn).getSlaveIP() + ":" + ((FakeConnection)_conn).getSlavePort());
                        debugmsg = String.format("getSlaveConnection recreate fake slave _connection for : {%s}", node);
                    } else {
                        debugmsg = _conn != null ? String.format("getSlaveConnection recreate PgConnection slave _connection for : {%s}", ((PgConnection)_conn).getURL()) : String.format("getSlaveConnection recreate null slave _connection", new Object[0]);
                    }
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                _conn = this.createSlaveConnection(_key);
                this.resetConnInfo(_conn);
            }
        }
        return _conn;
    }

    public List<Connection> getAllSlaveConn() throws SQLException {
        LOGGER.log(Level.INFO, "getAllSlaveConn slaveCount:" + this.slaveCount + "\n", new Object[0]);
        ArrayList<Connection> _conns = new ArrayList<Connection>();
        for (int i = 0; i < this.slaveCount; ++i) {
            String _key = SLAVE + i;
            _conns.add(this.getSlaveConnection(_key));
        }
        return _conns;
    }

    protected String getUrl() {
        String url = "jdbc:postgresql://" + PGProperty.PG_HOST.get(this.m_pros) + ":" + PGProperty.PG_PORT.get(this.m_pros) + "/" + this.dbName + "?_hostLoadRate=" + PGProperty.HOSTLOADRATE.get(this.m_pros);
        return url;
    }

    @Override
    public void close() throws SQLException {
        block5: {
            try {
                LOGGER.log(Level.INFO, "dispatch close()", new Object[0]);
                this.mainConn.close();
            }
            catch (SQLException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void checkslavestatus() throws SQLException {
        for (int i = 0; i < this.slaveCount; ++i) {
            String _key = SLAVE + i;
            Connection _con = this.getSlaveConnection(_key);
            if (_con instanceof FakeConnection) {
                String node = this.pCMV2.nodeMap.get(((FakeConnection)_con).getSlaveIP() + ":" + ((FakeConnection)_con).getSlavePort());
                if (!this.pCMV2.slave_online_ip.contains(node + ",") && !this.pCMV2.master_online_ip.equals(node)) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    String debugmsg = String.format("checkslavestatus recreate slave _connection for : {%s}", ((FakeConnection)_con).getSlaveIP());
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                ((FakeConnection)_con).setSlaveStatus(true);
                continue;
            }
            try {
                if (_con.isValid(5)) continue;
                _con.close();
                LOGGER.log(Level.INFO, "checkslavestatus: find _connect on " + ((PgConnection)_con).getHostIp() + " is invalid  need re_connect\n", new Object[0]);
                FakeConnection tagConn = new FakeConnection(_key, ((PgConnection)_con).getHostIp(), ((PgConnection)_con).getHostPort());
                this.slaveConnMap.put(_key, tagConn);
                tagConn.setSlaveStatus(false);
                continue;
            }
            catch (SQLException e) {
                LOGGER.log(Level.INFO, "checkslavestatus Exception: " + e.getMessage() + " find _connect on " + ((PgConnection)_con).getHostIp() + " is invalid  need re_connect\n", new Object[0]);
                FakeConnection tagConn = new FakeConnection(_key, ((PgConnection)_con).getHostIp(), ((PgConnection)_con).getHostPort());
                this.slaveConnMap.put(_key, tagConn);
                tagConn.setSlaveStatus(false);
            }
        }
    }

    public boolean checkslaveisup(String slaveip) throws SQLException {
        boolean bres = false;
        Connection _conn = this.mainConn;
        String _sql = String.format("select CLIENT_ADDR from pg_stat_replication where CLIENT_ADDR = '%s' ", slaveip);
        try {
            if (_conn == null || _conn instanceof FakeConnection) {
                return false;
            }
            if (_conn.isClosed()) {
                return false;
            }
            Statement stcheck = _conn.createStatement();
            ResultSet resultSet = stcheck.executeQuery(_sql);
            bres = resultSet.next();
            LOGGER.log(Level.INFO, "checkslaveisup: " + _sql + " slaveip: " + slaveip + " status: " + bres, new Object[0]);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        return bres;
    }

    public void CloseConnectCluter() throws SQLException {
        try {
            LOGGER.log(Level.INFO, "recreate cluster _connection", new Object[0]);
            this.mainConn.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "mainConn close Exception (Exception={0})", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        Iterator<Connection> it = this.slaveConnMap.values().iterator();
        while (it.hasNext()) {
            try {
                Connection _con = it.next();
                _con.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "slaveConnMap close Exception (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
    }

    public void ReConnectCluter() throws SQLException {
        this.getMasterConnection();
        this.checkslavestatus();
        this.getAllSlaveConn();
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public void clearWarnings() throws SQLException {
        ((PgConnection)this.mainConn).clearWarnings();
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.clearWarnings();
        }
    }

    @Override
    public void commit() throws SQLException {
        LOGGER.log(Level.INFO, " commit", new Object[0]);
        this.mainConn.commit();
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.commit();
        }
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.mainConn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.mainConn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.mainConn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.mainConn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.mainConn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.mainConn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.mainConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.mainConn.isReadOnly();
    }

    @Override
    public String nativeSQL(String _sql) throws SQLException {
        return this.mainConn.nativeSQL(_sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DispatchStatementV2(this);
    }

    @Override
    public Statement createStatement(int _resultSetType, int _resultSetConcurrency) throws SQLException {
        return new DispatchStatementV2(this, _resultSetType, _resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        return new DispatchStatementV2(this, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String _sql) throws SQLException {
        return new DispatchCallableStatementV2(this, _sql);
    }

    @Override
    public CallableStatement prepareCall(String _sql, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        return new DispatchCallableStatementV2(this, _sql, _resultSetType, _resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        return new DispatchCallableStatementV2(this, _sql, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql) throws SQLException {
        return new DispatchPreparedStatementV2(this, _sql);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int autoGeneratedKeys) throws SQLException {
        return new DispatchPreparedStatementV2(this, _sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int[] _columnIndexes) throws SQLException {
        return new DispatchPreparedStatementV2(this, _sql, _columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, String[] _columnNames) throws SQLException {
        return new DispatchPreparedStatementV2(this, _sql, _columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        return new DispatchPreparedStatementV2(this, _sql, _resultSetType, _resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String _sql, int _resultSetType, int _resultSetConcurrency, int _resultSetHoldability) throws SQLException {
        return new DispatchPreparedStatementV2(this, _sql, _resultSetType, _resultSetConcurrency, _resultSetHoldability);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.mainConn.releaseSavepoint(((PSQLSavepoint)savepoint).clone());
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.releaseSavepoint(((PSQLSavepoint)savepoint).clone());
        }
        ((PSQLSavepoint)savepoint).invalidate();
    }

    @Override
    public void rollback() throws SQLException {
        LOGGER.log(Level.INFO, " rollback", new Object[0]);
        this.mainConn.rollback();
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.rollback();
        }
        this.setHasUpdate(false);
        this.setLastSqlType(null);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        LOGGER.log(Level.INFO, "  rollback {0}", savepoint);
        this.mainConn.rollback(savepoint);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean _autoCommit) throws SQLException {
        LOGGER.log(Level.INFO, "  setAutoCommit = {0}", _autoCommit);
        this.mainConn.setAutoCommit(_autoCommit);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.setAutoCommit(_autoCommit);
        }
        if (this._autoCommit != _autoCommit) {
            this._autoCommit = _autoCommit;
            this.setHasUpdate(false);
            this.setLastSqlType(null);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.mainConn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.resultSetHoldability = holdability;
        this.mainConn.setHoldability(holdability);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.setHoldability(holdability);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.mainConn.setReadOnly(readOnly);
        List<Connection> _conns = this.getAllSlaveConn();
        for (int i = 0; i < _conns.size(); ++i) {
            if (_conns.get(i) instanceof FakeConnection) continue;
            try {
                _conns.get(i).setReadOnly(readOnly);
                continue;
            }
            catch (SQLException e) {
                this.mainConn.setReadOnly(!readOnly);
                while (--i >= 0) {
                    _conns.get(i).setReadOnly(!readOnly);
                }
                throw e;
            }
        }
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.setSavepoint();
        }
        return this.mainConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.setSavepoint(name);
        }
        return this.mainConn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.level = level;
        this.mainConn.setTransactionIsolation(level);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.setTransactionIsolation(level);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
        this.mainConn.setTypeMap(map);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            _connection.setTypeMap(map);
        }
    }

    public void addWarning(SQLWarning warn) {
        ((PgConnection)this.mainConn).addWarning(warn);
    }

    @Override
    public void cancelQuery() throws SQLException {
        ((PgConnection)this.mainConn).cancelQuery();
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return ((PgConnection)this.mainConn).execSQLQuery(s);
    }

    @Override
    public ResultSet execSQLQuery(String s, int _resultSetType, int _resultSetConcurrency) throws SQLException {
        return ((PgConnection)this.mainConn).execSQLQuery(s, _resultSetType, _resultSetConcurrency);
    }

    public String getCursorName() throws SQLException {
        return ((PgConnection)this.mainConn).getCursorName();
    }

    @Override
    public Encoding getEncoding() {
        return ((PgConnection)this.mainConn).getEncoding();
    }

    public void setCursorName(String cursor) throws SQLException {
        ((PgConnection)this.mainConn).setCursorName(cursor);
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        return ((PgConnection)this.mainConn).getFastpathAPI();
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return ((PgConnection)this.mainConn).getQueryExecutor();
    }

    @Override
    public boolean isValid(int _timeout) throws SQLException {
        if (_timeout < 0) {
            throw new PSQLException(GT.tr("Invalid _timeout ({0}<0).", _timeout), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            if (this.replicationConnection) {
                Statement stmt = this.createStatement();
                stmt.execute("IDENTIFY_SYSTEM");
                stmt.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.setQueryTimeout(_timeout);
                this.checkConnectionQuery.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            if (PSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                return true;
            }
            LOGGER.log(Level.WARNING, GT.tr("Validating _connection.", new Object[0]), e);
            return false;
        }
    }

    @Override
    public void setMasterConnection(Connection _conn) {
        this.mainConn = (PgConnection)_conn;
        ((PgConnection)this.mainConn).setDispatchConn(this);
        ((PgConnection)this.mainConn).setIsSlave(false);
    }

    public boolean CheckIsMaster(Connection _conn) {
        boolean bres = false;
        try {
            if (_conn == null || _conn instanceof FakeConnection) {
                return bres;
            }
            LOGGER.log(Level.INFO, "CheckIsMaster" + ((PgConnection)_conn).getURL() + "\n", new Object[0]);
            if (_conn.isClosed()) {
                return bres;
            }
            Statement stcheck = _conn.createStatement();
            ResultSet resultSet = stcheck.executeQuery("select * from pg_is_in_recovery()");
            if (resultSet.next()) {
                bres = !resultSet.getBoolean(1);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "CheckIsMaster Exception: {0}", e.getMessage());
            LOGGER.log(Level.SEVERE, e);
        }
        return bres;
    }

    public Properties UpdateSlaveinfoFromMaster(Properties pros) throws SQLException {
        Statement stcheck = this.mainConn.createStatement();
        ResultSet resultSet = stcheck.executeQuery("select CLIENT_ADDR from sys_stat_replication ");
        StringBuffer slave_ip = new StringBuffer("");
        while (resultSet.next()) {
            if (slave_ip.length() == 0) {
                slave_ip.append(resultSet.getString("CLIENT_ADDR"));
                continue;
            }
            slave_ip.append(",");
            slave_ip.append(resultSet.getString("CLIENT_ADDR"));
        }
        PGProperty.SLAVE_ADD.set(pros, slave_ip.toString());
        stcheck.close();
        Properties pros_new = new Properties(pros);
        return pros_new;
    }

    public boolean CheckClusteInfo(Properties prop_s) throws SQLException {
        Connection old_main_conn;
        boolean bMasterChange = false;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "CheckClusteInfo prop_s  _host: " + PGProperty.PG_HOST.get(prop_s) + ":" + PGProperty.PG_PORT.get(prop_s) + " slaveadd: " + PGProperty.SLAVE_ADD.get(prop_s) + ":" + PGProperty.SLAVE_PORT.get(prop_s) + "\n", new Object[0]);
        }
        if ((old_main_conn = this.mainConn) == null) {
            // empty if block
        }
        if (this.CheckIsMaster(this.mainConn)) {
            return bMasterChange;
        }
        bMasterChange = true;
        if (bMasterChange) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "CheckClusteInfo slaveConnMap size()" + this.slaveConnMap.size() + " " + this.slaveConnMap.toString() + "\n", new Object[0]);
            }
            for (Map.Entry<String, Connection> entry : this.slaveConnMap.entrySet()) {
                String _key = entry.getKey();
                Connection slave_con = entry.getValue();
                if (!this.CheckIsMaster(slave_con)) continue;
                this.setMasterConnection(slave_con);
                if (!(old_main_conn instanceof FakeConnection)) {
                    ((PgConnection)old_main_conn).setIsSlave(true);
                }
                this.slaveConnMap.put(_key, old_main_conn);
                bMasterChange = true;
                String old_masterip = PGProperty.PG_HOST.get(prop_s);
                String old_masterport = PGProperty.PG_PORT.get(prop_s);
                String old_slaveip = PGProperty.SLAVE_ADD.get(prop_s);
                String old_slaveport = PGProperty.SLAVE_PORT.get(prop_s);
                String new_masterip = ((PgConnection)slave_con).getHostIpst();
                PGProperty.PG_HOST.set(prop_s, new_masterip);
                String new_masterport = ((PgConnection)slave_con).getHostPorts();
                PGProperty.PG_PORT.set(prop_s, new_masterport);
                ArrayList<String> old_slaveips = new ArrayList<String>(Arrays.asList(old_slaveip.split(",")));
                ArrayList<String> old_slaveports = new ArrayList<String>(Arrays.asList(old_slaveport.split(",")));
                ArrayList<String> new_masterips = new ArrayList<String>(Arrays.asList(new_masterip.split(",")));
                ArrayList<String> new_masterports = new ArrayList<String>(Arrays.asList(new_masterport.split(",")));
                block1: for (int i = 0; i < new_masterips.size(); ++i) {
                    for (int j = 0; j < old_slaveips.size(); ++j) {
                        if (!((String)new_masterips.get(i)).equals(old_slaveips.get(j)) || !((String)new_masterports.get(i)).equals(old_slaveports.get(j))) continue;
                        old_slaveips.remove(j);
                        old_slaveports.remove(j);
                        continue block1;
                    }
                }
                String new_slaveip = old_masterip + (old_masterip.endsWith(",") ? "" : ",") + ((Object)old_slaveips).toString().substring(1, ((Object)old_slaveips).toString().length() - 1).replace(" ", "");
                String new_slaveport = old_masterport + (old_masterport.endsWith(",") ? "" : ",") + ((Object)old_slaveports).toString().substring(1, ((Object)old_slaveports).toString().length() - 1).replace(" ", "");
                PGProperty.SLAVE_ADD.set(prop_s, new_slaveip);
                PGProperty.SLAVE_PORT.set(prop_s, new_slaveport);
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("ADDRESS", old_masterip);
                info.put("PGPORT", old_masterport);
                this.slaveConnInfo.put(_key, info);
                this.m_pros = prop_s;
                if (!LOGGER.isLoggable(Level.INFO)) break;
                String debugmsg = String.format("CheckClusteInfo::Cluster Change Master DB from " + old_masterip + ":" + old_masterport + " to " + new_masterip + ":" + new_masterport, new Object[0]);
                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                break;
            }
        }
        if (!this.CheckIsMaster(this.mainConn)) {
            this.close();
            throw new PSQLException("JDBC can't find a vaild master database in cluster " + this.pCMV2.clusterKey, PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return bMasterChange;
    }

    @Override
    public Connection getMasterConnection() throws SQLException {
        return this.getMainConn();
    }

    public Properties getConnectionProperties() {
        return this.m_pros;
    }

    public void setConnectionProperties(Properties pros) {
        this.m_pros = pros;
    }

    public void setTransStatus(int transStatus) {
        this.transStatus = transStatus;
    }

    public int getTransStatus() {
        return this.transStatus;
    }

    public boolean isCompatibleOldDateFormat() {
        return false;
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
    }

    @Override
    public boolean isZeroResend() {
        return false;
    }

    public boolean isUseSlaveSynRead() {
        return false;
    }

    public boolean checkDBLinkSql() {
        return false;
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        return ((PgConnection)this.mainConn).getNotifications();
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        return ((PgConnection)this.mainConn).getCopyAPI();
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        return ((PgConnection)this.mainConn).getLargeObjectAPI();
    }

    @Override
    public void addDataType(String type, String className) {
        ((PgConnection)this.mainConn).addDataType(type, className);
    }

    @Override
    public void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        ((PgConnection)this.mainConn).addDataType(type, klass);
    }

    @Override
    public void setPrepareThreshold(int threshold) {
        this.threshold = threshold;
        ((PgConnection)this.mainConn).setPrepareThreshold(threshold);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((PgConnection)_connection).setPrepareThreshold(threshold);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getPrepareThreshold() {
        return ((PgConnection)this.mainConn).getPrepareThreshold();
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
        ((PgConnection)this.mainConn).setDefaultFetchSize(fetchSize);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            ((PgConnection)_connection).setDefaultFetchSize(fetchSize);
        }
    }

    @Override
    public int getDefaultFetchSize() {
        return ((PgConnection)this.mainConn).getDefaultFetchSize();
    }

    @Override
    public int getBackendPID() {
        return ((PgConnection)this.mainConn).getBackendPID();
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return ((PgConnection)this.mainConn).escapeIdentifier(identifier);
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return ((PgConnection)this.mainConn).escapeIdentifier(literal);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return ((PgConnection)this.mainConn).getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return ((PgConnection)this.mainConn).getAutosave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.autoSave = autoSave;
        ((PgConnection)this.mainConn).setAutosave(autoSave);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((PgConnection)_connection).setAutosave(autoSave);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public PGReplicationConnection getReplicationAPI() {
        return ((PgConnection)this.mainConn).getReplicationAPI();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.mainConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.mainConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.mainConn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.mainConn.createSQLXML();
    }

    @Override
    public void setClientInfo(String name, String _value) throws SQLClientInfoException {
        this.mainConn.setClientInfo(name, _value);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((PgConnection)_connection).setClientInfo(name, _value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setClientInfo(Properties propes) throws SQLClientInfoException {
        this._clientInfo = propes;
        this.mainConn.setClientInfo(propes);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((PgConnection)_connection).setClientInfo(propes);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.mainConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.mainConn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.mainConn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.mainConn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.schema = schema;
        ((PgConnection)this.mainConn).setSchema(schema);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            ((PgConnection)_connection).setSchema(schema);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return ((PgConnection)this.mainConn).getSchema();
    }

    @Override
    public void abort(Executor exec) throws SQLException {
        ((PgConnection)this.mainConn).abort(exec);
        List<Connection> _conns = this.getAllSlaveConn();
        for (Connection _connection : _conns) {
            if (_connection instanceof FakeConnection) continue;
            ((PgConnection)_connection).abort(exec);
        }
    }

    @Override
    public void setNetworkTimeout(Executor exec, int millisecs) throws SQLException {
        ((PgConnection)this.mainConn).setNetworkTimeout(exec, millisecs);
        List<Connection> _conns = this.getAllSlaveConn();
        for (int i = 0; i < _conns.size(); ++i) {
            if (_conns.get(i) instanceof FakeConnection) continue;
            try {
                ((PgConnection)_conns.get(i)).setNetworkTimeout(exec, millisecs);
                continue;
            }
            catch (SQLException e) {
                ((PgConnection)this.mainConn).setNetworkTimeout(exec, this.getNetworkTimeout());
                while (--i >= 0) {
                    ((PgConnection)_conns.get(i)).setNetworkTimeout(exec, this.getNetworkTimeout());
                }
                throw e;
            }
        }
        this.exec = exec;
        this.networkTimeout = millisecs;
        this.hasSetNetworkTimeout = true;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.hasSetNetworkTimeout) {
            return this.networkTimeout;
        }
        return PGProperty.SOCKET_TIMEOUT.getInt(this.m_pros) * 1000;
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        if (clz.isAssignableFrom(this.getClass())) {
            return clz.cast(this);
        }
        if (clz.isAssignableFrom(PgConnection.class)) {
            return this.mainConn.unwrap(clz);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        return this.mainConn.isWrapperFor(clz);
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        ((PgConnection)this.mainConn).execSQLQuery(s);
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return ((PgConnection)this.mainConn).getReplicationProtocol();
    }

    @Override
    public Object getObject(String type, String _value, byte[] byteValue) throws SQLException {
        return ((PgConnection)this.mainConn).getObject(type, _value, byteValue);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return ((PgConnection)this.mainConn).getTypeInfo();
    }

    @Override
    public boolean haveMinimumServerVersion(int version) {
        return ((PgConnection)this.mainConn).haveMinimumServerVersion(version);
    }

    @Override
    public boolean haveMinimumServerVersion(Version version) {
        return ((PgConnection)this.mainConn).haveMinimumServerVersion(version);
    }

    @Override
    public byte[] _encodeString(String str) throws SQLException {
        return ((PgConnection)this.mainConn)._encodeString(str);
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return ((PgConnection)this.mainConn).escapeString(str);
    }

    @Override
    public boolean getStandardConformingStrings() {
        return ((PgConnection)this.mainConn).getStandardConformingStrings();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return ((PgConnection)this.mainConn).getTimestampUtils();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return ((PgConnection)this.mainConn).getStringVarcharFlag();
    }

    @Override
    public TransactionState getTransactionState() {
        return ((PgConnection)this.mainConn).getTransactionState();
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return ((PgConnection)this.mainConn).binaryTransferSend(oid);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return ((PgConnection)this.mainConn).isColumnSanitiserDisabled();
    }

    @Override
    public void addTimerTask(TimerTask _timerTask, long milliSeconds) {
        ((PgConnection)this.mainConn).addTimerTask(_timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTas_keyStore() {
        ((PgConnection)this.mainConn).purgeTimerTas_keyStore();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return ((PgConnection)this.mainConn).getFieldMetadataCache();
    }

    @Override
    public CachedQuery createQuery(String _sql, boolean escapeProcessing, boolean isParameterized, String ... _columnNames) throws SQLException {
        return ((PgConnection)this.mainConn).createQuery(_sql, escapeProcessing, isParameterized, _columnNames);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
        ((PgConnection)this.mainConn).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        try {
            List<Connection> _conns = this.getAllSlaveConn();
            for (Connection _connection : _conns) {
                if (_connection instanceof FakeConnection) continue;
                ((PgConnection)_connection).setFlushCacheOnDeallocate(flushCacheOnDeallocate);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object elements) throws SQLException {
        return ((PgConnection)this.mainConn).createArrayOf(typeName, elements);
    }

    @Override
    public PGNotification[] getNotifications(int _timeoutMillis) throws SQLException {
        return ((PgConnection)this.mainConn).getNotifications(_timeoutMillis);
    }

    @Override
    public Map<String, String> getParameterStatuses() {
        return ((PgConnection)this.mainConn).getParameterStatuses();
    }

    @Override
    public String getParameterStatus(String parameterName) {
        return ((PgConnection)this.mainConn).getParameterStatus(parameterName);
    }

    @Override
    public boolean hintReadOnly() {
        return ((PgConnection)this.mainConn).hintReadOnly();
    }

    public void resetConnInfo() throws SQLException {
        if (!this._autoCommit) {
            this.setAutoCommit(this._autoCommit);
        }
        if (this._clientInfo != null) {
            this.setClientInfo(this._clientInfo);
        }
        if (this.readOnly) {
            this.setReadOnly(this.readOnly);
        }
        if (this.resultSetHoldability != 2) {
            this.setHoldability(this.resultSetHoldability);
        }
        if (this.level != 0) {
            this.setTransactionIsolation(this.level);
        }
        if (this.typemap != null) {
            this.setTypeMap(this.typemap);
        }
        if (this.networkTimeout != 0) {
            this.setNetworkTimeout(this.exec, this.networkTimeout);
        }
        if (this.autoSave != null) {
            this.setAutosave(this.autoSave);
        }
        if (this.fetchSize != 0) {
            this.setDefaultFetchSize(this.fetchSize);
        }
        if (!this.flushCacheOnDeallocate) {
            this.setFlushCacheOnDeallocate(this.flushCacheOnDeallocate);
        }
        if (this.threshold != 5) {
            this.setPrepareThreshold(this.threshold);
        }
        if (this.schema != null) {
            this.setSchema(this.schema);
        }
    }

    public void resetConnInfo(Connection _connection) throws SQLException {
        if (!(_connection instanceof PgConnection)) {
            return;
        }
        PgConnection _conn = (PgConnection)_connection;
        if (!this._autoCommit) {
            _conn.setAutoCommit(this._autoCommit);
        }
        if (this._clientInfo != null) {
            _conn.setClientInfo(this._clientInfo);
        }
        if (this.readOnly) {
            _conn.setReadOnly(this.readOnly);
        }
        if (this.resultSetHoldability != 2) {
            _conn.setHoldability(this.resultSetHoldability);
        }
        if (this.level != 0) {
            _conn.setTransactionIsolation(this.level);
        }
        if (this.typemap != null) {
            _conn.setTypeMap(this.typemap);
        }
        if (this.networkTimeout != 0) {
            _conn.setNetworkTimeout(this.exec, this.networkTimeout);
        }
        if (this.autoSave != null) {
            _conn.setAutosave(this.autoSave);
        }
        if (this.fetchSize != 0) {
            _conn.setDefaultFetchSize(this.fetchSize);
        }
        if (!this.flushCacheOnDeallocate) {
            _conn.setFlushCacheOnDeallocate(this.flushCacheOnDeallocate);
        }
        if (this.threshold != 5) {
            _conn.setPrepareThreshold(this.threshold);
        }
        if (this.schema != null) {
            _conn.setSchema(this.schema);
        }
    }

    @Override
    public String getCompatibleLevel() {
        return ((PgConnection)this.mainConn).getCompatibleLevel();
    }

    @Override
    public boolean isDatabaseSupportRowid() {
        return ((PgConnection)this.mainConn).isDatabaseSupportRowid();
    }
}

