/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;
import org.postgresql.core.PGStream;
import org.postgresql.gss.GSSCallbackHandler;
import org.postgresql.gss.GssAction;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class MakeGSS {
    public static void authenticate(PGStream pgStream, String _host, String userStr, String password, String jaasAppName, String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, SQLException {
        Exception _result;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS", new Object[0]);
        if (jaasAppName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            jaasAppName = "pgjdbc";
        }
        if (kerberosServerName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kerberosServerName = "postgresql";
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean performAuth = jaasLogin;
            GSSCredential gssCredential = null;
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Set<GSSCredential> gssCredsSet = subject.getPrivateCredentials(GSSCredential.class);
                if (!gssCredsSet.isEmpty() && gssCredsSet != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    gssCredential = gssCredsSet.iterator().next();
                    performAuth = false;
                }
            }
            if (performAuth) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LoginContext loginContext = new LoginContext(jaasAppName, new GSSCallbackHandler(userStr, password));
                loginContext.login();
                subject = loginContext.getSubject();
            }
            GssAction action = new GssAction(pgStream, gssCredential, _host, userStr, kerberosServerName, useSpnego, logServerErrorDetail);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _result = Subject.doAs(subject, action);
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (_result instanceof IOException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw (IOException)_result;
        }
        if (_result instanceof SQLException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw (SQLException)_result;
        }
        if (_result != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)_result);
        }
    }
}

