/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.postgresql.core.Encoding;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class HStoreConverter {
    public static Map<String, String> fromBytes(byte[] b, Encoding _encoding) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashMap<String, String> m = new HashMap<String, String>();
        int position = 0;
        int numElements = ByteConverter.int4(b, position);
        position += 4;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < numElements; ++i) {
                String value;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _keyLen = ByteConverter.int4(b, position);
                String _key = _encoding.decode(b, position += 4, _keyLen);
                int valueLen = ByteConverter.int4(b, position += _keyLen);
                position += 4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (valueLen == -1) {
                    value = null;
                } else {
                    value = _encoding.decode(b, position, valueLen);
                    position += valueLen;
                }
                m.put(_key, value);
            }
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
        return m;
    }

    public static byte[] toBytes(Map<?, ?> m, Encoding _encoding) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4 + 10 * m.size());
        byte[] lengBuf = new byte[4];
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(lengBuf, 0, m.size());
            baos.write(lengBuf);
            for (Map.Entry<?, ?> e : m.entrySet()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] _key = _encoding.encode(e.getKey().toString());
                ByteConverter.int4(lengBuf, 0, _key.length);
                baos.write(lengBuf);
                baos.write(_key);
                if (e.getValue() == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    ByteConverter.int4(lengBuf, 0, -1);
                    baos.write(lengBuf);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] value = _encoding.encode(e.getValue().toString());
                ByteConverter.int4(lengBuf, 0, value.length);
                baos.write(lengBuf);
                baos.write(value);
            }
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
        return baos.toByteArray();
    }

    public static String toString(Map<?, ?> map) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sbu = new StringBuilder(map.size() * 8);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            HStoreConverter.appendEscaped(sbu, e.getKey());
            sbu.append("=>");
            HStoreConverter.appendEscaped(sbu, e.getValue());
            sbu.append(", ");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.setLength(sbu.length() - 2);
        return sbu.toString();
    }

    private static void appendEscaped(StringBuilder sbu, Object value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (value != null) {
            sbu.append('\"');
            String s = value.toString();
            for (int position = 0; position < s.length(); ++position) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                char chr = s.charAt(position);
                if (chr == '\"' || chr == '\\') {
                    sbu.append('\\');
                }
                sbu.append(chr);
            }
            sbu.append('\"');
        } else {
            sbu.append("NULL");
        }
    }

    public static Map<String, String> fromString(String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashMap<String, String> m = new HashMap<String, String>();
        StringBuilder sbu = new StringBuilder();
        for (int position = 0; position < s.length(); ++position) {
            String value;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.setLength(0);
            int start = s.indexOf(34, position);
            int end = HStoreConverter.appendUntilQuote(sbu, s, start);
            String _key = sbu.toString();
            position = end + 3;
            if (s.charAt(position) == 'N') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = null;
                position += 4;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.setLength(0);
                end = HStoreConverter.appendUntilQuote(sbu, s, position);
                value = sbu.toString();
                position = end;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            m.put(_key, value);
        }
        return m;
    }

    private static int appendUntilQuote(StringBuilder sbu, String s, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ++position;
        while (position < s.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char chr = s.charAt(position);
            if (chr == '\"') break;
            if (chr == '\\') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                chr = s.charAt(++position);
            }
            sbu.append(chr);
            ++position;
        }
        return position;
    }
}

