/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3.replication;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.postgresql.copy.CopyDual;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ReplicationProtocol;
import org.postgresql.core.v3.replication.V3PGReplicationStream;
import org.postgresql.replication.PGReplicationStream;
import org.postgresql.replication.ReplicationType;
import org.postgresql.replication.fluent.CommonOptions;
import org.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import org.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import org.postgresql.util.GT;
import org.postgresql.util.LOGGER;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.TraceLogger;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private final QueryExecutor queryExecutorImpl;
    private final PGStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutorImpl, PGStream pgStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.queryExecutorImpl = queryExecutorImpl;
        this.pgStream = pgStream;
    }

    @Override
    public PGReplicationStream startLogical(LogicalReplicationOptions options) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String query = this.createStartLogicalQuery(options);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.initReplication(query, options, ReplicationType.LOGICAL);
    }

    @Override
    public PGReplicationStream startPhysical(PhysicalReplicationOptions options) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String query = this.createStartPhysicalQuery(options);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.initReplication(query, options, ReplicationType.PHYSICAL);
    }

    private PGReplicationStream initReplication(String query, CommonOptions options, ReplicationType replicType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LOGGER.log(Level.FINEST, " FE=> StartReplication(query: {0})", query);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.configureSocketTimeout(options);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CopyDual copyDual = (CopyDual)this.queryExecutorImpl.startCopy(query, true);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new V3PGReplicationStream(copyDual, options.getStartLSNPosition(), options.getStatusInterval(), replicType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _builder = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _builder.append("START_REPLICATION");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (options.getSlotName() != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _builder.append(" SLOT ").append(options.getSlotName());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _builder = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties slotOpts = options.getSlotOptions();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (slotOpts.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _builder.toString();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _builder.append(" (");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isFirst = true;
        for (String name : slotOpts.stringPropertyNames()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (isFirst) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isFirst = false;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _builder.append(", ");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _builder.append('\"');
            _builder.append(name).append('\"');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _builder.append(" ").append('\'');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _builder.append(slotOpts.getProperty(name)).append('\'');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _builder.append(")");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws PSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (options.getStatusInterval() == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        try {
            int minimalTimeOut;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int previousTimeOut = this.pgStream.getSocket().getSoTimeout();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (previousTimeOut > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                minimalTimeOut = Math.min(previousTimeOut, options.getStatusInterval());
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                minimalTimeOut = options.getStatusInterval();
            }
            if (this.pgStream.isUseDispatch()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
                this.pgStream.setSocketTimeout(1);
                LOGGER.log(Level.INFO, "socketTimeout is " + minimalTimeOut, new Object[0]);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
            }
            this.pgStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new PSQLException(GT.tr("The _connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

