/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.replication;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.postgresql.core.BaseConnection;
import org.postgresql.replication.PGReplicationConnection;
import org.postgresql.replication.fluent.ChainedCreateReplicationSlotBuilder;
import org.postgresql.replication.fluent.ChainedStreamBuilder;
import org.postgresql.replication.fluent.ReplicationCreateSlotBuilder;
import org.postgresql.replication.fluent.ReplicationStreamBuilder;
import org.postgresql.util.TraceLogger;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection baseConnection;

    public PGReplicationConnectionImpl(BaseConnection _connection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConnection = _connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ReplicationStreamBuilder replicationStreamBuilder = new ReplicationStreamBuilder(this.baseConnection);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return replicationStreamBuilder;
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ReplicationCreateSlotBuilder replicationCreateSlotBuilder = new ReplicationCreateSlotBuilder(this.baseConnection);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return replicationCreateSlotBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropReplicationSlot(String _slotName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_slotName == null || _slotName.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stmt = this.baseConnection.createStatement();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String tmpStr = "DROP_REPLICATION_SLOT ";
            stmt.execute(tmpStr + _slotName);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stmt.close();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }
}

