/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.AbstractBlobClob;
import org.postgresql.util.TraceLogger;

public class PgClob
extends AbstractBlobClob
implements Clob {
    public PgClob(BaseConnection _conn, long oid) throws SQLException {
        super(_conn, oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public synchronized Reader getCharacterStream(long position, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(long, long)");
    }

    @Override
    public synchronized int setString(long position, String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setString(long,str)");
    }

    @Override
    public synchronized int setString(long position, String str, int _offset, int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setString(long,String,int,int)");
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBinaryStream();
    }

    @Override
    public synchronized OutputStream setAsciiStream(long position) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(long)");
    }

    @Override
    public synchronized Writer setCharacterStream(long position) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setCharacteStream(long)");
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Charset charset = Charset.forName(this.baseConnection.getEncoding().name());
        InputStreamReader v = new InputStreamReader(this.getBinaryStream(), charset);
        return v;
    }

    @Override
    public synchronized String getSubString(long index, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkPosition(index, length);
        this.getLo(false).seek((int)index - 1);
        String v = new String(this.getLo(false).read(length));
        return v;
    }

    @Override
    public synchronized long position(String pat, long start) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "position(String,long)");
    }

    @Override
    public synchronized long position(Clob pat, long start) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "position(Clob,start)");
    }
}

