/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.postgresql.ssl.WrappedFactory;
import org.postgresql.util.TraceLogger;

public abstract class DbKeyStoreSocketFactory
extends WrappedFactory {
    public DbKeyStoreSocketFactory() throws DbKeyStoreSocketException {
        char[] password;
        KeyStore keyStores;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s1 = "Failed to load keyStorestore: ";
        String s2 = "Failed to find keyStorestore file.";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s3 = "Failed to read keyStorestore file: ";
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            keyStores = KeyStore.getInstance("JKS");
            password = this.getKeyStorePwd();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            keyStores.load(this.getKeyStoreInputStream(), password);
        }
        catch (GeneralSecurityException generalSecurityException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new DbKeyStoreSocketException("Failed to load keyStorestore: " + generalSecurityException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new DbKeyStoreSocketException("Failed to find keyStorestore file." + fileNotFoundException.getMessage());
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new DbKeyStoreSocketException("Failed to read keyStorestore file: " + ioe.getMessage());
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String keyManagerDefaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyMgefactoryT = KeyManagerFactory.getInstance(keyManagerDefaultAlgorithm);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            keyMgefactoryT.init(keyStores, password);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String trustManagerDefaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustfact = TrustManagerFactory.getInstance(trustManagerDefaultAlgorithm);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            trustfact.init(keyStores);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SSLContext contextSSL = SSLContext.getInstance("SSL");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            contextSSL.init(keyMgefactoryT.getKeyManagers(), trustfact.getTrustManagers(), null);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sslSocketFactory = contextSSL.getSocketFactory();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (GeneralSecurityException generalSecurityException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "Failed to set up database socket factory: ";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new DbKeyStoreSocketException("Failed to set up database socket factory: " + generalSecurityException.getMessage());
        }
    }

    public abstract char[] getKeyStorePwd();

    public abstract InputStream getKeyStoreInputStream();

    public static class DbKeyStoreSocketException
    extends Exception {
        public DbKeyStoreSocketException(String msg) {
            super(msg);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }
}

