/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import org.postgresql.util.PGobject;
import org.postgresql.util.TraceLogger;

public class YMInterval
extends PGobject {
    private static int monthOffset = 60;
    private static int maxMonth = 12;
    private byte[] bytes;
    private static int maxLength = 5;
    private static int yearOffset = Integer.MIN_VALUE;
    private static int maxYearPrec = 9;

    public YMInterval() {
        this.setType("yminterval");
        this.bytes = YMInterval.initYMInterval();
        this._value = YMInterval.toString(this.bytes);
    }

    public YMInterval(byte[] bytes) {
        this.setType("yminterval");
        this.bytes = bytes;
        this._value = YMInterval.toString(this.bytes);
    }

    public YMInterval(String s) {
        this.setType("yminterval");
        this.bytes = YMInterval.toBytes(s);
        this._value = YMInterval.toString(this.bytes);
    }

    public static boolean isYMInterval(String s) {
        return s.indexOf("years") <= 0 && s.indexOf("mons") <= 0 && s.indexOf("year") <= 0 && s.indexOf("mon") <= 0;
    }

    @Override
    public String toString() {
        return YMInterval.toString(this.bytes);
    }

    @Override
    public void setValue(String s) throws SQLException {
        this.bytes = YMInterval.toBytes(s);
        super.setValue(YMInterval.toString(this.bytes));
    }

    public static byte[] toBytes(String s) {
        int var2;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] bytes = new byte[maxLength];
        String trimValue = s.trim();
        char charFirst = trimValue.charAt(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (charFirst != '-' && charFirst != '+') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            var2 = 0;
        } else {
            var2 = 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        trimValue = trimValue.substring(var2);
        int splitIndex = trimValue.indexOf(45);
        String var6 = trimValue.substring(0, splitIndex);
        if (var6.length() > maxYearPrec) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int var7 = Integer.valueOf(var6);
        String var8 = trimValue.substring(splitIndex + 1);
        int var9 = Integer.valueOf(var8);
        if (var9 >= maxMonth) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (charFirst == '-') {
            var7 = -1 * var7;
            var9 = -1 * var9;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        bytes[0] = (byte)((var7 += yearOffset) >> 24 & 0xFF);
        bytes[1] = (byte)(var7 >> 16 & 0xFF);
        bytes[2] = (byte)(var7 >> 8 & 0xFF);
        bytes[3] = (byte)(var7 & 0xFF);
        bytes[4] = (byte)(var9 + monthOffset);
        return bytes;
    }

    public static String toString(byte[] bytesValue) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (bytesValue != null && bytesValue.length != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean isPositive = true;
            int var3 = (bytesValue[0] & 0xFF) << 24;
            var3 |= (bytesValue[1] & 0xFF) << 16;
            var3 |= (bytesValue[2] & 0xFF) << 8;
            var3 |= bytesValue[3] & 0xFF;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int var4 = bytesValue[4] - monthOffset;
            if ((var3 -= yearOffset) < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var3 = -var3;
            }
            if (var4 < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isPositive = false;
                var4 = -var4;
            }
            String var1 = var3 + "-" + var4;
            if (!isPositive) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                var1 = "-" + var1;
            }
            return var1;
        }
        return new String();
    }

    private static byte[] initYMInterval() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] bytes = new byte[maxLength];
        int var1 = 0;
        int var2 = 0;
        int offsetYMYear = var1 + yearOffset;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        bytes[0] = (byte)(offsetYMYear >> 24 & 0xFF);
        bytes[1] = (byte)(offsetYMYear >> 16 & 0xFF);
        bytes[2] = (byte)(offsetYMYear >> 8 & 0xFF);
        bytes[3] = (byte)(offsetYMYear & 0xFF);
        bytes[4] = (byte)(var2 + monthOffset);
        return bytes;
    }
}

