/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.sql.SQLException;
import org.postgresql.copy.CopyOperation;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class CopyOperationImpl
implements CopyOperation {
    QueryExecutorImpl queryExecutor;
    int rowFormat;
    int[] fieldFormats;
    long handledRowCount = -1L;
    long skippedErrorRowCount = -1L;

    void init(QueryExecutorImpl q, int fmt, int[] fmts) {
        this.queryExecutor = q;
        this.rowFormat = fmt;
        this.fieldFormats = fmts;
    }

    @Override
    public void cancelCopy() throws SQLException {
        this.queryExecutor.cancelCopy(this);
    }

    @Override
    public int getFieldCount() {
        return this.fieldFormats.length;
    }

    @Override
    public int getFieldFormat(int field) {
        return this.fieldFormats[field];
    }

    @Override
    public int getFormat() {
        return this.rowFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        QueryExecutorImpl queryExecutorImpl = this.queryExecutor;
        synchronized (queryExecutorImpl) {
            return this.queryExecutor.hasLock(this);
        }
    }

    public void handleCommandStatus(String status) throws PSQLException {
        if (status.startsWith("COPY")) {
            int i = status.lastIndexOf(32);
            this.handledRowCount = i > 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
        } else if (status.startsWith("SKIPPED")) {
            int i = status.indexOf(32);
            int i2 = status.indexOf(32, i + 1);
            this.skippedErrorRowCount = i > 3 ? Long.parseLong(status.substring(i + 1, i2)) : -1L;
            i = status.lastIndexOf(32);
            this.handledRowCount = i > status.indexOf("COPY") + 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
        } else {
            throw new PSQLException(GT.tr("CommandComplete expected COPY but got: " + status, new Object[0]), PSQLState.COMMUNICATION_ERROR);
        }
    }

    protected abstract void handleCopydata(byte[] var1) throws PSQLException;

    @Override
    public long getHandledRowCount() {
        return this.handledRowCount;
    }

    @Override
    public long getSkippedErrorRowCount() {
        return this.skippedErrorRowCount;
    }
}

